/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.util.Interval;
import net.sf.samtools.SAMSequenceDictionary;

public class IntervalUtil {
    public static void assertOrderedNonOverlapping(Iterator<Interval> iterator2, SAMSequenceDictionary sAMSequenceDictionary) {
        if (!iterator2.hasNext()) {
            return;
        }
        Interval interval = iterator2.next();
        int n = sAMSequenceDictionary.getSequenceIndex(interval.getSequence());
        while (iterator2.hasNext()) {
            Interval interval2 = iterator2.next();
            if (interval.intersects(interval2)) {
                throw new PicardException("Intervals should not overlap: " + interval + "; " + interval2);
            }
            int n2 = sAMSequenceDictionary.getSequenceIndex(interval2.getSequence());
            if (n > n2 || n == n2 && interval.compareTo(interval2) >= 0) {
                throw new PicardException("Intervals not in order: " + interval + "; " + interval2);
            }
            interval = interval2;
            n = n2;
        }
    }
}

