/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.EnumSet;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;

public class SplitVcfs
extends CommandLineProgram {
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Splits an input VCF or BCF file into two VCF files, one for indel records and one for SNPs. The" + "headers of the two output files will be identical. An index file is created and a" + "sequence dictionary is required by default.";
    @Option(shortName="I", doc="The VCF or BCF input file")
    public File INPUT;
    @Option(doc="The VCF or BCF file to which SNP records should be written. The file format is determined by file extension.")
    public File SNP_OUTPUT;
    @Option(doc="The VCF or BCF file to which indel records should be written. The file format is determined by file extension.")
    public File INDEL_OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionaries in the input files", optional=true)
    public File SEQUENCE_DICTIONARY;
    @Option(doc="If true an exception will be thrown if an event type other than SNP or indel is encountered")
    public Boolean STRICT = true;
    private final Log log = Log.getInstance(SplitVcfs.class);

    public static void main(String[] stringArray) {
        new SplitVcfs().instanceMainWithExit(stringArray);
    }

    public SplitVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sAMSequenceDictionary;
        IoUtil.assertFileIsReadable(this.INPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        SAMSequenceDictionary sAMSequenceDictionary2 = sAMSequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SAMFileReader.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter variantContextWriter = VariantContextWriterFactory.create(this.SNP_OUTPUT, sAMSequenceDictionary, enumSet);
        VariantContextWriter variantContextWriter2 = VariantContextWriterFactory.create(this.INDEL_OUTPUT, sAMSequenceDictionary, enumSet);
        variantContextWriter.writeHeader(vCFHeader);
        variantContextWriter2.writeHeader(vCFHeader);
        int n = 0;
        Iterator iterator2 = vCFFileReader.iterator();
        while (iterator2.hasNext()) {
            VariantContext variantContext = (VariantContext)iterator2.next();
            if (variantContext.isIndel()) {
                variantContextWriter2.add(variantContext);
            } else if (variantContext.isSNP()) {
                variantContextWriter.add(variantContext);
            } else {
                if (this.STRICT.booleanValue()) {
                    throw new IllegalStateException("Found a record with type " + variantContext.getType().name());
                }
                ++n;
            }
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        if (n > 0) {
            this.log.debug("Found " + n + " records that didn't match SNP or INDEL");
        }
        CloserUtil.close(iterator2);
        CloserUtil.close(vCFFileReader);
        variantContextWriter.close();
        variantContextWriter2.close();
        return 0;
    }
}

