/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.PeekIterator;

public class SecondaryOrSupplementarySkippingIterator {
    private final PeekIterator<SAMRecord> it;

    public SecondaryOrSupplementarySkippingIterator(CloseableIterator<SAMRecord> closeableIterator) {
        this.it = new PeekIterator<SAMRecord>(closeableIterator);
        this.skipAnyNotprimary();
    }

    public boolean hasCurrent() {
        return this.it.hasNext();
    }

    public SAMRecord getCurrent() {
        assert (this.hasCurrent());
        return this.it.peek();
    }

    public boolean advance() {
        this.it.next();
        this.skipAnyNotprimary();
        return this.hasCurrent();
    }

    private void skipAnyNotprimary() {
        while (this.it.hasNext() && this.it.peek().isSecondaryOrSupplementary()) {
            this.it.next();
        }
    }
}

