/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.samtools.util.BinaryCodec;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;
    public static final String EMPTY_STRING = "";

    public static <T> String join(String string2, Collection<T> collection) {
        if (collection.size() == 0) {
            return EMPTY_STRING;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : collection) {
            if (bl) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(t.toString());
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static <T> String join(String string2, T ... TArray) {
        List<T> list = Arrays.asList(TArray);
        return StringUtil.join(string2, list);
    }

    public static int split(String string2, String[] stringArray, char c) {
        String string3;
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = string2.indexOf(c);
        if (n4 < 0) {
            stringArray[n2++] = string2;
            return n2;
        }
        while (n4 > 0 && n2 < n) {
            stringArray[n2++] = string2.substring(n3, n4);
            n3 = n4 + 1;
            n4 = string2.indexOf(c, n3);
        }
        if (n2 < n && (string3 = string2.substring(n3)).length() > 0) {
            stringArray[n2++] = string3;
        }
        return n2;
    }

    public static int splitConcatenateExcessTokens(String string2, String[] stringArray, char c) {
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = string2.indexOf(c);
        if (n4 < 0) {
            stringArray[n2++] = string2;
            return n2;
        }
        while (n4 > 0 && n2 < n - 1) {
            stringArray[n2++] = string2.substring(n3, n4);
            n3 = n4 + 1;
            n4 = string2.indexOf(c, n3);
        }
        String string3 = string2.substring(n3);
        if (string3.length() > 0) {
            stringArray[n2++] = string3;
        }
        return n2;
    }

    public static byte toLowerCase(byte by2) {
        if (by2 < 65 || by2 > 90) {
            return by2;
        }
        return (byte)(by2 - -32);
    }

    public static byte toUpperCase(byte by2) {
        if (by2 < 97 || by2 > 122) {
            return by2;
        }
        return (byte)(by2 + -32);
    }

    public static void toUpperCase(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < 97 || byArray[i] > 122) continue;
            byArray[i] = (byte)(byArray[i] + -32);
        }
    }

    public static String assertCharactersNotInString(String string2, char ... cArray) {
        for (char c : string2.toCharArray()) {
            for (char c2 : cArray) {
                if (c != c2) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + c + "'.");
            }
        }
        return string2;
    }

    public static String wordWrap(String string2, int n) {
        String[] stringArray = string2.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(StringUtil.wordWrapSingleLine(string3, n));
        }
        if (string2.endsWith("\n")) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String wordWrapSingleLine(String string2, int n) {
        if (string2.length() <= n) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string2.length()) {
            int n3;
            int n4 = n2;
            for (n3 = n2; n3 < string2.length() && n3 - n2 < n; ++n3) {
                if (!Character.isWhitespace(string2.charAt(n3))) continue;
                n4 = n3;
            }
            if (n3 - n2 < n) {
                n4 = n3;
            }
            while (n4 < string2.length() && Character.isWhitespace(string2.charAt(n4))) {
                ++n4;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            if (n4 == n2) {
                n4 = n3;
            }
            stringBuilder.append(string2.substring(n2, n4));
            n2 = n4;
        }
        return stringBuilder.toString();
    }

    public static String intValuesToString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length);
        if (nArray.length > 0) {
            stringBuilder.append(String.valueOf(nArray[0]));
            for (int i = 1; i < nArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(String.valueOf(nArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public static String intValuesToString(short[] sArray) {
        StringBuilder stringBuilder = new StringBuilder(sArray.length);
        if (sArray.length > 0) {
            stringBuilder.append(String.valueOf(sArray[0]));
            for (int i = 1; i < sArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(String.valueOf(sArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public static String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return StringUtil.bytesToString(byArray, 0, byArray.length);
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        return new String(byArray, 0, n, n2);
    }

    public static byte[] stringToBytes(String string2) {
        byte[] byArray = new byte[string2.length()];
        string2.getBytes(0, byArray.length, byArray, 0);
        return byArray;
    }

    public static byte[] stringToBytes(String string2, int n, int n2) {
        byte[] byArray = new byte[n2];
        string2.getBytes(n, n + n2, byArray, 0);
        return byArray;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder stringBuilder = new StringBuilder();
        byte by2 = binaryCodec.readByte();
        while (by2 != 0) {
            stringBuilder.append((char)(by2 & 0xFF));
            by2 = binaryCodec.readByte();
        }
        return stringBuilder.toString();
    }

    public static void charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            byArray[n3 + i] = (byte)cArray[n + i];
        }
    }

    public static byte charToByte(char c) {
        return (byte)c;
    }

    public static char byteToChar(byte by2) {
        return (char)(by2 & 0xFF);
    }

    public static String bytesToHexString(byte[] byArray) {
        char[] cArray = new char[2 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byte by2 = byArray[i];
            cArray[2 * i] = StringUtil.toHexDigit(by2 >> 4 & 0xF);
            cArray[2 * i + 1] = StringUtil.toHexDigit(by2 & 0xF);
        }
        return new String(cArray);
    }

    public static byte[] hexStringToBytes(String string2) throws NumberFormatException {
        if (string2.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + string2);
        }
        byte[] byArray = new byte[string2.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(StringUtil.fromHexDigit(string2.charAt(i * 2)) << 4 | StringUtil.fromHexDigit(string2.charAt(i * 2 + 1)));
        }
        return byArray;
    }

    public static char toHexDigit(int n) {
        return (char)(n < 10 ? 48 + n : 65 + n - 10);
    }

    public static int fromHexDigit(char c) throws NumberFormatException {
        int n = Character.digit(c, 16);
        if (n == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c);
        }
        return n;
    }

    public static String reverseString(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.reverse();
        return stringBuilder.toString();
    }

    public static boolean isBlank(String string2) {
        int n;
        if (string2 == null || (n = string2.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeatCharNTimes(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return String.valueOf(cArray);
    }

    public static String asEmptyIfNull(Object object) {
        return object == null ? EMPTY_STRING : object.toString();
    }
}

