/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.util.TimeoutObserver;

public class Watchdog
implements Runnable {
    private Vector observers = new Vector(1);
    private long timeout = -1L;
    private volatile boolean stopped = false;
    public static final String ERROR_INVALID_TIMEOUT = "timeout less than 1.";

    public Watchdog(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException(ERROR_INVALID_TIMEOUT);
        }
        this.timeout = timeout;
    }

    public void addTimeoutObserver(TimeoutObserver to2) {
        this.observers.addElement(to2);
    }

    public void removeTimeoutObserver(TimeoutObserver to2) {
        this.observers.removeElement(to2);
    }

    protected final void fireTimeoutOccured() {
        Enumeration e = this.observers.elements();
        while (e.hasMoreElements()) {
            ((TimeoutObserver)e.nextElement()).timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized void run() {
        long now = System.currentTimeMillis();
        long until2 = now + this.timeout;
        try {
            while (!this.stopped && until2 > now) {
                this.wait(until2 - now);
                now = System.currentTimeMillis();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!this.stopped) {
            this.fireTimeoutOccured();
        }
    }
}

