/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LittleEndianOutputStream
extends FilterOutputStream {
    protected long written;

    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += (long)n2;
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.written += 2L;
    }

    public void writeChar(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.written += 2L;
    }

    public void writeInt(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 24 & 0xFF);
        this.written += 4L;
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.written += 8L;
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String string2) throws IOException {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string2.charAt(i));
        }
        this.written += (long)n;
    }

    public void writeString(String string2) throws IOException {
        this.writeBytes(string2);
        this.write(0);
    }

    public long getWrittenCount() {
        return this.written;
    }

    public void setWrittenCount(long l) {
        this.written = l;
    }
}

