/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.broadinstitute.rnai.poolq.gui.PoolQRunCancelledListener;
import org.broadinstitute.rnai.poolq.gui.SwingUtils;

class ProgressIndicatorDialog
extends JDialog {
    private final PoolQRunCancelledListener poolQRunCancelledListener;

    ProgressIndicatorDialog(JFrame jFrame, PoolQRunCancelledListener poolQRunCancelledListener) {
        super(jFrame);
        this.poolQRunCancelledListener = poolQRunCancelledListener;
        this.setModal(true);
        this.setTitle("Running PoolQ...");
        this.getContentPane().add(this.createMainPanel(jFrame));
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    private Component createMainPanel(JFrame jFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        JLabel jLabel = new JLabel("PoolQ is running. This may take a while. Please be patient!");
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressIndicatorDialog.this.confirmCancel()) {
                    ProgressIndicatorDialog.this.poolQRunCancelledListener.poolQRunCancelled();
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(5));
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel.add(jProgressBar);
        return jPanel;
    }

    private boolean confirmCancel() {
        int n = JOptionPane.showConfirmDialog(this.getParent(), "Are you sure you want to cancel the current PoolQ analysis?", "Confirm Cancel", 0, 3);
        return n == 0;
    }
}

