/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class ConditionsFileParserException
extends PoolQException {
    private final int lineNumber;
    private final String line;

    public ConditionsFileParserException(String string2, int n, String[] stringArray) {
        super("Error parsing conditions file (line " + n + "): " + string2);
        this.lineNumber = n;
        this.line = TextUtils.join(stringArray, ',');
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public static class EmptyConditionsFileException
    extends ConditionsFileParserException {
        public EmptyConditionsFileException(String string2, int n) {
            super(string2, n, new String[0]);
        }
    }

    public static class VariableBarcodeLengthException
    extends ConditionsFileParserException {
        public VariableBarcodeLengthException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }

    public static class DuplicateBarcodeException
    extends ConditionsFileParserException {
        public DuplicateBarcodeException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }

    public static class BadBarcodeException
    extends ConditionsFileParserException {
        public BadBarcodeException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }

    public static class IncorrectNumberOfColumnsException
    extends ConditionsFileParserException {
        public IncorrectNumberOfColumnsException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }
}

