/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sf.samtools.SAMException;

public class Md5CalculatingInputStream
extends InputStream {
    private final InputStream is;
    private final MessageDigest md5;
    private final File digestFile;
    private String hash;

    public Md5CalculatingInputStream(InputStream inputStream, File file) {
        this.is = inputStream;
        this.digestFile = file;
        this.hash = null;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.md5.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("MD5 algorithm not found", noSuchAlgorithmException);
        }
    }

    @Override
    public int read() throws IOException {
        int n = this.is.read();
        if (n != -1) {
            this.md5.update((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.is.read(byArray);
        if (n != -1) {
            this.md5.update(byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        if (n3 != -1) {
            this.md5.update(byArray, n, n3);
        }
        return n3;
    }

    public String md5() {
        if (this.hash == null) {
            throw new SAMException("Attempting to access md5 digest before the entire file is read!  Call close first.");
        }
        return this.hash;
    }

    private String makeHash() {
        if (this.hash == null) {
            this.hash = new BigInteger(1, this.md5.digest()).toString(16);
            if (this.hash.length() != 32) {
                this.hash = "00000000000000000000000000000000".substring(0, 32 - this.hash.length()) + this.hash;
            }
            return this.hash;
        }
        throw new SAMException("MD5InputStream is already closed!");
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.makeHash();
        if (this.digestFile != null) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.digestFile));
            bufferedWriter.write(this.hash);
            bufferedWriter.close();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
        throw new UnsupportedOperationException("mark() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException("skip() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }
}

