/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.VectorSet;

public class Ant
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File dir = null;
    private String antFile = null;
    private String output = null;
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Project newProject;
    private PrintStream out = null;
    private Vector propertySets = new Vector();
    private Vector targets = new Vector();
    private boolean targetAttributeSet = false;
    private boolean useNativeBasedir = false;

    public Ant() {
    }

    public Ant(Task owner) {
        this.bindToOwner(owner);
    }

    public void setUseNativeBasedir(boolean b) {
        this.useNativeBasedir = b;
    }

    public void setInheritAll(boolean value) {
        this.inheritAll = value;
    }

    public void setInheritRefs(boolean value) {
        this.inheritRefs = value;
    }

    public void init() {
        this.newProject = this.getProject().createSubProject();
        this.newProject.setJavaVersionProperty();
    }

    private void reinit() {
        this.init();
    }

    private void initializeProject() {
        this.newProject.setInputHandler(this.getProject().getInputHandler());
        Iterator iter2 = this.getBuildListeners();
        while (iter2.hasNext()) {
            this.newProject.addBuildListener((BuildListener)iter2.next());
        }
        if (this.output != null) {
            File outfile = null;
            outfile = this.dir != null ? FILE_UTILS.resolveFile(this.dir, this.output) : this.getProject().resolveFile(this.output);
            try {
                this.out = new PrintStream(new FileOutputStream(outfile));
                DefaultLogger logger = new DefaultLogger();
                logger.setMessageOutputLevel(2);
                logger.setOutputPrintStream(this.out);
                logger.setErrorPrintStream(this.out);
                this.newProject.addBuildListener(logger);
            }
            catch (IOException ex) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        if (this.useNativeBasedir) {
            this.addAlmostAll(this.getProject().getUserProperties(), PropertyType.USER);
        } else {
            this.getProject().copyUserProperties(this.newProject);
        }
        if (!this.inheritAll) {
            this.newProject.initProperties();
        } else {
            this.addAlmostAll(this.getProject().getProperties(), PropertyType.PLAIN);
        }
        Enumeration e = this.propertySets.elements();
        while (e.hasMoreElements()) {
            PropertySet ps = (PropertySet)e.nextElement();
            this.addAlmostAll(ps.getProperties(), PropertyType.PLAIN);
        }
    }

    public void handleOutput(String outputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(outputToHandle, false);
        } else {
            super.handleOutput(outputToHandle);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    public void handleFlush(String toFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(toFlush, false);
        } else {
            super.handleFlush(toFlush);
        }
    }

    public void handleErrorOutput(String errorOutputToHandle) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(errorOutputToHandle, true);
        } else {
            super.handleErrorOutput(errorOutputToHandle);
        }
    }

    public void handleErrorFlush(String errorOutputToFlush) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(errorOutputToFlush, true);
        } else {
            super.handleErrorFlush(errorOutputToFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() throws BuildException {
        String savedAntFile;
        File savedDir;
        block30: {
            Enumeration e2222;
            savedDir = this.dir;
            savedAntFile = this.antFile;
            VectorSet locals = new VectorSet((Collection)this.targets);
            try {
                block29: {
                    String defaultTarget;
                    this.getNewProject();
                    if (this.dir == null && this.inheritAll) {
                        this.dir = this.getProject().getBaseDir();
                    }
                    this.initializeProject();
                    if (this.dir != null) {
                        if (!this.useNativeBasedir) {
                            this.newProject.setBaseDir(this.dir);
                            if (savedDir != null) {
                                this.newProject.setInheritedProperty("basedir", this.dir.getAbsolutePath());
                            }
                        }
                    } else {
                        this.dir = this.getProject().getBaseDir();
                    }
                    this.overrideProperties();
                    if (this.antFile == null) {
                        this.antFile = this.getDefaultBuildFile();
                    }
                    File file = FILE_UTILS.resolveFile(this.dir, this.antFile);
                    this.antFile = file.getAbsolutePath();
                    this.log("calling target(s) " + (locals.size() > 0 ? locals.toString() : "[default]") + " in build file " + this.antFile, 3);
                    this.newProject.setUserProperty("ant.file", this.antFile);
                    String thisAntFile = this.getProject().getProperty("ant.file");
                    if (thisAntFile != null && file.equals(this.getProject().resolveFile(thisAntFile)) && this.getOwningTarget() != null && this.getOwningTarget().getName().equals("")) {
                        if (this.getTaskName().equals("antcall")) {
                            throw new BuildException("antcall must not be used at the top level.");
                        }
                        throw new BuildException(this.getTaskName() + " task at the" + " top level must not invoke" + " its own build file.");
                    }
                    try {
                        ProjectHelper.configureProject(this.newProject, file);
                    }
                    catch (BuildException ex) {
                        throw ProjectHelper.addLocationToBuildException(ex, this.getLocation());
                    }
                    if (locals.size() == 0 && (defaultTarget = this.newProject.getDefaultTarget()) != null) {
                        ((Vector)locals).add(defaultTarget);
                    }
                    if (this.newProject.getProperty("ant.file").equals(this.getProject().getProperty("ant.file")) && this.getOwningTarget() != null) {
                        boolean circular;
                        Target other;
                        String owningTargetName = this.getOwningTarget().getName();
                        if (((Vector)locals).contains(owningTargetName)) {
                            throw new BuildException(this.getTaskName() + " task calling " + "its own parent target.");
                        }
                        Iterator it = locals.iterator();
                        for (circular = false; !circular && it.hasNext(); circular |= (other = (Target)this.getProject().getTargets().get(it.next())) != null && other.dependsOn(owningTargetName)) {
                        }
                        if (circular) {
                            throw new BuildException(this.getTaskName() + " task calling a target" + " that depends on" + " its parent target '" + owningTargetName + "'.");
                        }
                    }
                    this.addReferences();
                    if (!(locals.size() <= 0 || locals.size() == 1 && "".equals(locals.get(0)))) {
                        BuildException be = null;
                        try {
                            this.log("Entering " + this.antFile + "...", 3);
                            this.newProject.fireSubBuildStarted();
                            this.newProject.executeTargets(locals);
                            Object var11_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            this.log("Exiting " + this.antFile + ".", 3);
                            this.newProject.fireSubBuildFinished(be);
                            throw throwable;
                        }
                        this.log("Exiting " + this.antFile + ".", 3);
                        this.newProject.fireSubBuildFinished(be);
                        {
                            break block29;
                            catch (BuildException ex) {
                                be = ProjectHelper.addLocationToBuildException(ex, this.getLocation());
                                throw be;
                            }
                        }
                    }
                }
                Object var13_15 = null;
                this.newProject = null;
                e2222 = this.properties.elements();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.newProject = null;
                Enumeration e2222 = this.properties.elements();
                while (e2222.hasMoreElements()) {
                    Property p = (Property)e2222.nextElement();
                    p.setProject(null);
                }
                if (this.output != null && this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.dir = savedDir;
                this.antFile = savedAntFile;
                throw throwable;
            }
            while (e2222.hasMoreElements()) {
                Property p = (Property)e2222.nextElement();
                p.setProject(null);
            }
            if (this.output != null && this.out != null) {
                try {
                    this.out.close();
                    break block30;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                {
                }
            }
        }
        this.dir = savedDir;
        this.antFile = savedAntFile;
    }

    protected String getDefaultBuildFile() {
        return "build.xml";
    }

    private void overrideProperties() throws BuildException {
        Property p;
        HashSet<String> set = new HashSet<String>();
        for (int i = this.properties.size() - 1; i >= 0; --i) {
            p = (Property)this.properties.get(i);
            if (p.getName() == null || p.getName().equals("")) continue;
            if (set.contains(p.getName())) {
                this.properties.remove(i);
                continue;
            }
            set.add(p.getName());
        }
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            p = (Property)e.nextElement();
            p.setProject(this.newProject);
            p.execute();
        }
        if (this.useNativeBasedir) {
            this.addAlmostAll(this.getProject().getInheritedProperties(), PropertyType.INHERITED);
        } else {
            this.getProject().copyInheritedProperties(this.newProject);
        }
    }

    private void addReferences() throws BuildException {
        Enumeration<Object> e;
        Hashtable thisReferences = (Hashtable)this.getProject().getReferences().clone();
        Hashtable newReferences = this.newProject.getReferences();
        if (this.references.size() > 0) {
            e = this.references.elements();
            while (e.hasMoreElements()) {
                Reference ref = (Reference)e.nextElement();
                String refid = ref.getRefId();
                if (refid == null) {
                    throw new BuildException("the refid attribute is required for reference elements");
                }
                if (!thisReferences.containsKey(refid)) {
                    this.log("Parent project doesn't contain any reference '" + refid + "'", 1);
                    continue;
                }
                thisReferences.remove(refid);
                String toRefid = ref.getToRefid();
                if (toRefid == null) {
                    toRefid = refid;
                }
                this.copyReference(refid, toRefid);
            }
        }
        if (this.inheritRefs) {
            e = thisReferences.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (newReferences.containsKey(key)) continue;
                this.copyReference(key, key);
                this.newProject.inheritIDReferences(this.getProject());
            }
        }
    }

    private void copyReference(String oldKey, String newKey) {
        Object orig = this.getProject().getReference(oldKey);
        if (orig == null) {
            this.log("No object referenced by " + oldKey + ". Can't copy to " + newKey, 1);
            return;
        }
        Class<?> c = orig.getClass();
        Object copy = orig;
        try {
            Method cloneM = c.getMethod("clone", new Class[0]);
            if (cloneM != null) {
                copy = cloneM.invoke(orig, new Object[0]);
                this.log("Adding clone of reference " + oldKey, 4);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (copy instanceof ProjectComponent) {
            ((ProjectComponent)copy).setProject(this.newProject);
        } else {
            try {
                Method setProjectM = c.getMethod("setProject", Project.class);
                if (setProjectM != null) {
                    setProjectM.invoke(copy, this.newProject);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e2) {
                String msg = "Error setting new project instance for reference with id " + oldKey;
                throw new BuildException(msg, e2, this.getLocation());
            }
        }
        this.newProject.addReference(newKey, copy);
    }

    private void addAlmostAll(Hashtable props, PropertyType type) {
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if ("basedir".equals(key) || "ant.file".equals(key)) continue;
            String value = props.get(key).toString();
            if (type == PropertyType.PLAIN) {
                if (this.newProject.getProperty(key) != null) continue;
                this.newProject.setNewProperty(key, value);
                continue;
            }
            if (type == PropertyType.USER) {
                this.newProject.setUserProperty(key, value);
                continue;
            }
            if (type != PropertyType.INHERITED) continue;
            this.newProject.setInheritedProperty(key, value);
        }
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setAntfile(String antFile) {
        this.antFile = antFile;
    }

    public void setTarget(String targetToAdd) {
        if (targetToAdd.equals("")) {
            throw new BuildException("target attribute must not be empty");
        }
        this.targets.add(targetToAdd);
        this.targetAttributeSet = true;
    }

    public void setOutput(String outputFile) {
        this.output = outputFile;
    }

    public Property createProperty() {
        Property p = new Property(true, this.getProject());
        p.setProject(this.getNewProject());
        p.setTaskName("property");
        this.properties.addElement(p);
        return p;
    }

    public void addReference(Reference ref) {
        this.references.addElement(ref);
    }

    public void addConfiguredTarget(TargetElement t) {
        if (this.targetAttributeSet) {
            throw new BuildException("nested target is incompatible with the target attribute");
        }
        String name = t.getName();
        if (name.equals("")) {
            throw new BuildException("target name must not be empty");
        }
        this.targets.add(name);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    protected Project getNewProject() {
        if (this.newProject == null) {
            this.reinit();
        }
        return this.newProject;
    }

    private Iterator getBuildListeners() {
        return this.getProject().getBuildListeners().iterator();
    }

    private static final class PropertyType {
        private static final PropertyType PLAIN = new PropertyType();
        private static final PropertyType INHERITED = new PropertyType();
        private static final PropertyType USER = new PropertyType();

        private PropertyType() {
        }
    }

    public static class TargetElement {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Reference
    extends org.apache.tools.ant.types.Reference {
        private String targetid = null;

        public void setToRefid(String targetid) {
            this.targetid = targetid;
        }

        public String getToRefid() {
            return this.targetid;
        }
    }
}

