/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jlink;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.taskdefs.optional.jlink.ClassNameReader;
import org.apache.tools.ant.util.FileUtils;

public class jlink {
    private static final int BUFFER_SIZE = 8192;
    private static final int VECTOR_INIT_SIZE = 10;
    private String outfile = null;
    private Vector mergefiles = new Vector(10);
    private Vector addfiles = new Vector(10);
    private boolean compression = false;
    byte[] buffer = new byte[8192];

    public void setOutfile(String outfile) {
        if (outfile == null) {
            return;
        }
        this.outfile = outfile;
    }

    public void addMergeFile(String fileToMerge) {
        if (fileToMerge == null) {
            return;
        }
        this.mergefiles.addElement(fileToMerge);
    }

    public void addAddFile(String fileToAdd) {
        if (fileToAdd == null) {
            return;
        }
        this.addfiles.addElement(fileToAdd);
    }

    public void addMergeFiles(String[] filesToMerge) {
        if (filesToMerge == null) {
            return;
        }
        for (int i = 0; i < filesToMerge.length; ++i) {
            this.addMergeFile(filesToMerge[i]);
        }
    }

    public void addAddFiles(String[] filesToAdd) {
        if (filesToAdd == null) {
            return;
        }
        for (int i = 0; i < filesToAdd.length; ++i) {
            this.addAddFile(filesToAdd[i]);
        }
    }

    public void setCompression(boolean compress) {
        this.compression = compress;
    }

    public void link() throws Exception {
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(this.outfile));
        if (this.compression) {
            output.setMethod(8);
            output.setLevel(-1);
        } else {
            output.setMethod(0);
        }
        Enumeration merges = this.mergefiles.elements();
        while (merges.hasMoreElements()) {
            String path = (String)merges.nextElement();
            File f = new File(path);
            if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
                this.mergeZipJarContents(output, f);
                continue;
            }
            this.addAddFile(path);
        }
        Enumeration adds = this.addfiles.elements();
        while (adds.hasMoreElements()) {
            String name = (String)adds.nextElement();
            File f = new File(name);
            if (f.isDirectory()) {
                this.addDirContents(output, f, f.getName() + '/', this.compression);
                continue;
            }
            this.addFile(output, f, "", this.compression);
        }
        FileUtils.close(output);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: jlink output input1 ... inputN");
            System.exit(1);
        }
        jlink linker = new jlink();
        linker.setOutfile(args[0]);
        for (int i = 1; i < args.length; ++i) {
            linker.addMergeFile(args[i]);
        }
        try {
            linker.link();
        }
        catch (Exception ex) {
            System.err.print(ex.getMessage());
        }
    }

    private void mergeZipJarContents(ZipOutputStream output, File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        ZipFile zipf = new ZipFile(f);
        Enumeration<? extends ZipEntry> entries = zipf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry inputEntry = entries.nextElement();
            String inputEntryName = inputEntry.getName();
            int index = inputEntryName.indexOf("META-INF");
            if (index >= 0) continue;
            try {
                output.putNextEntry(this.processEntry(zipf, inputEntry));
            }
            catch (ZipException ex) {
                String mess = ex.getMessage();
                if (mess.indexOf("duplicate") >= 0) continue;
                throw ex;
            }
            InputStream in = zipf.getInputStream(inputEntry);
            int len = this.buffer.length;
            int count2 = -1;
            while ((count2 = in.read(this.buffer, 0, len)) > 0) {
                output.write(this.buffer, 0, count2);
            }
            in.close();
            output.closeEntry();
        }
        zipf.close();
    }

    private void addDirContents(ZipOutputStream output, File dir, String prefix, boolean compress) throws IOException {
        String[] contents = dir.list();
        for (int i = 0; i < contents.length; ++i) {
            String name = contents[i];
            File file = new File(dir, name);
            if (file.isDirectory()) {
                this.addDirContents(output, file, prefix + name + '/', compress);
                continue;
            }
            this.addFile(output, file, prefix, compress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEntryName(File file, String prefix) {
        block14: {
            name = file.getName();
            if (!name.endsWith(".class")) {
                block12: {
                    input = null;
                    try {
                        try {
                            input = new FileInputStream(file);
                            className = ClassNameReader.getClassName(input);
                            if (className == null) break block12;
                            var6_7 = className.replace('.', '/') + ".class";
                            var8_8 = null;
                            if (input == null) return var6_7;
                        }
                        catch (IOException ioe) {
                            var8_10 = null;
                            if (input == null) break block14;
                            try {
                                input.close();
                            }
                            catch (IOException e) {}
                            break block14;
                        }
                    }
                    catch (Throwable var7_16) {
                        var8_11 = null;
                        if (input == null) throw var7_16;
                        ** try [egrp 2[TRYBLOCK] [5 : 103->111)] { 
lbl28:
                        // 1 sources

                        input.close();
                        throw var7_16;
lbl30:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var7_16;
                    }
                    try {}
                    catch (IOException e) {
                        // empty catch block
                        return var6_7;
                    }
                    input.close();
                    return var6_7;
                }
                var8_9 = null;
                if (input != null) {
                    try {}
                    catch (IOException e) {}
                    input.close();
                }
            }
        }
        System.out.println("From " + file.getPath() + " and prefix " + prefix + ", creating entry " + prefix + name);
        return prefix + name;
    }

    private void addFile(ZipOutputStream output, File file, String prefix, boolean compress) throws IOException {
        if (!file.exists()) {
            return;
        }
        ZipEntry entry = new ZipEntry(this.getEntryName(file, prefix));
        entry.setTime(file.lastModified());
        entry.setSize(file.length());
        if (!compress) {
            entry.setCrc(this.calcChecksum(file));
        }
        FileInputStream input2 = new FileInputStream(file);
        this.addToOutputStream(output, input2, entry);
    }

    private void addToOutputStream(ZipOutputStream output, InputStream input2, ZipEntry ze) throws IOException {
        try {
            output.putNextEntry(ze);
        }
        catch (ZipException zipEx) {
            input2.close();
            return;
        }
        int numBytes = -1;
        while ((numBytes = input2.read(this.buffer)) > 0) {
            output.write(this.buffer, 0, numBytes);
        }
        output.closeEntry();
        input2.close();
    }

    private ZipEntry processEntry(ZipFile zip2, ZipEntry inputEntry) {
        String name = inputEntry.getName();
        if (!inputEntry.isDirectory() && !name.endsWith(".class")) {
            try {
                InputStream input2 = zip2.getInputStream(zip2.getEntry(name));
                String className = ClassNameReader.getClassName(input2);
                input2.close();
                if (className != null) {
                    name = className.replace('.', '/') + ".class";
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        ZipEntry outputEntry = new ZipEntry(name);
        outputEntry.setTime(inputEntry.getTime());
        outputEntry.setExtra(inputEntry.getExtra());
        outputEntry.setComment(inputEntry.getComment());
        outputEntry.setTime(inputEntry.getTime());
        if (this.compression) {
            outputEntry.setMethod(8);
        } else {
            outputEntry.setMethod(0);
            outputEntry.setCrc(inputEntry.getCrc());
            outputEntry.setSize(inputEntry.getSize());
        }
        return outputEntry;
    }

    private long calcChecksum(File f) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        return this.calcChecksum(in);
    }

    private long calcChecksum(InputStream in) throws IOException {
        CRC32 crc = new CRC32();
        int len = this.buffer.length;
        int count2 = -1;
        int haveRead = 0;
        while ((count2 = in.read(this.buffer, 0, len)) > 0) {
            haveRead += count2;
            crc.update(this.buffer, 0, count2);
        }
        in.close();
        return crc.getValue();
    }
}

