/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.broadinstitute.rnai.poolq.gui.SwingUtils;

class PoolQResultsDialog
extends JDialog {
    private final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
    private final String scoresFilename;
    private final String qualityReportFilename;

    PoolQResultsDialog(JFrame jFrame, String string2, String string3) {
        super(jFrame);
        this.scoresFilename = string2;
        this.qualityReportFilename = string3;
        this.setModal(true);
        this.setTitle("PoolQ Results");
        this.getContentPane().add(this.createMainPanel(jFrame));
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private Component createMainPanel(JFrame jFrame) {
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        JLabel jLabel = new JLabel("PoolQ successfully finished performing the analysis.");
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("The scores file and quality report have been written to the locations you specified.");
        jPanel.add(jLabel2);
        jLabel2.setAlignmentX(0.0f);
        jPanel.add(Box.createVerticalStrut(5));
        JButton jButton = new JButton("Open Scores File");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolQResultsDialog.this.respondToOpenFileAction(jPanel, PoolQResultsDialog.this.scoresFilename);
            }
        });
        jButton.setAlignmentX(0.0f);
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(5));
        JButton jButton2 = new JButton("Open Quality Report");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolQResultsDialog.this.respondToOpenFileAction(jPanel, PoolQResultsDialog.this.qualityReportFilename);
            }
        });
        jButton2.setAlignmentX(0.0f);
        jPanel.add(jButton2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.createNavigationButtonsComponent());
        return jPanel;
    }

    private Component createNavigationButtonsComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Close Results Window");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolQResultsDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        JButton jButton2 = new JButton("Quit PoolQ GUI");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton2);
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    private void respondToOpenFileAction(JPanel jPanel, String string2) {
        if (this.canOpenFileWithDefaultApplication()) {
            try {
                this.desktop.open(new File(string2));
            }
            catch (IOException iOException) {
                String string3 = "Unexpected error when trying to open file: " + iOException.getMessage();
                JOptionPane.showMessageDialog(jPanel, string3);
            }
        } else {
            JOptionPane.showMessageDialog(jPanel, "Sorry, but your desktop configuration doesn't support opening files from within a Java application. Try Gnome.");
        }
    }

    private boolean canOpenFileWithDefaultApplication() {
        return this.desktop != null && this.desktop.isSupported(Desktop.Action.OPEN);
    }
}

