/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.BarcodeScore;
import org.broadinstitute.rnai.poolq.api.UnexpectedSequenceReportData;
import org.broadinstitute.rnai.poolq.impl.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnexpectedSequenceFileWriter {
    private static final double TEN_MILLION_POINT_OH = 1.0E7;
    private static final Logger logger = LoggerFactory.getLogger(UnexpectedSequenceFileWriter.class);

    public void writeUnexpectedSequenceFile(UnexpectedSequenceReportData unexpectedSequenceReportData, int n, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.writeUnexpectedSequenceHeader(unexpectedSequenceReportData, n, printWriter);
        this.writeUnexpectedSequences(unexpectedSequenceReportData, n, printWriter);
        printWriter.append('\n');
        this.writeUnexpectedBarcodeCountHeader(unexpectedSequenceReportData, n, printWriter);
        this.writeUnexpectedBarcodeCounts(unexpectedSequenceReportData, n, printWriter);
        printWriter.close();
    }

    protected void writeUnexpectedSequenceHeader(UnexpectedSequenceReportData unexpectedSequenceReportData, int n, PrintWriter printWriter) {
        printWriter.append("Sequence\tTotal\t");
        for (String string2 : unexpectedSequenceReportData.getBarcodesMappedToConditions()) {
            printWriter.append(string2);
            printWriter.append('\t');
        }
        printWriter.append("Construct IDs");
        printWriter.append('\n');
    }

    protected void writeUnexpectedSequences(UnexpectedSequenceReportData unexpectedSequenceReportData, int n, PrintWriter printWriter) {
        int n2 = 0;
        try {
            for (BarcodeScore barcodeScore : unexpectedSequenceReportData.getUnexpectedConstructBarcodes()) {
                int n3 = 0;
                StringBuilder stringBuilder = new StringBuilder();
                Map<String, Integer> map2 = barcodeScore.getReadCountsByBarcode();
                for (String string2 : unexpectedSequenceReportData.getBarcodesMappedToConditions()) {
                    Integer n4 = map2.get(string2);
                    if (n4 == null) {
                        n4 = 0;
                    }
                    stringBuilder.append(n4);
                    stringBuilder.append('\t');
                    n3 += n4.intValue();
                }
                if (this.includeScore(n3, unexpectedSequenceReportData.getNumberOfReads(), n)) {
                    printWriter.append(barcodeScore.getBarcode());
                    printWriter.append('\t');
                    printWriter.append(String.valueOf(n3));
                    printWriter.append('\t');
                    printWriter.append(stringBuilder.toString());
                    printWriter.append(TextUtils.join(unexpectedSequenceReportData.getPlatformConstructIdsForConstructBarcode(barcodeScore.getBarcode()), ','));
                    printWriter.append('\n');
                }
                if (++n2 % 10000 != 0) continue;
                logger.info("Processed {} unexpected sequence", (Object)n2);
            }
        }
        catch (Exception exception) {
            logger.error("Caught unexpected exception processing unexpected sequence # {}", (Object)n2);
            logger.error("Exception was", exception);
        }
    }

    private void writeUnexpectedBarcodeCountHeader(UnexpectedSequenceReportData unexpectedSequenceReportData, int n, PrintWriter printWriter) {
        printWriter.append("Unexpected Barcode\tUnexpected Sequence Count\n");
    }

    private void writeUnexpectedBarcodeCounts(UnexpectedSequenceReportData unexpectedSequenceReportData, int n, PrintWriter printWriter) {
        List<BarcodeCount> list = this.getUnexpectedBarcodeCounts(unexpectedSequenceReportData);
        Collections.sort(list, Collections.reverseOrder());
        for (BarcodeCount barcodeCount : list) {
            printWriter.append(barcodeCount.getBarcode());
            printWriter.append('\t');
            printWriter.append(String.valueOf(barcodeCount.getCount()));
            printWriter.append('\n');
        }
    }

    private List<BarcodeCount> getUnexpectedBarcodeCounts(UnexpectedSequenceReportData unexpectedSequenceReportData) {
        Collection<String> collection = unexpectedSequenceReportData.getUnexpectedSampleBarcodes();
        ArrayList<BarcodeCount> arrayList = new ArrayList<BarcodeCount>(collection.size());
        for (String string2 : collection) {
            arrayList.add(new BarcodeCount(string2, unexpectedSequenceReportData.getUnexpectedSequenceReadCountForBarcode(string2)));
        }
        return arrayList;
    }

    boolean includeScore(int n, long l, int n2) {
        return (double)n * 1.0E7 / (double)l >= (double)n2;
    }

    static final class BarcodeCount
    implements Comparable<BarcodeCount> {
        private final String barcode;
        private final int count;

        public BarcodeCount(String string2, int n) {
            this.barcode = string2;
            this.count = n;
        }

        public String getBarcode() {
            return this.barcode;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(BarcodeCount barcodeCount) {
            int n = this.count - barcodeCount.count;
            if (n == 0) {
                return this.barcode.compareTo(barcodeCount.barcode);
            }
            return n;
        }
    }
}

