/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Requires;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.broadinstitute.variant.bcf2.BCF2Utils;

public enum BCF2Type {
    MISSING(0, 0, 0){

        @Override
        public int read(InputStream inputStream) throws IOException {
            throw new IllegalArgumentException("Cannot read MISSING type");
        }

        @Override
        public void write(int n, OutputStream outputStream) throws IOException {
            throw new IllegalArgumentException("Cannot write MISSING type");
        }
    }
    ,
    INT8(1, 1, -128, -127L, 127L){

        @Override
        public int read(InputStream inputStream) throws IOException {
            return BCF2Utils.readByte(inputStream);
        }

        @Override
        public void write(int n, OutputStream outputStream) throws IOException {
            outputStream.write(0xFF & n);
        }
    }
    ,
    INT16(2, 2, Short.MIN_VALUE, -32767L, 32767L){

        @Override
        public int read(InputStream inputStream) throws IOException {
            int n = BCF2Utils.readByte(inputStream) & 0xFF;
            int n2 = BCF2Utils.readByte(inputStream) & 0xFF;
            return (short)(n2 << 8 | n);
        }

        @Override
        public void write(int n, OutputStream outputStream) throws IOException {
            outputStream.write(0xFF & n);
            outputStream.write((0xFF00 & n) >> 8);
        }
    }
    ,
    INT32(3, 4, Integer.MIN_VALUE, -2147483647L, Integer.MAX_VALUE){

        @Override
        public int read(InputStream inputStream) throws IOException {
            int n = BCF2Utils.readByte(inputStream) & 0xFF;
            int n2 = BCF2Utils.readByte(inputStream) & 0xFF;
            int n3 = BCF2Utils.readByte(inputStream) & 0xFF;
            int n4 = BCF2Utils.readByte(inputStream) & 0xFF;
            return n4 << 24 | n3 << 16 | n2 << 8 | n;
        }

        @Override
        public void write(int n, OutputStream outputStream) throws IOException {
            outputStream.write(0xFF & n);
            outputStream.write((0xFF00 & n) >> 8);
            outputStream.write((0xFF0000 & n) >> 16);
            outputStream.write((0xFF000000 & n) >> 24);
        }
    }
    ,
    FLOAT(5, 4, 2139095041){

        @Override
        public int read(InputStream inputStream) throws IOException {
            return INT32.read(inputStream);
        }

        @Override
        public void write(int n, OutputStream outputStream) throws IOException {
            INT32.write(n, outputStream);
        }
    }
    ,
    CHAR(7, 1, 0){

        @Override
        public int read(InputStream inputStream) throws IOException {
            return INT8.read(inputStream);
        }

        @Override
        public void write(int n, OutputStream outputStream) throws IOException {
            INT8.write(n, outputStream);
        }
    };

    private final int id;
    private final Object missingJavaValue;
    private final int missingBytes;
    private final int sizeInBytes;
    private final long minValue;
    private final long maxValue;
    private static final EnumSet<BCF2Type> INTEGERS;

    private BCF2Type(int n2, int n3, int n4) {
        this(n2, n3, n4, 0L, 0L);
    }

    private BCF2Type(int n2, int n3, int n4, long l, long l2) {
        this.id = n2;
        this.sizeInBytes = n3;
        this.missingJavaValue = null;
        this.missingBytes = n4;
        this.minValue = l;
        this.maxValue = l2;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getID() {
        return this.id;
    }

    @Requires(value={"this.isIntegerType()"})
    public final boolean withinRange(long l) {
        return l >= this.minValue && l <= this.maxValue;
    }

    public Object getMissingJavaValue() {
        return this.missingJavaValue;
    }

    public int getMissingBytes() {
        return this.missingBytes;
    }

    public boolean isMissingType() {
        return this == MISSING;
    }

    public boolean isIntegerType() {
        return INTEGERS.contains((Object)this);
    }

    @Requires(value={"in != null"})
    public int read(InputStream inputStream) throws IOException {
        throw new IllegalArgumentException("Not implemented");
    }

    @Requires(value={"out != null"})
    public void write(int n, OutputStream outputStream) throws IOException {
        throw new IllegalArgumentException("Not implemented");
    }

    static {
        INTEGERS = EnumSet.of(INT8, INT16, INT32);
    }
}

