/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class BCFVersion {
    public static final byte[] MAGIC_HEADER_START = "BCF".getBytes();
    final int majorVersion;
    final int minorVersion;

    public BCFVersion(int n, int n2) {
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public static BCFVersion readBCFVersion(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[MAGIC_HEADER_START.length];
        inputStream.read(byArray);
        if (Arrays.equals(byArray, MAGIC_HEADER_START)) {
            int n = inputStream.read();
            int n2 = inputStream.read();
            return new BCFVersion(n, n2);
        }
        return null;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(MAGIC_HEADER_START);
        outputStream.write(this.getMajorVersion() & 0xFF);
        outputStream.write(this.getMinorVersion() & 0xFF);
    }

    public String toString() {
        return String.format("BCF%d.%d", this.getMajorVersion(), this.getMinorVersion());
    }
}

