/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeSet;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypeType;

@Invariant(value={"getAlleles() != null", "getSampleName() != null", "getPloidy() >= 0", "! hasForbiddenKey(getExtendedAttributes())"})
public abstract class Genotype
implements Comparable<Genotype> {
    public static final Collection<String> PRIMARY_KEYS = Arrays.asList("FT", "GT", "GQ", "DP", "AD", "PL");
    public static final String PHASED_ALLELE_SEPARATOR = "|";
    public static final String UNPHASED_ALLELE_SEPARATOR = "/";
    private final String sampleName;
    private GenotypeType type = null;
    private final String filters;

    protected Genotype(String string2, String string3) {
        this.sampleName = string2;
        this.filters = string3;
    }

    @Ensures(value={"result != null"})
    public abstract List<Allele> getAlleles();

    @Requires(value={"allele != null"})
    @Ensures(value={"result >= 0"})
    public int countAllele(Allele allele) {
        int n = 0;
        for (Allele allele2 : this.getAlleles()) {
            if (!allele2.equals(allele)) continue;
            ++n;
        }
        return n;
    }

    @Requires(value={"i >=0 && i < getPloidy()", "getType() != GenotypeType.UNAVAILABLE"})
    @Ensures(value={"result != null"})
    public abstract Allele getAllele(int var1);

    public abstract boolean isPhased();

    @Ensures(value={"result >= 0"})
    public int getPloidy() {
        return this.getAlleles().size();
    }

    @Ensures(value={"result >= -1"})
    public abstract int getDP();

    public abstract int[] getAD();

    @Ensures(value={"result != null"})
    public String getSampleName() {
        return this.sampleName;
    }

    @Ensures(value={"result >= -1"})
    public abstract int getGQ();

    @Ensures(value={"(result == false && getPL() == null) || (result == true && getPL() != null)"})
    public boolean hasPL() {
        return this.getPL() != null;
    }

    @Ensures(value={"(result == false && getAD() == null) || (result == true && getAD() != null)"})
    public boolean hasAD() {
        return this.getAD() != null;
    }

    @Ensures(value={"(result == false && getGQ() == -1) || (result == true && getGQ() >= 0)"})
    public boolean hasGQ() {
        return this.getGQ() != -1;
    }

    @Ensures(value={"(result == false && getDP() == -1) || (result == true && getDP() >= 0)"})
    public boolean hasDP() {
        return this.getDP() != -1;
    }

    @Ensures(value={"type != null", "result != null"})
    public GenotypeType getType() {
        if (this.type == null) {
            this.type = this.determineType();
        }
        return this.type;
    }

    @Requires(value={"type == null"})
    protected GenotypeType determineType() {
        List<Allele> list = this.getAlleles();
        if (list.isEmpty()) {
            return GenotypeType.UNAVAILABLE;
        }
        boolean bl = false;
        boolean bl2 = false;
        Allele allele = null;
        for (Allele allele2 : list) {
            if (allele2.isNoCall()) {
                bl = true;
                continue;
            }
            if (allele == null) {
                allele = allele2;
                continue;
            }
            if (allele2.equals(allele)) continue;
            bl2 = true;
        }
        if (bl) {
            if (allele == null) {
                return GenotypeType.NO_CALL;
            }
            return GenotypeType.MIXED;
        }
        if (allele == null) {
            throw new IllegalStateException("BUG: there are no alleles present in this genotype but the alleles list is not null");
        }
        return bl2 ? GenotypeType.HET : (allele.isReference() ? GenotypeType.HOM_REF : GenotypeType.HOM_VAR);
    }

    public boolean isHom() {
        return this.isHomRef() || this.isHomVar();
    }

    public boolean isHomRef() {
        return this.getType() == GenotypeType.HOM_REF;
    }

    public boolean isHomVar() {
        return this.getType() == GenotypeType.HOM_VAR;
    }

    public boolean isHet() {
        return this.getType() == GenotypeType.HET;
    }

    public boolean isNoCall() {
        return this.getType() == GenotypeType.NO_CALL;
    }

    public boolean isCalled() {
        return this.getType() != GenotypeType.NO_CALL && this.getType() != GenotypeType.UNAVAILABLE;
    }

    public boolean isMixed() {
        return this.getType() == GenotypeType.MIXED;
    }

    public boolean isAvailable() {
        return this.getType() != GenotypeType.UNAVAILABLE;
    }

    @Ensures(value={"(result && getLikelihoods() != null) || (! result && getLikelihoods() == null)"})
    public boolean hasLikelihoods() {
        return this.getPL() != null;
    }

    @Ensures(value={"result != null"})
    public String getLikelihoodsString() {
        return this.hasLikelihoods() ? this.getLikelihoods().toString() : ".";
    }

    @Ensures(value={"(hasLikelihoods() && result != null) || (! hasLikelihoods() && result == null)"})
    public GenotypeLikelihoods getLikelihoods() {
        return this.hasLikelihoods() ? GenotypeLikelihoods.fromPLs(this.getPL()) : null;
    }

    public boolean isNonInformative() {
        if (this.getPL() == null) {
            return true;
        }
        for (int n : this.getPL()) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    public abstract int[] getPL();

    @Ensures(value={"result != null || ! isAvailable()"})
    public String getGenotypeString() {
        return this.getGenotypeString(true);
    }

    @Ensures(value={"result != null || ! isAvailable()"})
    public String getGenotypeString(boolean bl) {
        if (this.getPloidy() == 0) {
            return "NA";
        }
        return ParsingUtils.join(this.isPhased() ? PHASED_ALLELE_SEPARATOR : UNPHASED_ALLELE_SEPARATOR, bl ? this.getAlleleStrings() : (this.isPhased() ? this.getAlleles() : ParsingUtils.sortList(this.getAlleles())));
    }

    protected List<String> getAlleleStrings() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getPloidy());
        for (Allele allele : this.getAlleles()) {
            arrayList.add(allele.getBaseString());
        }
        return arrayList;
    }

    public String toString() {
        return String.format("[%s %s%s%s%s%s%s%s]", this.getSampleName(), this.getGenotypeString(false), Genotype.toStringIfExists("GQ", this.getGQ()), Genotype.toStringIfExists("DP", this.getDP()), Genotype.toStringIfExists("AD", this.getAD()), Genotype.toStringIfExists("PL", this.getPL()), Genotype.toStringIfExists("FT", this.getFilters()), Genotype.sortedString(this.getExtendedAttributes()));
    }

    public String toBriefString() {
        return String.format("%s:Q%d", this.getGenotypeString(false), this.getGQ());
    }

    @Override
    public int compareTo(Genotype genotype) {
        return this.getSampleName().compareTo(genotype.getSampleName());
    }

    public boolean sameGenotype(Genotype genotype) {
        return this.sameGenotype(genotype, true);
    }

    public boolean sameGenotype(Genotype genotype, boolean bl) {
        if (this.getPloidy() != genotype.getPloidy()) {
            return false;
        }
        SequencedCollection<Allele> sequencedCollection = this.getAlleles();
        SequencedCollection<Allele> sequencedCollection2 = genotype.getAlleles();
        if (bl) {
            sequencedCollection = new TreeSet<Allele>(sequencedCollection);
            sequencedCollection2 = new TreeSet<Allele>(sequencedCollection2);
        }
        return sequencedCollection.equals(sequencedCollection2);
    }

    @Ensures(value={"result != null", "! hasForbiddenKey(result)"})
    public abstract Map<String, Object> getExtendedAttributes();

    @Requires(value={"key != null", "! isForbiddenKey(key)"})
    public boolean hasExtendedAttribute(String string2) {
        return this.getExtendedAttributes().containsKey(string2);
    }

    @Requires(value={"key != null", "! isForbiddenKey(key)"})
    @Ensures(value={"hasExtendedAttribute(key) || result == defaultValue"})
    public Object getExtendedAttribute(String string2, Object object) {
        return this.hasExtendedAttribute(string2) ? this.getExtendedAttributes().get(string2) : object;
    }

    public Object getExtendedAttribute(String string2) {
        return this.getExtendedAttribute(string2, null);
    }

    public final String getFilters() {
        return this.filters;
    }

    @Ensures(value={"result != (getFilters() == null)"})
    public final boolean isFiltered() {
        return this.getFilters() != null;
    }

    @Deprecated
    public boolean hasLog10PError() {
        return this.hasGQ();
    }

    @Deprecated
    public double getLog10PError() {
        return (double)this.getGQ() / -10.0;
    }

    @Deprecated
    public int getPhredScaledQual() {
        return this.getGQ();
    }

    @Deprecated
    public String getAttributeAsString(String string2, String string3) {
        Object object = this.getExtendedAttribute(string2);
        if (object == null) {
            return string3;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    @Deprecated
    public int getAttributeAsInt(String string2, int n) {
        Object object = this.getExtendedAttribute(string2);
        if (object == null || object == ".") {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.valueOf((String)object);
    }

    @Deprecated
    public double getAttributeAsDouble(String string2, double d) {
        Object object = this.getExtendedAttribute(string2);
        if (object == null) {
            return d;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return Double.valueOf((String)object);
    }

    public Object getAnyAttribute(String string2) {
        if (string2.equals("GT")) {
            return this.getAlleles();
        }
        if (string2.equals("GQ")) {
            return this.getGQ();
        }
        if (string2.equals("AD")) {
            return Arrays.asList(new int[][]{this.getAD()});
        }
        if (string2.equals("PL")) {
            return Arrays.asList(new int[][]{this.getPL()});
        }
        if (string2.equals("DP")) {
            return this.getDP();
        }
        return this.getExtendedAttribute(string2);
    }

    public boolean hasAnyAttribute(String string2) {
        if (string2.equals("GT")) {
            return this.isAvailable();
        }
        if (string2.equals("GQ")) {
            return this.hasGQ();
        }
        if (string2.equals("AD")) {
            return this.hasAD();
        }
        if (string2.equals("PL")) {
            return this.hasPL();
        }
        if (string2.equals("DP")) {
            return this.hasDP();
        }
        return this.hasExtendedAttribute(string2);
    }

    @Requires(value={"c != null"})
    protected static <T extends Comparable<T>, V> String sortedString(Map<T, V> map2) {
        ArrayList<T> arrayList = new ArrayList<T>(map2.keySet());
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Comparable comparable : arrayList) {
            arrayList2.add(comparable + "=" + map2.get(comparable));
        }
        return arrayList2.isEmpty() ? "" : " {" + ParsingUtils.join(", ", arrayList2.toArray(new String[arrayList2.size()])) + "}";
    }

    @Requires(value={"name != null"})
    @Ensures(value={"result != null"})
    protected static final String toStringIfExists(String string2, int n) {
        return n == -1 ? "" : " " + string2 + " " + n;
    }

    protected static final String toStringIfExists(String string2, String string3) {
        return string3 == null ? "" : " " + string2 + " " + string3;
    }

    @Requires(value={"name != null"})
    @Ensures(value={"result != null"})
    protected static final String toStringIfExists(String string2, int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(string2).append(" ");
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    protected static final boolean hasForbiddenKey(Map<String, Object> map2) {
        for (String string2 : PRIMARY_KEYS) {
            if (!map2.containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isForbiddenKey(String string2) {
        return PRIMARY_KEYS.contains(string2);
    }
}

