/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.je.utilint.IdentityHashMap;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawArrayInput;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveArrayFormat
extends Format {
    private static final long serialVersionUID = 8285299924106073591L;
    private SimpleFormat componentFormat;

    PrimitiveArrayFormat(Catalog catalog, Class type) {
        super(catalog, type);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return 1;
    }

    @Override
    public Format getComponentType() {
        return this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        this.componentFormat = (SimpleFormat)catalog.getFormat(this.getExistingType().getComponentType().getName());
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    public Object newInstance(EntityInput input2, boolean rawAccess) throws RefreshException {
        int len = input2.readArrayLength();
        if (rawAccess) {
            return new RawObject((RawType)this, new Object[len]);
        }
        return this.componentFormat.newPrimitiveArray(len, input2);
    }

    @Override
    public Object readObject(Object o, EntityInput input2, boolean rawAccess) throws RefreshException {
        if (rawAccess) {
            Object[] a = ((RawObject)o).getElements();
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.componentFormat.newInstance(input2, true);
                this.componentFormat.readObject(a[i], input2, true);
            }
        }
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) throws RefreshException {
        if (rawAccess) {
            Object[] a = ((RawObject)o).getElements();
            output.writeArrayLength(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.componentFormat.writeObject(a[i], output, true);
            }
        } else {
            this.componentFormat.writePrimitiveArray(o, output);
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) throws RefreshException {
        RawArrayInput input2 = new RawArrayInput(catalog, rawAccess, converted, rawObject, this.componentFormat);
        Object a = this.newInstance(input2, rawAccess);
        converted.put(rawObject, a);
        return this.readObject(a, input2, rawAccess);
    }

    @Override
    void skipContents(RecordInput input2) {
        int len = input2.readPackedInt();
        this.componentFormat.skipPrimitiveArray(len, input2);
    }

    @Override
    void copySecMultiKey(RecordInput input2, Format keyFormat, Set results) {
        int len = input2.readPackedInt();
        this.componentFormat.copySecMultiKeyPrimitiveArray(len, input2, results);
    }

    @Override
    boolean evolve(Format newFormat, Evolver evolver) {
        evolver.useOldFormat(this, newFormat);
        return true;
    }
}

