/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.cmdline;

import java.io.File;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.Option;
import net.sf.picard.metrics.Header;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.StringHeader;
import net.sf.picard.util.Log;
import net.sf.samtools.Defaults;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.util.BlockCompressedOutputStream;
import net.sf.samtools.util.BlockCompressedStreamConstants;
import net.sf.samtools.util.IOUtil;

public abstract class CommandLineProgram {
    @Option(common=true, optional=true)
    public List<File> TMP_DIR = new ArrayList<File>();
    @Option(doc="Control verbosity of logging.", common=true)
    public Log.LogLevel VERBOSITY = Log.LogLevel.INFO;
    @Option(doc="Whether to suppress job-summary info on System.err.", common=true)
    public Boolean QUIET = false;
    @Option(doc="Validation stringency for all SAM files read by this program.  Setting stringency to SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true)
    public SAMFileReader.ValidationStringency VALIDATION_STRINGENCY = SAMFileReader.ValidationStringency.DEFAULT_STRINGENCY;
    @Option(doc="Compression level for all compressed files created (e.g. BAM and GELI).", common=true)
    public int COMPRESSION_LEVEL = BlockCompressedStreamConstants.DEFAULT_COMPRESSION_LEVEL;
    @Option(doc="When writing SAM files that need to be sorted, this will specify the number of records stored in RAM before spilling to disk. Increasing this number reduces the number of file handles needed to sort a SAM file, and increases the amount of RAM needed.", optional=true, common=true)
    public Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    @Option(doc="Whether to create a BAM index when writing a coordinate-sorted BAM file.", common=true)
    public Boolean CREATE_INDEX = Defaults.CREATE_INDEX;
    @Option(doc="Whether to create an MD5 digest for any BAM or FASTQ files created.  ", common=true)
    public boolean CREATE_MD5_FILE = Defaults.CREATE_MD5;
    private final String standardUsagePreamble = CommandLineParser.getStandardUsagePreamble(this.getClass());
    private CommandLineParser commandLineParser;
    private final List<Header> defaultHeaders = new ArrayList<Header>();
    private String commandLine;

    protected abstract int doWork();

    public void instanceMainWithExit(String[] stringArray) {
        System.exit(this.instanceMain(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instanceMain(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return 1;
        }
        if (this.TMP_DIR == null) {
            this.TMP_DIR = new ArrayList<File>();
        }
        if (this.TMP_DIR.isEmpty()) {
            this.TMP_DIR.add(IOUtil.getDefaultTmpDir());
        }
        Date date = new Date();
        this.defaultHeaders.add(new StringHeader(this.commandLine));
        this.defaultHeaders.add(new StringHeader("Started on: " + date));
        Log.setGlobalLogLevel(this.VERBOSITY);
        SAMFileReader.ValidationStringency validationStringency = SAMFileReader.getDefaultValidationStringency();
        SAMFileReader.setDefaultValidationStringency(this.VALIDATION_STRINGENCY);
        BlockCompressedOutputStream.setDefaultCompressionLevel(this.COMPRESSION_LEVEL);
        if (this.MAX_RECORDS_IN_RAM != null) {
            SAMFileWriterImpl.setDefaultMaxRecordsInRam(this.MAX_RECORDS_IN_RAM);
        }
        if (this.CREATE_INDEX.booleanValue()) {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting(true);
        }
        SAMFileWriterFactory.setDefaultCreateMd5File(this.CREATE_MD5_FILE);
        for (File comparable : this.TMP_DIR) {
            if (!comparable.exists()) {
                comparable.mkdirs();
            }
            comparable.setReadable(true, false);
            comparable.setWritable(true, false);
            System.setProperty("java.io.tmpdir", comparable.getAbsolutePath());
        }
        if (!this.QUIET.booleanValue()) {
            System.err.println("[" + new Date() + "] " + this.commandLine);
            try {
                System.err.println("[" + new Date() + "] Executing as " + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version") + "; Picard version: " + this.commandLineParser.getVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = -1;
        try {
            n = this.doWork();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency(validationStringency);
            try {
                if (!this.QUIET.booleanValue()) {
                    Date throwable = new Date();
                    double d = (double)(throwable.getTime() - date.getTime()) / 60000.0;
                    String string2 = new DecimalFormat("#,##0.00").format(d);
                    System.err.println("[" + throwable + "] " + this.getClass().getName() + " done. Elapsed time: " + string2 + " minutes.");
                    System.err.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    if (n != 0 && CommandLineParser.hasWebDocumentation(this.getClass())) {
                        System.err.println(CommandLineParser.getFaqLink());
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.getNestedOptions().values()) {
            CommandLineProgram commandLineProgram;
            String[] stringArray;
            if (!(object instanceof CommandLineProgram) || (stringArray = (commandLineProgram = (CommandLineProgram)object).customCommandLineValidation()) == null) continue;
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    protected boolean parseArgs(String[] stringArray) {
        this.commandLineParser = new CommandLineParser(this);
        boolean bl = this.commandLineParser.parseOptions(System.err, stringArray);
        this.commandLine = this.commandLineParser.getCommandLine();
        if (!bl) {
            return false;
        }
        String[] stringArray2 = this.customCommandLineValidation();
        if (stringArray2 != null) {
            for (String string2 : stringArray2) {
                System.err.println(string2);
            }
            this.commandLineParser.usage(System.err, false);
            return false;
        }
        return true;
    }

    protected <A extends MetricBase, B extends Comparable<?>> MetricsFile<A, B> getMetricsFile() {
        MetricsFile metricsFile = new MetricsFile();
        for (Header header : this.defaultHeaders) {
            metricsFile.addHeader(header);
        }
        return metricsFile;
    }

    public String getStandardUsagePreamble() {
        return this.standardUsagePreamble;
    }

    public CommandLineParser getCommandLineParser() {
        return this.commandLineParser;
    }

    public String getProgramVersion() {
        return this.commandLineParser.getProgramVersion();
    }

    public String getVersion() {
        return this.getCommandLineParser().getVersion();
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setDefaultHeaders(List<Header> list) {
        this.defaultHeaders.clear();
        this.defaultHeaders.addAll(list);
    }

    public List<Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public Map<String, Object> getNestedOptions() {
        return CommandLineParser.getNestedOptions(this);
    }

    public Map<String, Object> getNestedOptionsForHelp() {
        return this.getNestedOptions();
    }
}

