/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.picard.PicardException;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.picard.io.IoUtil;

public class BasicFastqWriter
implements FastqWriter {
    private final String path;
    private final PrintStream writer;

    public BasicFastqWriter(File file) {
        this(file, false);
    }

    public BasicFastqWriter(File file, boolean bl) {
        this(file, new PrintStream(BasicFastqWriter.maybeMd5Wrap(file, bl)));
    }

    private BasicFastqWriter(File file, PrintStream printStream) {
        this.path = file != null ? file.getAbsolutePath() : "";
        this.writer = printStream;
    }

    public BasicFastqWriter(PrintStream printStream) {
        this(null, printStream);
    }

    @Override
    public void write(FastqRecord fastqRecord) {
        this.writer.print("@");
        this.writer.println(fastqRecord.getReadHeader());
        this.writer.println(fastqRecord.getReadString());
        this.writer.print("+");
        this.writer.println(fastqRecord.getBaseQualityHeader() == null ? "" : fastqRecord.getBaseQualityHeader());
        this.writer.println(fastqRecord.getBaseQualityString());
        if (this.writer.checkError()) {
            throw new PicardException("Error in writing fastq file " + this.path);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    private static OutputStream maybeMd5Wrap(File file, boolean bl) {
        if (bl) {
            return IoUtil.openFileForMd5CalculatingWriting(file);
        }
        return IoUtil.openFileForWriting(file);
    }
}

