/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.ClippingUtility;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class MarkIlluminaAdapters
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reads a SAM or BAM file and rewrites it with new adapter-trimming tags.\n" + "Clear any existing adapter-trimming tags (XT:i:).\n" + "Only works for unaligned files in query-name order.\n" + "Note: This is a utility program and will not be run in the pipeline.\n";
    @Option(shortName="I")
    public File INPUT;
    @Option(doc="If output is not specified, just the metrics are generated", shortName="O", optional=true)
    public File OUTPUT;
    @Option(doc="Histogram showing counts of bases_clipped in how many reads", shortName="M")
    public File METRICS;
    @Option(doc="The minimum number of bases that must match the adapter that will be clipped. Defaults to 6 if paired-end, otherwise12/nThe stricter match used when matching 2 reads will be twice this.", optional=true)
    public Integer MIN_MATCH_BASES;
    @Option(doc="The percentage of errors allowed when matching the adapter sequence. Defaults to 0.1 if paired-end, otherwise 0.1", optional=true)
    public Double MAX_ERROR_RATE;
    @Option(doc="Whether this is a paired-end run. ", shortName="PE")
    public Boolean PAIRED_RUN;
    @Option(doc="Which adapters to use, PAIRED_END, INDEXED, or SINGLE_END", mutex={"FIVE_PRIME_ADAPTER", "THREE_PRIME_ADAPTER"})
    public IlluminaUtil.IlluminaAdapterPair ADAPTERS;
    @Option(doc="For specifying adapters other than standard Illumina", mutex={"ADAPTERS"})
    public String FIVE_PRIME_ADAPTER;
    @Option(doc="For specifying adapters other than standard Illumina", mutex={"ADAPTERS"})
    public String THREE_PRIME_ADAPTER;
    private static final Log log = Log.getInstance(MarkIlluminaAdapters.class);

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PAIRED_RUN.booleanValue()) {
            if (this.MIN_MATCH_BASES == null) {
                this.MIN_MATCH_BASES = 6;
            }
            if (this.MAX_ERROR_RATE == null) {
                this.MAX_ERROR_RATE = 0.1;
            }
        } else {
            if (this.MIN_MATCH_BASES == null) {
                this.MIN_MATCH_BASES = 12;
            }
            if (this.MAX_ERROR_RATE == null) {
                this.MAX_ERROR_RATE = 0.1;
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.exit(new MarkIlluminaAdapters().instanceMain(stringArray));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.METRICS);
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
        SAMFileWriter sAMFileWriter = null;
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
            sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileReader.getFileHeader(), true, this.OUTPUT);
        }
        Histogram<Integer> histogram = new Histogram<Integer>("clipped_bases", "read_count");
        if (this.PAIRED_RUN.booleanValue() && !sAMFileReader.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.queryname)) {
            throw new PicardException("Input BAM file must be sorted by queryname");
        }
        if (this.ADAPTERS != null) {
            IlluminaUtil.IlluminaAdapterPair illuminaAdapterPair = this.ADAPTERS;
        } else {
            CustomAdapterPair customAdapterPair = new CustomAdapterPair(this.FIVE_PRIME_ADAPTER, this.THREE_PRIME_ADAPTER);
        }
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Read");
        Object object = sAMFileReader.iterator();
        while (object.hasNext()) {
            void var4_6;
            Object object2;
            SAMRecord sAMRecord = (SAMRecord)object.next();
            sAMRecord.setAttribute("XT", null);
            SAMRecord sAMRecord2 = null;
            if (this.PAIRED_RUN.booleanValue()) {
                SAMRecord sAMRecord3;
                if (!sAMRecord.getFirstOfPairFlag() && !sAMRecord.getSecondOfPairFlag()) throw new PicardException("Non-paired reads in a paired run " + sAMRecord);
                SAMRecord sAMRecord4 = sAMRecord2 = object.hasNext() ? (SAMRecord)object.next() : null;
                if (sAMRecord2 == null) {
                    throw new PicardException("Missing second read for " + sAMRecord);
                }
                sAMRecord2.setAttribute("XT", null);
                if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) {
                    throw new PicardException("read names of two paired reads differs : " + sAMRecord.getReadName() + ", " + sAMRecord2.getReadName());
                }
                if (sAMRecord.getFirstOfPairFlag()) {
                    object2 = sAMRecord;
                    sAMRecord3 = sAMRecord2;
                } else {
                    object2 = sAMRecord2;
                    sAMRecord3 = sAMRecord;
                }
                if (!((SAMRecord)object2).getFirstOfPairFlag()) {
                    throw new PicardException("first of two reads doesn't have getFirstOfPairFlag()");
                }
                if (!sAMRecord3.getSecondOfPairFlag()) {
                    throw new PicardException("second of two reads doesn't have getSecondOfPairFlag()");
                }
                String string2 = ClippingUtility.adapterTrimIlluminaPairedReads((SAMRecord)object2, sAMRecord3, (AdapterPair)var4_6, this.MIN_MATCH_BASES, this.MAX_ERROR_RATE);
                if (string2 != null) {
                    log.info("Adapter trimming " + string2);
                }
            } else {
                ClippingUtility.adapterTrimIlluminaSingleRead(sAMRecord, (AdapterPair)var4_6, this.MIN_MATCH_BASES, this.MAX_ERROR_RATE);
            }
            if (sAMFileWriter != null) {
                sAMFileWriter.addAlignment(sAMRecord);
            }
            if (sAMFileWriter != null && sAMRecord2 != null) {
                sAMFileWriter.addAlignment(sAMRecord2);
            }
            if ((object2 = sAMRecord.getIntegerAttribute("XT")) != null) {
                histogram.increment(sAMRecord.getReadLength() - (Integer)object2 + 1);
            }
            progressLogger.record(sAMRecord);
        }
        if (sAMFileWriter != null) {
            sAMFileWriter.close();
        }
        object = this.getMetricsFile();
        ((MetricsFile)object).setHistogram(histogram);
        ((MetricsFile)object).write(this.METRICS);
        return 0;
    }

    private class CustomAdapterPair
    implements AdapterPair {
        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private CustomAdapterPair(String string2, String string3) {
            this.threePrime = string3;
            this.threePrimeBytes = StringUtil.stringToBytes(string3);
            this.fivePrime = string2;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement(string2);
            this.fivePrimeBytes = StringUtil.stringToBytes(string2);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes(this.fivePrimeReadOrder);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return "Custom adapter pair";
        }
    }
}

