/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.util.BasicInputParser;
import net.sf.samtools.util.CloserUtil;

class IlluminaTextIterator
implements Iterator<String[]> {
    private final int lane;
    private int currentTile = 0;
    private IlluminaFileMap files;
    private boolean treatGroupedDelimitersAsOne = true;
    private BasicInputParser parser;

    public IlluminaTextIterator(int n, IlluminaFileMap illuminaFileMap) {
        this.lane = n;
        this.files = illuminaFileMap;
        this.currentTile = (Integer)illuminaFileMap.firstKey();
    }

    public IlluminaTextIterator(int n, IlluminaFileMap illuminaFileMap, boolean bl) {
        this(n, illuminaFileMap);
        this.treatGroupedDelimitersAsOne = bl;
        this.currentTile = (Integer)illuminaFileMap.firstKey();
    }

    public void seekToTile(int n) {
        CloserUtil.close(this.parser);
        this.currentTile = n;
        this.initializeParser();
    }

    private void initializeParser() {
        List<File> list = this.files.getFilesStartingAt(this.currentTile);
        this.parser = new BasicInputParser(this.treatGroupedDelimitersAsOne, list.toArray(new File[list.size()]));
    }

    @Override
    public String[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (String[])this.parser.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by IlluminaTextIterator");
    }

    @Override
    public boolean hasNext() {
        if (this.parser == null) {
            this.initializeParser();
        }
        return this.parser.hasNext();
    }

    protected int getLane() {
        return this.lane;
    }

    public String getCurrentFilename() {
        if (this.parser == null) {
            this.initializeParser();
        }
        return this.parser.getFileName();
    }

    protected void validateLane(int n) {
        if (n != this.getLane()) {
            throw new PicardException("Lane number mismatch: " + n + " != " + this.getLane());
        }
    }
}

