/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.AbstractFastaSequenceFile;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;

public class IndexedFastaSequenceFile
extends AbstractFastaSequenceFile
implements Closeable {
    private static final int BUFFER_SIZE = 131072;
    private final FileChannel channel;
    private final FastaSequenceIndex index;
    private Iterator<FastaSequenceIndexEntry> indexIterator;

    public IndexedFastaSequenceFile(File file, FastaSequenceIndex fastaSequenceIndex) {
        super(file);
        FileInputStream fileInputStream;
        if (fastaSequenceIndex == null) {
            throw new IllegalArgumentException("Null index for fasta " + file);
        }
        this.index = fastaSequenceIndex;
        IoUtil.assertFileIsReadable(file);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PicardException("Fasta file should be readable but is not: " + file, fileNotFoundException);
        }
        this.channel = fileInputStream.getChannel();
        this.reset();
        if (this.getSequenceDictionary() != null) {
            IndexedFastaSequenceFile.sanityCheckDictionaryAgainstIndex(file.getAbsolutePath(), this.sequenceDictionary, fastaSequenceIndex);
        }
    }

    public IndexedFastaSequenceFile(File file) throws FileNotFoundException {
        this(file, new FastaSequenceIndex(IndexedFastaSequenceFile.findRequiredFastaIndexFile(file)));
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    private static File findFastaIndex(File file) {
        File file2 = IndexedFastaSequenceFile.getFastaIndexFileName(file);
        if (!file2.exists()) {
            return null;
        }
        return file2;
    }

    private static File getFastaIndexFileName(File file) {
        return new File(file.getAbsolutePath() + ".fai");
    }

    private static File findRequiredFastaIndexFile(File file) throws FileNotFoundException {
        File file2 = IndexedFastaSequenceFile.findFastaIndex(file);
        if (file2 == null) {
            throw new FileNotFoundException(IndexedFastaSequenceFile.getFastaIndexFileName(file) + " not found.");
        }
        return file2;
    }

    public static boolean canCreateIndexedFastaReader(File file) {
        return file.exists() && IndexedFastaSequenceFile.findFastaIndex(file) != null;
    }

    protected static void sanityCheckDictionaryAgainstIndex(String string2, SAMSequenceDictionary sAMSequenceDictionary, FastaSequenceIndex fastaSequenceIndex) {
        if (sAMSequenceDictionary.getSequences().size() != fastaSequenceIndex.size()) {
            throw new PicardException("Sequence dictionary and index contain different numbers of contigs");
        }
        Iterator<SAMSequenceRecord> iterator2 = sAMSequenceDictionary.getSequences().iterator();
        Iterator<FastaSequenceIndexEntry> iterator3 = fastaSequenceIndex.iterator();
        while (iterator2.hasNext() && iterator3.hasNext()) {
            SAMSequenceRecord sAMSequenceRecord = iterator2.next();
            FastaSequenceIndexEntry fastaSequenceIndexEntry = iterator3.next();
            if (!sAMSequenceRecord.getSequenceName().equals(fastaSequenceIndexEntry.getContig())) {
                throw new PicardException(String.format("Mismatch between sequence dictionary fasta index for %s, sequence '%s' != '%s'.", string2, sAMSequenceRecord.getSequenceName(), fastaSequenceIndexEntry.getContig()));
            }
            if ((long)sAMSequenceRecord.getSequenceLength() == fastaSequenceIndexEntry.getSize()) continue;
            throw new PicardException("Index length does not match dictionary length for contig: " + sAMSequenceRecord.getSequenceName());
        }
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public ReferenceSequence getSequence(String string2) {
        return this.getSubsequenceAt(string2, 1L, (int)this.index.getIndexEntry(string2).getSize());
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String string2, long l, long l2) {
        if (l > l2 + 1L) {
            throw new PicardException(String.format("Malformed query; start point %d lies after end point %d", l, l2));
        }
        FastaSequenceIndexEntry fastaSequenceIndexEntry = this.index.getIndexEntry(string2);
        if (l2 > fastaSequenceIndexEntry.getSize()) {
            throw new PicardException("Query asks for data past end of contig");
        }
        int n = (int)(l2 - l + 1L);
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = fastaSequenceIndexEntry.getBasesPerLine();
        int n3 = fastaSequenceIndexEntry.getBytesPerLine();
        int n4 = n3 - n2;
        long l3 = (l - 1L) / (long)n2 * (long)n3 + (l - 1L) % (long)n2;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(131072);
        while (byteBuffer.position() < n) {
            l3 += (long)Math.max((int)(l3 % (long)n3 - (long)n2 + 1L), 0);
            try {
                l3 += (long)this.channel.read(byteBuffer2, fastaSequenceIndexEntry.getLocation() + l3);
            }
            catch (IOException iOException) {
                throw new PicardException("Unable to load " + string2 + "(" + l + ", " + l2 + ") from " + this.file);
            }
            byteBuffer2.flip();
            int n5 = (int)l - 1 + byteBuffer.position();
            int n6 = Math.min(n2 - n5 % n2, n - byteBuffer.position());
            int n7 = Math.min(n6, byteBuffer2.capacity());
            byteBuffer2.limit(byteBuffer2.position() + n7);
            while (byteBuffer2.hasRemaining()) {
                byteBuffer.put(byteBuffer2);
                n7 = Math.min(n2, n - byteBuffer.position());
                byteBuffer2.limit(Math.min(byteBuffer2.position() + n7 + n4, byteBuffer2.capacity()));
                byteBuffer2.position(Math.min(byteBuffer2.position() + n4, byteBuffer2.capacity()));
            }
            byteBuffer2.flip();
        }
        return new ReferenceSequence(string2, fastaSequenceIndexEntry.getSequenceIndex(), byArray);
    }

    @Override
    public ReferenceSequence nextSequence() {
        if (!this.indexIterator.hasNext()) {
            return null;
        }
        return this.getSequence(this.indexIterator.next().getContig());
    }

    @Override
    public void reset() {
        this.indexIterator = this.index.iterator();
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

