/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.sam.AbstractDuplicateFindingAlgorithm;
import net.sf.picard.sam.DiskReadEndsMap;
import net.sf.picard.sam.DuplicationMetrics;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.ReadEnds;
import net.sf.picard.sam.ReadEndsCodec;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SortingCollection;
import net.sf.samtools.util.SortingLongCollection;

public class MarkDuplicates
extends AbstractDuplicateFindingAlgorithm {
    private final Log log = Log.getInstance(MarkDuplicates.class);
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules. " + "All records are then written to the output file with the duplicate records flagged.";
    @Option(shortName="I", doc="One or more input SAM or BAM files to analyze. Must be coordinate sorted.")
    public List<File> INPUT;
    @Option(shortName="O", doc="The output file to right marked records to")
    public File OUTPUT;
    @Option(shortName="M", doc="File to write duplication metrics to")
    public File METRICS_FILE;
    @Option(shortName="PG", doc="The program record ID for the @PG record(s) created by this program. Set to null to disable PG record creation.  This string may have a suffix appended to avoid collision with other program record IDs.", optional=true)
    public String PROGRAM_RECORD_ID = "MarkDuplicates";
    @Option(shortName="PG_VERSION", doc="Value of VN tag of PG record to be created. If not specified, the version will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_VERSION;
    @Option(shortName="PG_COMMAND", doc="Value of CL tag of PG record to be created. If not supplied the command line will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_COMMAND_LINE;
    @Option(shortName="PG_NAME", doc="Value of PN tag of PG record to be created.")
    public String PROGRAM_GROUP_NAME = "MarkDuplicates";
    @Option(shortName="CO", doc="Comment(s) to include in the output file's header.", optional=true)
    public List<String> COMMENT = new ArrayList<String>();
    @Option(doc="If true do not write duplicates to the output file instead of writing them with appropriate flags set.")
    public boolean REMOVE_DUPLICATES = false;
    @Option(shortName="AS", doc="If true, assume that the input file is coordinate sorted even if the header says otherwise.")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="MAX_SEQS", doc="This option is obsolete. ReadEnds will always be spilled to disk.")
    public int MAX_SEQUENCES_FOR_DISK_READ_ENDS_MAP = 50000;
    @Option(shortName="MAX_FILE_HANDLES", doc="Maximum number of file handles to keep open when spilling read ends to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_FILE_HANDLES_FOR_READ_ENDS_MAP = 8000;
    @Option(doc="This number, plus the maximum RAM available to the JVM, determine the memory footprint used by some of the sorting collections.  If you are running out of memory, try reducing this number.")
    public double SORTING_COLLECTION_SIZE_RATIO = 0.25;
    private SortingCollection<ReadEnds> pairSort;
    private SortingCollection<ReadEnds> fragSort;
    private SortingLongCollection duplicateIndexes;
    private int numDuplicateIndices = 0;
    private final Map<String, Short> libraryIds = new HashMap<String, Short>();
    private short nextLibraryId = 1;
    private final Histogram<Short> opticalDupesByLibraryId = new Histogram();
    private final Set<String> pgIdsSeen = new HashSet<String>();

    public static void main(String[] stringArray) {
        System.exit(new MarkDuplicates().instanceMain(stringArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doWork() {
        Object object;
        Object object2;
        Object object3;
        for (File object62 : this.INPUT) {
            IoUtil.assertFileIsReadable(object62);
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.METRICS_FILE);
        this.reportMemoryStats("Start of doWork");
        this.log.info("Reading input file and constructing read end information.");
        this.buildSortedReadEndLists();
        this.reportMemoryStats("After buildSortedReadEndLists");
        this.generateDuplicateIndexes();
        this.reportMemoryStats("After generateDuplicateIndexes");
        this.log.info("Marking " + this.numDuplicateIndices + " records as duplicates.");
        this.log.info("Found " + (long)this.opticalDupesByLibraryId.getSumOfValues() + " optical duplicate clusters.");
        HashMap hashMap = new HashMap();
        SamHeaderAndIterator samHeaderAndIterator = this.openInputs();
        SAMFileHeader sAMFileHeader = samHeaderAndIterator.header;
        SAMFileHeader sAMFileHeader2 = sAMFileHeader.clone();
        sAMFileHeader2.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        for (String string2 : this.COMMENT) {
            sAMFileHeader2.addComment(string2);
        }
        if (this.PROGRAM_RECORD_ID != null) {
            PgIdGenerator pgIdGenerator = new PgIdGenerator(sAMFileHeader2);
            if (this.PROGRAM_GROUP_VERSION == null) {
                this.PROGRAM_GROUP_VERSION = this.getVersion();
            }
            if (this.PROGRAM_GROUP_COMMAND_LINE == null) {
                this.PROGRAM_GROUP_COMMAND_LINE = this.getCommandLine();
            }
            object3 = new HashMap();
            for (String string3 : this.pgIdsSeen) {
                String string4 = pgIdGenerator.getNonCollidingId(this.PROGRAM_RECORD_ID);
                object3.put(string3, string4);
                SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(string4);
                sAMProgramRecord.setProgramVersion(this.PROGRAM_GROUP_VERSION);
                sAMProgramRecord.setCommandLine(this.PROGRAM_GROUP_COMMAND_LINE);
                sAMProgramRecord.setProgramName(this.PROGRAM_GROUP_NAME);
                sAMProgramRecord.setPreviousProgramGroupId(string3);
                sAMFileHeader2.addProgramRecord(sAMProgramRecord);
            }
        } else {
            object3 = null;
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, true, this.OUTPUT);
        long l = 0L;
        long l2 = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : -1L;
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            object2 = sAMReadGroupRecord.getLibrary();
            object = (DuplicationMetrics)hashMap.get(object2);
            if (object != null) continue;
            object = new DuplicationMetrics();
            ((DuplicationMetrics)object).LIBRARY = object2;
            hashMap.put(object2, object);
        }
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Written");
        CloseableIterator<SAMRecord> closeableIterator = samHeaderAndIterator.iterator;
        while (closeableIterator.hasNext()) {
            object2 = (SAMRecord)closeableIterator.next();
            if (!((SAMRecord)object2).isSecondaryOrSupplementary()) {
                void var15_22;
                object = this.getLibraryName(sAMFileHeader, (SAMRecord)object2);
                DuplicationMetrics duplicationMetrics = (DuplicationMetrics)hashMap.get(object);
                if (duplicationMetrics == null) {
                    DuplicationMetrics duplicationMetrics2 = new DuplicationMetrics();
                    duplicationMetrics2.LIBRARY = object;
                    hashMap.put(object, duplicationMetrics2);
                }
                if (((SAMRecord)object2).getReadUnmappedFlag()) {
                    ++var15_22.UNMAPPED_READS;
                } else if (!((SAMRecord)object2).getReadPairedFlag() || ((SAMRecord)object2).getMateUnmappedFlag()) {
                    ++var15_22.UNPAIRED_READS_EXAMINED;
                } else {
                    ++var15_22.READ_PAIRS_EXAMINED;
                }
                if (l == l2) {
                    ((SAMRecord)object2).setDuplicateReadFlag(true);
                    if (!((SAMRecord)object2).getReadPairedFlag() || ((SAMRecord)object2).getMateUnmappedFlag()) {
                        ++var15_22.UNPAIRED_READ_DUPLICATES;
                    } else {
                        ++var15_22.READ_PAIR_DUPLICATES;
                    }
                    l2 = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : -1L;
                } else {
                    ((SAMRecord)object2).setDuplicateReadFlag(false);
                }
            }
            ++l;
            if (this.REMOVE_DUPLICATES && ((SAMRecord)object2).getDuplicateReadFlag()) continue;
            if (this.PROGRAM_RECORD_ID != null) {
                ((SAMRecord)object2).setAttribute(SAMTag.PG.name(), object3.get(((SAMRecord)object2).getStringAttribute(SAMTag.PG.name())));
            }
            sAMFileWriter.addAlignment((SAMRecord)object2);
            progressLogger.record((SAMRecord)object2);
        }
        this.duplicateIndexes.cleanup();
        this.reportMemoryStats("Before output close");
        sAMFileWriter.close();
        this.reportMemoryStats("After output close");
        object2 = this.getMetricsFile();
        for (Map.Entry entry : hashMap.entrySet()) {
            Histogram.Bin bin;
            String string5 = (String)entry.getKey();
            DuplicationMetrics duplicationMetrics = (DuplicationMetrics)entry.getValue();
            duplicationMetrics.READ_PAIRS_EXAMINED /= 2L;
            duplicationMetrics.READ_PAIR_DUPLICATES /= 2L;
            Short s2 = this.libraryIds.get(string5);
            if (s2 != null && (bin = (Histogram.Bin)this.opticalDupesByLibraryId.get(s2)) != null) {
                duplicationMetrics.READ_PAIR_OPTICAL_DUPLICATES = (long)bin.getValue();
            }
            duplicationMetrics.calculateDerivedMetrics();
            ((MetricsFile)object2).addMetric(duplicationMetrics);
        }
        if (hashMap.size() == 1) {
            ((MetricsFile)object2).setHistogram(((DuplicationMetrics)hashMap.values().iterator().next()).calculateRoiHistogram());
        }
        ((MetricsFile)object2).write(this.METRICS_FILE);
        return 0;
    }

    private SamHeaderAndIterator openInputs() {
        ArrayList<SAMFileHeader> arrayList = new ArrayList<SAMFileHeader>(this.INPUT.size());
        ArrayList<SAMFileReader> arrayList2 = new ArrayList<SAMFileReader>(this.INPUT.size());
        for (File object2 : this.INPUT) {
            SAMFileReader sAMFileReader = new SAMFileReader(object2);
            SAMFileHeader sAMFileHeader = sAMFileReader.getFileHeader();
            if (!this.ASSUME_SORTED && sAMFileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                throw new PicardException("Input file " + object2.getAbsolutePath() + " is not coordinate sorted.");
            }
            arrayList.add(sAMFileHeader);
            arrayList2.add(sAMFileReader);
        }
        if (arrayList.size() == 1) {
            return new SamHeaderAndIterator((SAMFileHeader)arrayList.get(0), ((SAMFileReader)arrayList2.get(0)).iterator());
        }
        SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, arrayList, false);
        MergingSamRecordIterator mergingSamRecordIterator = new MergingSamRecordIterator(samFileHeaderMerger, arrayList2, this.ASSUME_SORTED);
        return new SamHeaderAndIterator(samFileHeaderMerger.getMergedHeader(), mergingSamRecordIterator);
    }

    private void reportMemoryStats(String string2) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        this.log.info(string2 + " freeMemory: " + runtime.freeMemory() + "; totalMemory: " + runtime.totalMemory() + "; maxMemory: " + runtime.maxMemory());
    }

    private void buildSortedReadEndLists() {
        int n = (int)((double)Runtime.getRuntime().maxMemory() * this.SORTING_COLLECTION_SIZE_RATIO / 63.0);
        this.log.info("Will retain up to " + n + " data points before spilling to disk.");
        this.pairSort = SortingCollection.newInstance(ReadEnds.class, new ReadEndsCodec(), new ReadEndsComparator(), n, this.TMP_DIR);
        this.fragSort = SortingCollection.newInstance(ReadEnds.class, new ReadEndsCodec(), new ReadEndsComparator(), n, this.TMP_DIR);
        SamHeaderAndIterator samHeaderAndIterator = this.openInputs();
        SAMFileHeader sAMFileHeader = samHeaderAndIterator.header;
        DiskReadEndsMap diskReadEndsMap = new DiskReadEndsMap(this.MAX_FILE_HANDLES_FOR_READ_ENDS_MAP);
        long l = 0L;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 1000000, "Read");
        CloseableIterator<SAMRecord> closeableIterator = samHeaderAndIterator.iterator;
        while (closeableIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)closeableIterator.next();
            if (this.PROGRAM_RECORD_ID != null) {
                this.pgIdsSeen.add(sAMRecord.getStringAttribute(SAMTag.PG.name()));
            }
            if (sAMRecord.getReadUnmappedFlag()) {
                if (sAMRecord.getReferenceIndex() == -1) {
                    break;
                }
            } else if (!sAMRecord.isSecondaryOrSupplementary()) {
                ReadEnds readEnds = this.buildReadEnds(sAMFileHeader, l, sAMRecord);
                this.fragSort.add(readEnds);
                if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                    String string2 = sAMRecord.getAttribute(ReservedTagConstants.READ_GROUP_ID) + ":" + sAMRecord.getReadName();
                    ReadEnds readEnds2 = diskReadEndsMap.remove(sAMRecord.getReferenceIndex(), string2);
                    if (readEnds2 == null) {
                        readEnds2 = this.buildReadEnds(sAMFileHeader, l, sAMRecord);
                        diskReadEndsMap.put(readEnds2.read2Sequence, string2, readEnds2);
                    } else {
                        int n2 = readEnds.read1Sequence;
                        int n3 = readEnds.read1Coordinate;
                        if (n2 > readEnds2.read1Sequence || n2 == readEnds2.read1Sequence && n3 >= readEnds2.read1Coordinate) {
                            readEnds2.read2Sequence = n2;
                            readEnds2.read2Coordinate = n3;
                            readEnds2.read2IndexInFile = l;
                            readEnds2.orientation = this.getOrientationByte(readEnds2.orientation == 1, sAMRecord.getReadNegativeStrandFlag());
                        } else {
                            readEnds2.read2Sequence = readEnds2.read1Sequence;
                            readEnds2.read2Coordinate = readEnds2.read1Coordinate;
                            readEnds2.read2IndexInFile = readEnds2.read1IndexInFile;
                            readEnds2.read1Sequence = n2;
                            readEnds2.read1Coordinate = n3;
                            readEnds2.read1IndexInFile = l;
                            readEnds2.orientation = this.getOrientationByte(sAMRecord.getReadNegativeStrandFlag(), readEnds2.orientation == 1);
                        }
                        readEnds2.score = (short)(readEnds2.score + this.getScore(sAMRecord));
                        this.pairSort.add(readEnds2);
                    }
                }
            }
            ++l;
            if (!progressLogger.record(sAMRecord)) continue;
            this.log.info("Tracking " + diskReadEndsMap.size() + " as yet unmatched pairs. " + diskReadEndsMap.sizeInRam() + " records in RAM.");
        }
        this.log.info("Read " + l + " records. " + diskReadEndsMap.size() + " pairs never matched.");
        closeableIterator.close();
        this.pairSort.doneAdding();
        this.fragSort.doneAdding();
    }

    private ReadEnds buildReadEnds(SAMFileHeader sAMFileHeader, long l, SAMRecord sAMRecord) {
        ReadEnds readEnds = new ReadEnds();
        readEnds.read1Sequence = sAMRecord.getReferenceIndex();
        readEnds.read1Coordinate = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getUnclippedEnd() : sAMRecord.getUnclippedStart();
        readEnds.orientation = sAMRecord.getReadNegativeStrandFlag() ? (byte)1 : 0;
        readEnds.read1IndexInFile = l;
        readEnds.score = this.getScore(sAMRecord);
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
            readEnds.read2Sequence = sAMRecord.getMateReferenceIndex();
        }
        readEnds.libraryId = this.getLibraryId(sAMFileHeader, sAMRecord);
        if (this.addLocationInformation(sAMRecord.getReadName(), readEnds)) {
            readEnds.readGroup = 0;
            String string2 = (String)sAMRecord.getAttribute("RG");
            List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
            if (string2 != null && list != null) {
                for (SAMReadGroupRecord sAMReadGroupRecord : list) {
                    if (sAMReadGroupRecord.getReadGroupId().equals(string2)) break;
                    readEnds.readGroup = (short)(readEnds.readGroup + 1);
                }
            }
        }
        return readEnds;
    }

    private short getLibraryId(SAMFileHeader sAMFileHeader, SAMRecord sAMRecord) {
        String string2 = this.getLibraryName(sAMFileHeader, sAMRecord);
        Short s2 = this.libraryIds.get(string2);
        if (s2 == null) {
            short s3 = this.nextLibraryId;
            this.nextLibraryId = (short)(s3 + 1);
            s2 = s3;
            this.libraryIds.put(string2, s2);
        }
        return s2;
    }

    private String getLibraryName(SAMFileHeader sAMFileHeader, SAMRecord sAMRecord) {
        SAMReadGroupRecord sAMReadGroupRecord;
        String string2 = (String)sAMRecord.getAttribute("RG");
        if (string2 != null && (sAMReadGroupRecord = sAMFileHeader.getReadGroup(string2)) != null) {
            return sAMReadGroupRecord.getLibrary();
        }
        return "Unknown Library";
    }

    private byte getOrientationByte(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return 4;
            }
            return 5;
        }
        if (bl2) {
            return 3;
        }
        return 2;
    }

    private short getScore(SAMRecord sAMRecord) {
        short s2 = 0;
        for (byte by2 : sAMRecord.getBaseQualities()) {
            if (by2 < 15) continue;
            s2 = (short)(s2 + by2);
        }
        return s2;
    }

    private void generateDuplicateIndexes() {
        int n = (int)((double)Runtime.getRuntime().maxMemory() * 0.25 / 8.0);
        this.log.info("Will retain up to " + n + " duplicate indices before spilling to disk.");
        this.duplicateIndexes = new SortingLongCollection(n, this.TMP_DIR.toArray(new File[this.TMP_DIR.size()]));
        ReadEnds readEnds = null;
        ArrayList<ReadEnds> arrayList = new ArrayList<ReadEnds>(200);
        this.log.info("Traversing read pair information and detecting duplicates.");
        for (ReadEnds readEnds2 : this.pairSort) {
            if (readEnds == null) {
                readEnds = readEnds2;
                arrayList.add(readEnds);
                continue;
            }
            if (this.areComparableForDuplicates(readEnds, readEnds2, true)) {
                arrayList.add(readEnds2);
                continue;
            }
            if (arrayList.size() > 1) {
                this.markDuplicatePairs(arrayList);
            }
            arrayList.clear();
            arrayList.add(readEnds2);
            readEnds = readEnds2;
        }
        this.markDuplicatePairs(arrayList);
        this.pairSort.cleanup();
        this.pairSort = null;
        this.log.info("Traversing fragment information and detecting duplicates.");
        boolean bl = false;
        boolean bl2 = false;
        for (ReadEnds readEnds3 : this.fragSort) {
            if (readEnds != null && this.areComparableForDuplicates(readEnds, readEnds3, false)) {
                arrayList.add(readEnds3);
                bl = bl || readEnds3.isPaired();
                bl2 = bl2 || !readEnds3.isPaired();
                continue;
            }
            if (arrayList.size() > 1 && bl2) {
                this.markDuplicateFragments(arrayList, bl);
            }
            arrayList.clear();
            arrayList.add(readEnds3);
            readEnds = readEnds3;
            bl = readEnds3.isPaired();
            bl2 = !readEnds3.isPaired();
        }
        this.markDuplicateFragments(arrayList, bl);
        this.fragSort.cleanup();
        this.fragSort = null;
        this.log.info("Sorting list of duplicate records.");
        this.duplicateIndexes.doneAddingStartIteration();
    }

    private boolean areComparableForDuplicates(ReadEnds readEnds, ReadEnds readEnds2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = readEnds.libraryId == readEnds2.libraryId && readEnds.read1Sequence == readEnds2.read1Sequence && readEnds.read1Coordinate == readEnds2.read1Coordinate && readEnds.orientation == readEnds2.orientation;
        if (bl2 && bl) {
            bl2 = readEnds.read2Sequence == readEnds2.read2Sequence && readEnds.read2Coordinate == readEnds2.read2Coordinate;
        }
        return bl2;
    }

    private void addIndexAsDuplicate(long l) {
        this.duplicateIndexes.add(l);
        ++this.numDuplicateIndices;
    }

    private void markDuplicatePairs(List<ReadEnds> list) {
        short s2 = 0;
        ReadEnds readEnds = null;
        for (ReadEnds readEnds2 : list) {
            if (readEnds2.score <= s2 && readEnds != null) continue;
            s2 = readEnds2.score;
            readEnds = readEnds2;
        }
        for (ReadEnds readEnds2 : list) {
            if (readEnds2 == readEnds) continue;
            this.addIndexAsDuplicate(readEnds2.read1IndexInFile);
            this.addIndexAsDuplicate(readEnds2.read2IndexInFile);
        }
        this.trackOpticalDuplicates(list);
    }

    private void trackOpticalDuplicates(List<ReadEnds> list) {
        boolean[] blArray = this.findOpticalDuplicates(list, this.OPTICAL_DUPLICATE_PIXEL_DISTANCE);
        int n = 0;
        for (boolean bl : blArray) {
            if (!bl) continue;
            ++n;
        }
        if (n > 0) {
            this.opticalDupesByLibraryId.increment(list.get((int)0).libraryId, n);
        }
    }

    private void markDuplicateFragments(List<ReadEnds> list, boolean bl) {
        if (bl) {
            for (ReadEnds readEnds : list) {
                if (readEnds.isPaired()) continue;
                this.addIndexAsDuplicate(readEnds.read1IndexInFile);
            }
        } else {
            short s2 = 0;
            ReadEnds readEnds = null;
            for (ReadEnds readEnds2 : list) {
                if (readEnds2.score <= s2 && readEnds != null) continue;
                s2 = readEnds2.score;
                readEnds = readEnds2;
            }
            for (ReadEnds readEnds2 : list) {
                if (readEnds2 == readEnds) continue;
                this.addIndexAsDuplicate(readEnds2.read1IndexInFile);
            }
        }
    }

    static class PgIdGenerator {
        private int recordCounter;
        private final Set<String> idsThatAreAlreadyTaken = new HashSet<String>();

        PgIdGenerator(SAMFileHeader sAMFileHeader) {
            for (SAMProgramRecord sAMProgramRecord : sAMFileHeader.getProgramRecords()) {
                this.idsThatAreAlreadyTaken.add(sAMProgramRecord.getProgramGroupId());
            }
            this.recordCounter = this.idsThatAreAlreadyTaken.size();
        }

        String getNonCollidingId(String string2) {
            String string3;
            if (!this.idsThatAreAlreadyTaken.contains(string2)) {
                this.idsThatAreAlreadyTaken.add(string2);
                ++this.recordCounter;
                return string2;
            }
            while (this.idsThatAreAlreadyTaken.contains(string3 = string2 + "." + SamFileHeaderMerger.positiveFourDigitBase36Str(this.recordCounter++))) {
            }
            this.idsThatAreAlreadyTaken.add(string3);
            return string3;
        }
    }

    static class ReadEndsComparator
    implements Comparator<ReadEnds> {
        ReadEndsComparator() {
        }

        @Override
        public int compare(ReadEnds readEnds, ReadEnds readEnds2) {
            int n = readEnds.libraryId - readEnds2.libraryId;
            if (n == 0) {
                n = readEnds.read1Sequence - readEnds2.read1Sequence;
            }
            if (n == 0) {
                n = readEnds.read1Coordinate - readEnds2.read1Coordinate;
            }
            if (n == 0) {
                n = readEnds.orientation - readEnds2.orientation;
            }
            if (n == 0) {
                n = readEnds.read2Sequence - readEnds2.read2Sequence;
            }
            if (n == 0) {
                n = readEnds.read2Coordinate - readEnds2.read2Coordinate;
            }
            if (n == 0) {
                n = (int)(readEnds.read1IndexInFile - readEnds2.read1IndexInFile);
            }
            if (n == 0) {
                n = (int)(readEnds.read2IndexInFile - readEnds2.read2IndexInFile);
            }
            return n;
        }
    }

    private static final class SamHeaderAndIterator {
        final SAMFileHeader header;
        final CloseableIterator<SAMRecord> iterator;

        private SamHeaderAndIterator(SAMFileHeader sAMFileHeader, CloseableIterator<SAMRecord> closeableIterator) {
            this.header = sAMFileHeader;
            this.iterator = closeableIterator;
        }
    }
}

