/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalTree;

public class IntervalTreeMap<T>
extends AbstractMap<Interval, T> {
    private final Map<String, IntervalTree<T>> mSequenceMap = new HashMap<String, IntervalTree<T>>();
    private final EntrySet mEntrySet = new EntrySet();

    public IntervalTree<T> debugGetTree(String string2) {
        return this.mSequenceMap.get(string2);
    }

    public IntervalTreeMap() {
    }

    public IntervalTreeMap(Map<? extends Interval, ? extends T> map2) {
        for (Map.Entry<Interval, T> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mSequenceMap.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        return this.containsKey((Interval)object);
    }

    public boolean containsKey(Interval interval) {
        IntervalTree<T> intervalTree = this.mSequenceMap.get(interval.getSequence());
        if (intervalTree == null) {
            return false;
        }
        return intervalTree.find(interval.getStart(), interval.getEnd()) != null;
    }

    @Override
    public Set<Map.Entry<Interval, T>> entrySet() {
        return this.mEntrySet;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IntervalTreeMap)) {
            return false;
        }
        return this.mSequenceMap.equals(((IntervalTreeMap)object).mSequenceMap);
    }

    @Override
    public int hashCode() {
        return this.mSequenceMap.hashCode();
    }

    @Override
    public T get(Object object) {
        if (!(object instanceof Interval)) {
            return null;
        }
        return this.get((Interval)object);
    }

    public T get(Interval interval) {
        IntervalTree<T> intervalTree = this.mSequenceMap.get(interval.getSequence());
        if (intervalTree == null) {
            return null;
        }
        IntervalTree.Node<T> node = intervalTree.find(interval.getStart(), interval.getEnd());
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    @Override
    public boolean isEmpty() {
        for (IntervalTree<T> intervalTree : this.mSequenceMap.values()) {
            if (intervalTree.size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public T put(Interval interval, T t) {
        IntervalTree<Object> intervalTree = this.mSequenceMap.get(interval.getSequence());
        if (intervalTree == null) {
            intervalTree = new IntervalTree();
            this.mSequenceMap.put(interval.getSequence(), intervalTree);
        }
        return intervalTree.put(interval.getStart(), interval.getEnd(), t);
    }

    @Override
    public T remove(Object object) {
        if (!(object instanceof Interval)) {
            return null;
        }
        return this.remove((Interval)object);
    }

    public T remove(Interval interval) {
        IntervalTree<T> intervalTree = this.mSequenceMap.get(interval.getSequence());
        if (intervalTree == null) {
            return null;
        }
        return intervalTree.remove(interval.getStart(), interval.getEnd());
    }

    @Override
    public int size() {
        int n = 0;
        for (IntervalTree<T> intervalTree : this.mSequenceMap.values()) {
            n += intervalTree.size();
        }
        return n;
    }

    public Collection<T> getOverlapping(Interval interval) {
        ArrayList<T> arrayList = new ArrayList<T>();
        IntervalTree<T> intervalTree = this.mSequenceMap.get(interval.getSequence());
        if (intervalTree != null) {
            Iterator<IntervalTree.Node<T>> iterator2 = intervalTree.overlappers(interval.getStart(), interval.getEnd());
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next().getValue());
            }
        }
        return arrayList;
    }

    public Collection<T> getContained(Interval interval) {
        ArrayList<T> arrayList = new ArrayList<T>();
        IntervalTree<T> intervalTree = this.mSequenceMap.get(interval.getSequence());
        if (intervalTree != null) {
            Iterator<IntervalTree.Node<T>> iterator2 = intervalTree.overlappers(interval.getStart(), interval.getEnd());
            while (iterator2.hasNext()) {
                IntervalTree.Node<T> node = iterator2.next();
                if (node.getStart() < interval.getStart() || node.getEnd() > interval.getEnd()) continue;
                arrayList.add(node.getValue());
            }
        }
        return arrayList;
    }

    private class MapEntry
    implements Map.Entry<Interval, T> {
        private final Interval mKey;
        private T mValue;

        MapEntry(Interval interval, T t) {
            this.mKey = interval;
            this.mValue = t;
        }

        @Override
        public Interval getKey() {
            return this.mKey;
        }

        @Override
        public T getValue() {
            return this.mValue;
        }

        @Override
        public T setValue(T t) {
            this.mValue = t;
            return IntervalTreeMap.this.put(this.mKey, this.mValue);
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<Interval, T>> {
        private String mSequence = null;
        private Iterator<String> mSequenceIterator = null;
        private Iterator<IntervalTree.Node<T>> mTreeIterator = null;

        EntryIterator() {
            this.mSequenceIterator = IntervalTreeMap.this.mSequenceMap.keySet().iterator();
            this.advanceSequence();
        }

        @Override
        public boolean hasNext() {
            return this.mTreeIterator != null && this.mTreeIterator.hasNext();
        }

        @Override
        public Map.Entry<Interval, T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            IntervalTree.Node node = this.mTreeIterator.next();
            String string2 = this.mSequence;
            if (!this.mTreeIterator.hasNext()) {
                this.advanceSequence();
            }
            Interval interval = new Interval(string2, node.getStart(), node.getEnd());
            Object t = node.getValue();
            return new MapEntry(interval, t);
        }

        @Override
        public void remove() {
            if (this.mTreeIterator == null) {
                throw new IllegalStateException("Iterator.next() has not been called");
            }
            this.mTreeIterator.remove();
        }

        private void advanceSequence() {
            while (this.mSequenceIterator.hasNext()) {
                this.mSequence = this.mSequenceIterator.next();
                this.mTreeIterator = ((IntervalTree)IntervalTreeMap.this.mSequenceMap.get(this.mSequence)).iterator();
                if (!this.mTreeIterator.hasNext()) continue;
                break;
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Interval, T>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            IntervalTreeMap.this.clear();
        }

        public boolean contains(Map.Entry<Interval, T> entry) {
            if (entry == null) {
                return false;
            }
            return entry.getValue().equals(IntervalTreeMap.this.get(entry.getKey()));
        }

        @Override
        public boolean isEmpty() {
            return IntervalTreeMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<Interval, T>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return this.remove((Map.Entry)object);
        }

        public boolean remove(Map.Entry<Interval, T> entry) {
            if (this.contains(entry)) {
                IntervalTreeMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return IntervalTreeMap.this.size();
        }
    }
}

