/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import net.sf.samtools.Defaults;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.RuntimeIOException;

public class SortingLongCollection {
    public static final int SIZEOF = 8;
    public static final int MAX_ITEMS_IN_RAM = (int)Math.floor(2.68167019545E8);
    private final File[] tmpDir;
    private final int maxValuesInRam;
    private int numValuesInRam = 0;
    private long[] ramValues;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<File> files = new ArrayList<File>();
    private int iterationIndex = 0;
    private PriorityQueue<PeekFileValueIterator> priorityQueue;

    public SortingLongCollection(int n, File ... fileArray) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxValuesInRam must be > 0");
        }
        this.tmpDir = fileArray;
        this.maxValuesInRam = Math.min(n, MAX_ITEMS_IN_RAM);
        this.ramValues = new long[n];
    }

    public void add(long l) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAddingStartIteration()");
        }
        if (this.numValuesInRam == this.maxValuesInRam) {
            this.spillToDisk();
        }
        this.ramValues[this.numValuesInRam++] = l;
    }

    public void doneAddingStartIteration() {
        if (this.cleanedUp || this.doneAdding) {
            throw new IllegalStateException("Cannot call doneAddingStartIteration() after cleanup() was called.");
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            Arrays.sort(this.ramValues, 0, this.numValuesInRam);
            return;
        }
        if (this.numValuesInRam > 0) {
            this.spillToDisk();
        }
        this.priorityQueue = new PriorityQueue<PeekFileValueIterator>(this.files.size(), new PeekFileValueIteratorComparator());
        for (File file : this.files) {
            FileValueIterator fileValueIterator = new FileValueIterator(file);
            if (!fileValueIterator.hasNext()) continue;
            this.priorityQueue.offer(new PeekFileValueIterator(fileValueIterator));
        }
        this.ramValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillToDisk() {
        try {
            Arrays.sort(this.ramValues, 0, this.numValuesInRam);
            File file = IOUtil.newTempFile("sortingcollection.", ".tmp", this.tmpDir, 0x140000000L);
            FilterOutputStream filterOutputStream = null;
            try {
                long l = this.numValuesInRam * 8;
                filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), Defaults.BUFFER_SIZE));
                file.deleteOnExit();
                for (int i = 0; i < this.numValuesInRam; ++i) {
                    ((DataOutputStream)filterOutputStream).writeLong(this.ramValues[i]);
                }
                ((DataOutputStream)filterOutputStream).flush();
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            this.numValuesInRam = 0;
            this.files.add(file);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public void cleanup() {
        this.doneAdding = true;
        this.cleanedUp = true;
        this.ramValues = null;
        IOUtil.deleteFiles(this.files);
    }

    public boolean hasNext() {
        if (!this.doneAdding || this.cleanedUp) {
            throw new IllegalStateException();
        }
        if (this.ramValues != null) {
            return this.iterationIndex < this.numValuesInRam;
        }
        return !this.priorityQueue.isEmpty();
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.ramValues != null) {
            return this.ramValues[this.iterationIndex++];
        }
        PeekFileValueIterator peekFileValueIterator = this.priorityQueue.poll();
        long l = peekFileValueIterator.next();
        if (peekFileValueIterator.hasNext()) {
            this.priorityQueue.offer(peekFileValueIterator);
        } else {
            peekFileValueIterator.close();
        }
        return l;
    }

    private static class PeekFileValueIteratorComparator
    implements Comparator<PeekFileValueIterator> {
        private PeekFileValueIteratorComparator() {
        }

        @Override
        public int compare(PeekFileValueIterator peekFileValueIterator, PeekFileValueIterator peekFileValueIterator2) {
            if (peekFileValueIterator.peek() < peekFileValueIterator2.peek()) {
                return -1;
            }
            if (peekFileValueIterator.peek() == peekFileValueIterator2.peek()) {
                return 0;
            }
            return 1;
        }
    }

    private static class PeekFileValueIterator {
        private FileValueIterator underlyingIterator;
        private long peekValue;
        private boolean hasPeekedValue = false;

        PeekFileValueIterator(FileValueIterator fileValueIterator) {
            this.underlyingIterator = fileValueIterator;
        }

        boolean hasNext() {
            return this.hasPeekedValue || this.underlyingIterator.hasNext();
        }

        long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.hasPeekedValue) {
                this.hasPeekedValue = false;
                return this.peekValue;
            }
            return this.underlyingIterator.next();
        }

        long peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.hasPeekedValue) {
                this.peekValue = this.underlyingIterator.next();
                this.hasPeekedValue = true;
            }
            return this.peekValue;
        }

        void close() {
            this.underlyingIterator.close();
            this.hasPeekedValue = false;
            this.underlyingIterator = null;
        }
    }

    private static class FileValueIterator {
        private final File file;
        private final DataInputStream is;
        private long currentRecord = 0L;
        private boolean isCurrentRecord = true;

        FileValueIterator(File file) {
            this.file = file;
            try {
                this.is = new DataInputStream(new BufferedInputStream(new FileInputStream(file), Defaults.BUFFER_SIZE));
                this.next();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeIOException(file.getAbsolutePath(), fileNotFoundException);
            }
        }

        boolean hasNext() {
            return this.isCurrentRecord;
        }

        long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l = this.currentRecord;
            try {
                this.currentRecord = this.is.readLong();
            }
            catch (EOFException eOFException) {
                this.isCurrentRecord = false;
                this.currentRecord = 0L;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return l;
        }

        void close() {
            CloserUtil.close(this.is);
            IOUtil.deleteFiles(this.file);
        }
    }
}

