/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public final class VectorSet
extends Vector {
    private final HashSet set = new HashSet();

    public VectorSet() {
    }

    public VectorSet(int initialCapacity) {
        super(initialCapacity);
    }

    public VectorSet(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public VectorSet(Collection c) {
        if (c != null) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
    }

    public synchronized boolean add(Object o) {
        if (!this.set.contains(o)) {
            this.doAdd(this.size(), o);
            return true;
        }
        return false;
    }

    public void add(int index, Object o) {
        this.doAdd(index, o);
    }

    private synchronized void doAdd(int index, Object o) {
        if (this.set.add(o)) {
            int count2 = this.size();
            this.ensureCapacity(count2 + 1);
            if (index != count2) {
                System.arraycopy(this.elementData, index, this.elementData, index + 1, count2 - index);
            }
            this.elementData[index] = o;
            ++this.elementCount;
        }
    }

    public synchronized void addElement(Object o) {
        this.doAdd(this.size(), o);
    }

    public synchronized boolean addAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add(i.next());
        }
        return changed;
    }

    public synchronized boolean addAll(int index, Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (this.set.contains(o)) continue;
            this.doAdd(index++, o);
            changed = true;
        }
        return changed;
    }

    public synchronized void clear() {
        super.clear();
        this.set.clear();
    }

    public Object clone() {
        VectorSet vs = (VectorSet)super.clone();
        vs.set.addAll(this.set);
        return vs;
    }

    public synchronized boolean contains(Object o) {
        return this.set.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.set.containsAll(c);
    }

    public void insertElementAt(Object o, int index) {
        this.doAdd(index, o);
    }

    public synchronized Object remove(int index) {
        Object o = this.get(index);
        this.remove(o);
        return o;
    }

    public boolean remove(Object o) {
        return this.doRemove(o);
    }

    private synchronized boolean doRemove(Object o) {
        if (this.set.remove(o)) {
            int index = this.indexOf(o);
            if (index < this.elementData.length - 1) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementData.length - index - 1);
            }
            --this.elementCount;
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.remove(i.next());
        }
        return changed;
    }

    public synchronized void removeAllElements() {
        this.set.clear();
        super.removeAllElements();
    }

    public boolean removeElement(Object o) {
        return this.doRemove(o);
    }

    public synchronized void removeElementAt(int index) {
        this.remove(this.get(index));
    }

    public synchronized void removeRange(int fromIndex, int toIndex) {
        while (toIndex > fromIndex) {
            this.remove(--toIndex);
        }
    }

    public synchronized boolean retainAll(Collection c) {
        LinkedList l = new LinkedList();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (c.contains(o)) continue;
            l.addLast(o);
        }
        if (!l.isEmpty()) {
            this.removeAll((Collection)l);
            return true;
        }
        return false;
    }

    public synchronized Object set(int index, Object o) {
        Object orig = this.get(index);
        if (this.set.add(o)) {
            this.elementData[index] = o;
            this.set.remove(orig);
        } else {
            int oldIndexOfO = this.indexOf(o);
            this.remove(o);
            this.remove(orig);
            this.add(oldIndexOfO > index ? index : index - 1, o);
        }
        return orig;
    }

    public void setElementAt(Object o, int index) {
        this.set(index, o);
    }
}

