/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.rnai.poolq.api.PoolQArgs;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.gui.PoolQResultsDialog;
import org.broadinstitute.rnai.poolq.gui.PoolQRunCancelledListener;
import org.broadinstitute.rnai.poolq.gui.ProgressIndicatorDialog;
import org.broadinstitute.rnai.poolq.gui.SwingUtils;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserListener;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelFactory;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelType;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileSelectionPanel;
import org.broadinstitute.rnai.poolq.impl.PoolQImpl;
import org.broadinstitute.rnai.poolq.impl.PoolQInterruptedException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class PoolQGui {
    private static final int MIN_START_INDEX = 0;
    private static final int MAX_START_INDEX = 30;
    private JFrame mainFrame;
    private final FileChooserPanelFactory fileChooserPanelFactory = new FileChooserPanelFactory();
    private final FileSelectionPanel readsFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.READS);
    private final FileSelectionPanel referenceFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.REFERENCE);
    private final FileSelectionPanel conditionsFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.CONDITIONS);
    private final FileSelectionPanel scoresFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.SCORES);
    private final FileSelectionPanel qualityReportFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.QUALITY);
    private final FileSelectionPanel logNormalizedScoresFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.LOGNORM);
    private final FileSelectionPanel barcodeScoresFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.BARCODE);
    private final FileSelectionPanel unexpectedSequenceFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.UNEXPECTED);
    private final FileSelectionPanel platformReferenceFileChooserPanel = this.fileChooserPanelFactory.buildFileChooserPanel(FileChooserPanelType.PLATFORM_REFERENCE);
    private int barcodeStartIndex = 0;
    private int constructBarcodeStartIndex = 16;
    private int constructBarcodeMatchLength = 21;
    private int unexpectedSequenceThreshold = 5000;
    private boolean useExactMatch;
    private boolean includeNonPfReads = false;
    private boolean includeAmbiguous = false;
    private boolean skipShortReads = false;
    private ReadsFileType readsFileType = null;
    private JButton performAnalysisButton;

    public static void main(String[] stringArray) {
        System.err.println("PoolQ version 2.0.5");
        new PoolQGui().createAndDisplayGui();
    }

    private PoolQGui() {
        this.setFileChooserListeners();
    }

    private void setFileChooserListeners() {
        FileChooserListener fileChooserListener = new FileChooserListener(){

            @Override
            public void newFileSelected(FileSelectionPanel fileSelectionPanel) {
                PoolQGui.this.performAnalysisButton.setEnabled(PoolQGui.this.areAllFiveRequiredFilesSelected());
                File file = fileSelectionPanel.getDefaultDirectory();
                PoolQGui.this.setFileChoosersDefaultDirectory(file);
            }
        };
        this.readsFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.referenceFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.conditionsFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.scoresFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.qualityReportFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.logNormalizedScoresFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.barcodeScoresFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.unexpectedSequenceFileChooserPanel.setFileChooserListener(fileChooserListener);
        this.platformReferenceFileChooserPanel.setFileChooserListener(fileChooserListener);
    }

    private boolean areAllFiveRequiredFilesSelected() {
        return this.readsFileChooserPanel.isFileSelected() && this.referenceFileChooserPanel.isFileSelected() && this.conditionsFileChooserPanel.isFileSelected() && this.scoresFileChooserPanel.isFileSelected() && this.qualityReportFileChooserPanel.isFileSelected();
    }

    private void setFileChoosersDefaultDirectory(File file) {
        this.readsFileChooserPanel.setDefaultDirectory(file);
        this.referenceFileChooserPanel.setDefaultDirectory(file);
        this.conditionsFileChooserPanel.setDefaultDirectory(file);
        this.scoresFileChooserPanel.setDefaultDirectory(file);
        this.qualityReportFileChooserPanel.setDefaultDirectory(file);
        this.logNormalizedScoresFileChooserPanel.setDefaultDirectory(file);
        this.barcodeScoresFileChooserPanel.setDefaultDirectory(file);
        this.unexpectedSequenceFileChooserPanel.setDefaultDirectory(file);
        this.platformReferenceFileChooserPanel.setDefaultDirectory(file);
    }

    private void createAndDisplayGui() {
        this.mainFrame = new JFrame("PoolQ GUI 2.0.5");
        this.mainFrame.getContentPane().add(this.createMainPanel());
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    private Component createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        jPanel.add(this.createInputsComponent());
        jPanel.add(this.createOutputsComponent());
        jPanel.add(this.createButtonsComponent());
        return jPanel;
    }

    private Component createInputsComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(SwingUtils.createDefaultTitledBorder("Inputs"));
        jPanel.add(this.readsFileChooserPanel);
        jPanel.add(this.referenceFileChooserPanel);
        jPanel.add(this.conditionsFileChooserPanel);
        jPanel.add(this.platformReferenceFileChooserPanel);
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.createUseExactMatchButtonPanel());
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.createBarcodeStartIndexPanel());
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.createConstructBarcodeStartIndexPanel());
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.createMinTruncationLengthPanel());
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.createReadsFileTypeButtonPanel());
        jPanel.add(this.createIncludeNonPfReadsButtonPanel());
        jPanel.add(this.createIncludeAmbiguousButtonPanel());
        jPanel.add(this.createSkipShortReadsButtonPanel());
        return jPanel;
    }

    private JPanel createBarcodeStartIndexPanel() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                PoolQGui.this.barcodeStartIndex = (Integer)jSpinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.barcodeStartIndex, changeListener, "Sample barcode start index:");
    }

    private JPanel createConstructBarcodeStartIndexPanel() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                PoolQGui.this.constructBarcodeStartIndex = (Integer)jSpinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.constructBarcodeStartIndex, changeListener, "Construct barcode start index:");
    }

    private JPanel createMinTruncationLengthPanel() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                PoolQGui.this.constructBarcodeMatchLength = (Integer)jSpinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.constructBarcodeMatchLength, changeListener, "Minimum construct barcode length");
    }

    private JPanel createUnexpectedSequenceThresholdPanel() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                PoolQGui.this.unexpectedSequenceThreshold = (Integer)jSpinner.getValue();
            }
        };
        return this.createSpinnerInputPanel(this.unexpectedSequenceThreshold, changeListener, "Unexpected sequence threshold (per 10 million)", 0, 10000000);
    }

    private JPanel createSpinnerInputPanel(int n, ChangeListener changeListener, String string2) {
        return this.createSpinnerInputPanel(n, changeListener, string2, 0, 30);
    }

    private JPanel createSpinnerInputPanel(int n, ChangeListener changeListener, String string2, int n2, int n3) {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, 1);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.addChangeListener(changeListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(string2), "West");
        jPanel.add((Component)jSpinner, "East");
        jPanel.setMaximumSize(new Dimension(jPanel.getMaximumSize().width, jPanel.getPreferredSize().height));
        return jPanel;
    }

    private JPanel createIncludeNonPfReadsButtonPanel() {
        return this.createYesNoButtonPanel("Include non-PF reads?", new Setter<Boolean>(){

            @Override
            public void set(Boolean bl) {
                PoolQGui.this.includeNonPfReads = bl;
            }
        });
    }

    private JPanel createIncludeAmbiguousButtonPanel() {
        return this.createYesNoButtonPanel("Include ambiguous matches?", new Setter<Boolean>(){

            @Override
            public void set(Boolean bl) {
                PoolQGui.this.includeAmbiguous = bl;
            }
        });
    }

    private JPanel createSkipShortReadsButtonPanel() {
        return this.createYesNoButtonPanel("Skip short reads?", new Setter<Boolean>(){

            @Override
            public void set(Boolean bl) {
                PoolQGui.this.skipShortReads = bl;
            }
        });
    }

    private JPanel createUseExactMatchButtonPanel() {
        return this.createYesNoButtonPanel("Require exact match?", new Setter<Boolean>(){

            @Override
            public void set(Boolean bl) {
                PoolQGui.this.useExactMatch = bl;
            }
        });
    }

    private JPanel createReadsFileTypeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final ReadsFileType readsFileType : ReadsFileType.values()) {
            JRadioButton jRadioButton = new JRadioButton(readsFileType.toString());
            jRadioButton.setEnabled(true);
            jRadioButton.setSelected(readsFileType == ReadsFileType.AUTO);
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PoolQGui.this.readsFileType = readsFileType;
                }
            });
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }
        return this.createButtonOuterPanel("Reads file type:", jPanel);
    }

    private JPanel createYesNoButtonPanel(String string2, final Setter<Boolean> setter2) {
        JRadioButton jRadioButton = new JRadioButton("No");
        jRadioButton.setEnabled(true);
        jRadioButton.setSelected(true);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                setter2.set(false);
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton("Yes");
        jRadioButton2.setEnabled(true);
        jRadioButton2.setSelected(false);
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                setter2.set(true);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jRadioButton2);
        jPanel.add(jRadioButton);
        return this.createButtonOuterPanel(string2, jPanel);
    }

    private JPanel createButtonOuterPanel(String string2, JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel(string2), "West");
        jPanel2.add((Component)jPanel, "East");
        jPanel2.setMaximumSize(new Dimension(jPanel2.getMaximumSize().width, jPanel2.getPreferredSize().height));
        return jPanel2;
    }

    private Component createOutputsComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(SwingUtils.createDefaultTitledBorder("Outputs"));
        jPanel.add(this.scoresFileChooserPanel);
        jPanel.add(this.qualityReportFileChooserPanel);
        jPanel.add(this.logNormalizedScoresFileChooserPanel);
        jPanel.add(this.barcodeScoresFileChooserPanel);
        jPanel.add(this.unexpectedSequenceFileChooserPanel);
        jPanel.add(this.createUnexpectedSequenceThresholdPanel());
        jPanel.add(Box.createVerticalStrut(3));
        return jPanel;
    }

    private Component createButtonsComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(SwingUtils.createDefaultEmptyBorder());
        jPanel.add(Box.createHorizontalGlue());
        this.performAnalysisButton = new JButton("Perform Analysis");
        this.performAnalysisButton.setEnabled(false);
        this.performAnalysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PoolQGui.this.userConfirmsPerformAnalysis()) {
                    PoolQRunnable poolQRunnable = new PoolQRunnable();
                    poolQRunnable.start();
                }
            }
        });
        jPanel.add(this.performAnalysisButton);
        return jPanel;
    }

    private boolean userConfirmsPerformAnalysis() {
        boolean bl;
        File file = new File(this.scoresFileChooserPanel.getSelectedFileName());
        boolean bl2 = file.exists();
        File file2 = new File(this.qualityReportFileChooserPanel.getSelectedFileName());
        boolean bl3 = file2.exists();
        String string2 = this.logNormalizedScoresFileChooserPanel.getSelectedFileName();
        File file3 = string2 == null ? null : new File(string2);
        boolean bl4 = file3 != null && file3.exists();
        String string3 = this.unexpectedSequenceFileChooserPanel.getSelectedFileName();
        File file4 = string3 == null ? null : new File(string3);
        boolean bl5 = bl = file4 != null && file4.exists();
        if (!(bl2 || bl3 || bl4 || bl)) {
            return true;
        }
        String string4 = this.buildConfirmOverwriteMessage(bl2, bl3, bl4, bl);
        int n = JOptionPane.showConfirmDialog(this.mainFrame, string4, "Confirm Overwrite Existing Files", 2, 2);
        return n != 2;
    }

    String buildConfirmOverwriteMessage(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("scores file");
        }
        if (bl2) {
            arrayList.add("quality file");
        }
        if (bl3) {
            arrayList.add("log normalized scores file");
        }
        if (bl4) {
            arrayList.add("unexpected sequence report file");
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("The ").append(TextUtils.buildEnglishLanguageList(arrayList)).append(" that you specified already exist");
            if (arrayList.size() == 1) {
                stringBuilder.append('s');
            }
            stringBuilder.append(". Do you want to overwrite?");
            return stringBuilder.toString();
        }
        return null;
    }

    private static interface Setter<T> {
        public void set(T var1);
    }

    private class PoolQRunnable
    extends Thread {
        private PoolQRunCancelledListener poolQRunCancelledListener = new PoolQRunCancelledListener(){

            @Override
            public void poolQRunCancelled() {
                PoolQRunnable.this.interrupt();
            }
        };
        private ProgressIndicatorDialog progressIndicatorDialog = new ProgressIndicatorDialog(PoolQGui.access$1400(PoolQGui.this), this.poolQRunCancelledListener);

        private PoolQRunnable() {
        }

        @Override
        public void run() {
            this.showProgressIndicator();
            PoolQArgs poolQArgs = new PoolQArgs(){

                @Override
                public List<String> getReadsFilenames() {
                    return Collections.singletonList(PoolQGui.this.readsFileChooserPanel.getSelectedFileName());
                }

                @Override
                public String getReferenceFilename() {
                    return PoolQGui.this.referenceFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getConditionsFilename() {
                    return PoolQGui.this.conditionsFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getScoresFilename() {
                    return PoolQGui.this.scoresFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getQualityFilename() {
                    return PoolQGui.this.qualityReportFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getLogNormalizedScoresFilename() {
                    return PoolQGui.this.logNormalizedScoresFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getBarcodeScoresFilename() {
                    return PoolQGui.this.barcodeScoresFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getPlatformReferenceFilename() {
                    return PoolQGui.this.platformReferenceFileChooserPanel.getSelectedFileName();
                }

                @Override
                public String getUnexpectedSequenceFilename() {
                    return PoolQGui.this.unexpectedSequenceFileChooserPanel.getSelectedFileName();
                }

                @Override
                public int getUnexpectedSequenceThreshold() {
                    return PoolQGui.this.unexpectedSequenceThreshold;
                }

                @Override
                public boolean requireExactMatch() {
                    return PoolQGui.this.useExactMatch;
                }

                @Override
                public boolean includeNonPfReads() {
                    return PoolQGui.this.includeNonPfReads;
                }

                @Override
                public int getSampleBarcodeStartIndex() {
                    return PoolQGui.this.barcodeStartIndex;
                }

                @Override
                public int getConstructBarcodeStartIndex() {
                    return PoolQGui.this.constructBarcodeStartIndex;
                }

                @Override
                public boolean includeAmbiguous() {
                    return PoolQGui.this.includeAmbiguous;
                }

                @Override
                public boolean skipShortReads() {
                    return PoolQGui.this.skipShortReads;
                }

                @Override
                public ReadsFileType getReadsFileType() {
                    return PoolQGui.this.readsFileType;
                }

                @Override
                public Integer getConstructBarcodeMatchLength() {
                    return PoolQGui.this.constructBarcodeMatchLength;
                }

                @Override
                public String getConstructBarcodeSearchPrefix() {
                    return null;
                }

                @Override
                public Integer getConstructBarcodeSearchStartIndex() {
                    return null;
                }

                @Override
                public Integer getConstructBarcodeSearchEndIndex() {
                    return null;
                }

                @Override
                public String getCorrelationFilename() {
                    return null;
                }
            };
            try {
                new PoolQImpl().runPoolQ(poolQArgs);
                this.hideProgressIndicator();
                this.showSuccessDialog();
            }
            catch (PoolQInterruptedException poolQInterruptedException) {
                this.hideProgressIndicator();
            }
            catch (PoolQException poolQException) {
                this.hideProgressIndicator();
                this.showErrorDialog(poolQException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.hideProgressIndicator();
                this.showUnexpectedErrorDialog(exception);
            }
        }

        private void showProgressIndicator() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PoolQRunnable.this.progressIndicatorDialog.setVisible(true);
                }
            });
        }

        private void hideProgressIndicator() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PoolQRunnable.this.progressIndicatorDialog.dispose();
                }
            });
        }

        private void showSuccessDialog() {
            PoolQResultsDialog poolQResultsDialog = new PoolQResultsDialog(PoolQGui.this.mainFrame, PoolQGui.this.scoresFileChooserPanel.getSelectedFileName(), PoolQGui.this.qualityReportFileChooserPanel.getSelectedFileName());
            poolQResultsDialog.setVisible(true);
        }

        private void showErrorDialog(Exception exception) {
            this.showErrorDialog("PoolQ encountered the following error when performing the analysis:", exception);
        }

        private void showUnexpectedErrorDialog(Exception exception) {
            this.showErrorDialog("The following unexpected error occurred:", exception);
        }

        private void showErrorDialog(String string2, Exception exception) {
            String string3 = string2 + "\n\n" + exception.getMessage();
            JOptionPane.showMessageDialog(PoolQGui.this.mainFrame, string3, "PoolQ Error", 0);
        }
    }
}

