/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.gui.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserListener;
import org.broadinstitute.rnai.poolq.gui.filechooser.FileChooserPanelType;

public class FileSelectionPanel
extends JPanel {
    private static final int TEXT_FIELD_PREFERRED_SIZE = 400;
    private final FileChooserPanelType fileChooserPanelType;
    private JTextField textField;
    private File defaultDirectory;
    private FileChooserListener fileChooserListener;

    FileSelectionPanel(JLabel jLabel, FileChooserPanelType fileChooserPanelType) {
        this.fileChooserPanelType = fileChooserPanelType;
        this.setLayout(new BorderLayout());
        this.add((Component)jLabel, "West");
        this.add((Component)this.buildTextPanel(), "Center");
        this.add((Component)this.buildBrowseButton(), "East");
        this.preventVerticalExpansion();
        this.defaultDirectory = new File(System.getProperty("user.dir"));
    }

    public boolean isFileSelected() {
        return this.getSelectedFileName() != null && !this.getSelectedFileName().equals("");
    }

    public String getSelectedFileName() {
        String string2 = this.textField.getText();
        if (string2.trim().equals("")) {
            return null;
        }
        return string2;
    }

    public File getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(File file) {
        this.defaultDirectory = file;
        if (!this.isFileSelected()) {
            this.textField.setText(new File(file, this.fileChooserPanelType.getDefaultFileName()).getAbsolutePath());
            if (this.fileChooserListener != null) {
                this.fileChooserListener.newFileSelected(this);
            }
        }
    }

    public void setFileChooserListener(FileChooserListener fileChooserListener) {
        if (this.fileChooserListener != null) {
            throw new UnsupportedOperationException();
        }
        this.fileChooserListener = fileChooserListener;
    }

    private JPanel buildTextPanel() {
        this.textField = new JTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel.setPreferredSize(new Dimension(400, this.textField.getPreferredSize().height));
        jPanel.add((Component)this.textField, "Center");
        return jPanel;
    }

    private JButton buildBrowseButton() {
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(FileSelectionPanel.this.defaultDirectory);
                jFileChooser.setDialogTitle(FileSelectionPanel.this.fileChooserPanelType.getDialogTitle());
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setSelectedFile(new File(FileSelectionPanel.this.fileChooserPanelType.getDefaultFileName()));
                int n = jFileChooser.showOpenDialog(FileSelectionPanel.this);
                if (n == 0) {
                    jFileChooser.getSelectedFile();
                    File file = jFileChooser.getSelectedFile();
                    FileSelectionPanel.this.defaultDirectory = file.getParentFile();
                    FileSelectionPanel.this.textField.setText(file.getAbsolutePath());
                    if (FileSelectionPanel.this.fileChooserListener != null) {
                        FileSelectionPanel.this.fileChooserListener.newFileSelected(FileSelectionPanel.this);
                    }
                }
            }
        });
        return jButton;
    }

    private void preventVerticalExpansion() {
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, this.getPreferredSize().height));
    }
}

