/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TempDatabase
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TempDatabase.class);
    private static final String TEMP_DATABASE_PREFERRED_CONTAINING_DIRECTORY = "/local/scratch";
    private static final String TEMP_DATABASE_DIRECTORY_PREFIX = "poolQTempDatabase";
    private static final String TEMP_DATABASE_DIRECTORY_SUFFIX = ".db";
    private static final String STORE_NAME = "TempDatabase";
    private final File tempDatabaseDirectory;
    private final Environment environment;
    private final EntityStore entityStore;

    public TempDatabase() {
        try {
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(true);
            environmentConfig.setTransactional(false);
            environmentConfig.setSharedCache(true);
            environmentConfig.setCachePercent(50);
            this.tempDatabaseDirectory = this.createTempDatabaseDirectory();
            this.environment = new Environment(this.tempDatabaseDirectory, environmentConfig);
            StoreConfig storeConfig = new StoreConfig();
            storeConfig.setAllowCreate(true);
            storeConfig.setTransactional(false);
            storeConfig.setTemporary(true);
            this.entityStore = new EntityStore(this.environment, STORE_NAME, storeConfig);
        }
        catch (Exception exception) {
            logger.error("Unable to construct temp database", exception);
            throw new TempDatabaseException(exception);
        }
    }

    public void setCachePercent(int n) {
        this.environment.setMutableConfig(new EnvironmentMutableConfig().setCachePercent(n));
    }

    private File createTempDatabaseDirectory() throws IOException {
        File file = this.reserveTempDatabaseDirectoryLocation();
        file.delete();
        file.mkdir();
        return file;
    }

    private File reserveTempDatabaseDirectoryLocation() throws IOException {
        try {
            File file = new File(TEMP_DATABASE_PREFERRED_CONTAINING_DIRECTORY);
            return File.createTempFile(TEMP_DATABASE_DIRECTORY_PREFIX, TEMP_DATABASE_DIRECTORY_SUFFIX, file);
        }
        catch (IOException iOException) {
            return File.createTempFile(TEMP_DATABASE_DIRECTORY_PREFIX, TEMP_DATABASE_DIRECTORY_SUFFIX);
        }
    }

    @Override
    public void close() {
        try {
            this.entityStore.close();
            this.environment.close();
        }
        catch (DatabaseException databaseException) {
            logger.error("Error preparing temp database at {} for removal", (Object)this.tempDatabaseDirectory.getAbsolutePath(), (Object)databaseException);
            throw new TempDatabaseException(databaseException);
        }
        this.tempDatabaseDirectory.deleteOnExit();
        File[] fileArray = this.tempDatabaseDirectory.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                file.deleteOnExit();
            }
        }
        logger.debug("Temporary database files deleted.");
    }

    protected <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> clazz, Class<E> clazz2) throws TempDatabaseException {
        try {
            return this.entityStore.getPrimaryIndex(clazz, clazz2);
        }
        catch (DatabaseException databaseException) {
            logger.error("Error getting primary index at {}", (Object)this.tempDatabaseDirectory.getAbsolutePath(), (Object)databaseException);
            throw new TempDatabaseException(databaseException);
        }
    }
}

