/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.rnai.poolq.impl.fileparser.ColumnFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ConditionsFileParserException;

public class ConditionsFileParser {
    private static final Pattern NON_EMPTY_DNA_RE = Pattern.compile("^[ACGT]+$");
    private Integer barcodeLength = null;

    public Map<String, String> parseBarcodeToConditionMapFromInputStream(InputStream inputStream) throws IOException, ConditionsFileParserException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = 0;
        int n2 = -1;
        for (String[] stringArray : new ColumnFileParser(inputStream)) {
            if (n < 1) {
                n2 = stringArray.length;
            }
            ++n;
            if (stringArray.length == 0) continue;
            if (stringArray.length != n2) {
                throw new ConditionsFileParserException.IncorrectNumberOfColumnsException("Line does not contain the correct number of columns", n, stringArray);
            }
            if (stringArray.length < 2) {
                throw new ConditionsFileParserException.IncorrectNumberOfColumnsException("Line does not contain at least two columns", n, stringArray);
            }
            String string2 = stringArray[0].trim();
            this.checkBarcodeIsValid(string2, linkedHashMap, n, stringArray);
            String string3 = stringArray[1].trim();
            linkedHashMap.put(string2, string3);
        }
        if (linkedHashMap.isEmpty()) {
            throw new ConditionsFileParserException.EmptyConditionsFileException("Conditions file is empty", n);
        }
        return linkedHashMap;
    }

    private void checkBarcodeIsValid(String string2, Map<String, String> map2, int n, String[] stringArray) {
        if (!this.barcodeMatchesBarcodePattern(string2)) {
            throw new ConditionsFileParserException.BadBarcodeException("Barcode '" + string2 + "' is not a valid barcode", n, stringArray);
        }
        if (map2.containsKey(string2)) {
            throw new ConditionsFileParserException.DuplicateBarcodeException("Duplicate barcode '" + string2 + "'", n, stringArray);
        }
        if (this.barcodeLength == null) {
            this.barcodeLength = string2.length();
        } else if (!this.barcodeLength.equals(string2.length())) {
            throw new ConditionsFileParserException.VariableBarcodeLengthException("Barcode '" + string2 + "' does not have the same length as the other barcodes.", n, stringArray);
        }
    }

    private boolean barcodeMatchesBarcodePattern(String string2) {
        Matcher matcher = NON_EMPTY_DNA_RE.matcher(string2);
        return matcher.matches();
    }
}

