/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.reads;

import org.broadinstitute.rnai.poolq.api.ReadTooShortException;
import org.broadinstitute.rnai.poolq.impl.EventTracker;
import org.broadinstitute.rnai.poolq.impl.reads.ReadInput;
import org.broadinstitute.rnai.poolq.impl.reads.ReadProcessor;
import org.broadinstitute.rnai.poolq.impl.reads.VariableReadProcessor$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001f\t)b+\u0019:jC\ndWMU3bIB\u0013xnY3tg>\u0014(BA\u0002\u0005\u0003\u0015\u0011X-\u00193t\u0015\t)a!\u0001\u0003j[Bd'BA\u0004\t\u0003\u0015\u0001xn\u001c7r\u0015\tI!\"\u0001\u0003s]\u0006L'BA\u0006\r\u00039\u0011'o\\1eS:\u001cH/\u001b;vi\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!!\u0004*fC\u0012\u0004&o\\2fgN|'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u00031\u0019X-\u0019:dQB\u0013XMZ5y!\tyRE\u0004\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013%\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001d\u0012aa\u0015;sS:<'B\u0001\u0013\"\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001I2p]N$(/^2u\u0005\u0006\u00148m\u001c3f'\u0016\f'o\u00195Ti\u0006\u0014H/\u00138eKb\u0004\"\u0001I\u0016\n\u00051\n#aA%oi\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\u0010d_:\u001cHO];di\n\u000b'oY8eKN+\u0017M]2i\u000b:$\u0017J\u001c3fqB\u0019\u0001\u0005\r\u0016\n\u0005E\n#AB(qi&|g\u000e\u0003\u00054\u0001\t\u0005\t\u0015!\u0003+\u0003]\u0019\u0018-\u001c9mK\n\u000b'oY8eKN#\u0018M\u001d;J]\u0012,\u0007\u0010\u0003\u00056\u0001\t\u0005\t\u0015!\u0003+\u0003M\u0019\u0018-\u001c9mK\n\u000b'oY8eK2+gn\u001a;i\u0011!9\u0004A!A!\u0002\u0013Q\u0013AF2p]N$(/^2u\u0005\u0006\u00148m\u001c3f\u0019\u0016tw\r\u001e5\t\u0011e\u0002!\u0011!Q\u0001\ni\nA\"\u001a<f]R$&/Y2lKJ\u0004\"a\u000f\u001f\u000e\u0003\u0011I!!\u0010\u0003\u0003\u0019\u00153XM\u001c;Ue\u0006\u001c7.\u001a:\t\u000b}\u0002A\u0011\u0001!\u0002\rqJg.\u001b;?)!\t%i\u0011#F\r\u001eC\u0005CA\r\u0001\u0011\u0015ib\b1\u0001\u001f\u0011\u0015Ic\b1\u0001+\u0011\u0015qc\b1\u00010\u0011\u0015\u0019d\b1\u0001+\u0011\u0015)d\b1\u0001+\u0011\u00159d\b1\u0001+\u0011\u0015Id\b1\u0001;\u0011!Q\u0005\u0001#b\u0001\n\u0003Y\u0015AE:fCJ\u001c\u0007\u000e\u0015:fM&DH*\u001a8hi\",\u0012A\u000b\u0005\t\u001b\u0002A\t\u0011)Q\u0005U\u0005\u00192/Z1sG\"\u0004&/\u001a4jq2+gn\u001a;iA!Aq\n\u0001EC\u0002\u0013\u00051*A\u000enS:$U-\\;mi&\u0004H.\u001a=j]\u001e\u0014V-\u00193MK:<G\u000f\u001b\u0005\t#\u0002A\t\u0011)Q\u0005U\u0005aR.\u001b8EK6,H\u000e^5qY\u0016D\u0018N\\4SK\u0006$G*\u001a8hi\"\u0004\u0003\u0002C*\u0001\u0011\u000b\u0007I\u0011A&\u0002+M\fW\u000e\u001d7f\u0005\u0006\u00148m\u001c3f\u000b:$\u0017J\u001c3fq\"AQ\u000b\u0001E\u0001B\u0003&!&\u0001\ftC6\u0004H.\u001a\"be\u000e|G-Z#oI&sG-\u001a=!\u0011\u00159\u0006\u0001\"\u0011Y\u0003a!(/\u001e8dCR,7i\u001c8tiJ,8\r\u001e\"be\u000e|G-\u001a\u000b\u0003=eCQA\u0017,A\u0002y\t\u0001cY8ogR\u0014Xo\u0019;CCJ\u001cw\u000eZ3\t\u000bq\u0003A\u0011I/\u0002'\u001d,GoQ8ogR\u0014Xo\u0019;CCJ\u001cw\u000eZ3\u0015\u0005yq\u0006\"B0\\\u0001\u0004\u0001\u0017\u0001\u0002:fC\u0012\u0004\"!G1\n\u0005\t\u0014!!\u0003*fC\u0012Le\u000e];u\u0011\u0015!\u0007\u0001\"\u0011f\u0003A9W\r^*b[BdWMQ1sG>$W\r\u0006\u0002\u001fM\")ql\u0019a\u0001A\u001e)\u0001N\u0001E\u0001S\u0006)b+\u0019:jC\ndWMU3bIB\u0013xnY3tg>\u0014\bCA\rk\r\u0015\t!\u0001#\u0001l'\tQG\u000e\u0005\u0002![&\u0011a.\t\u0002\u0007\u0003:L(+\u001a4\t\u000b}RG\u0011\u00019\u0015\u0003%DQA\u001d6\u0005\u0002M\fQ!\u00199qYf$\u0002\"\u0011;vmj\\H0 \u0005\u0006;E\u0004\rA\b\u0005\u0006SE\u0004\rA\u000b\u0005\u0006]E\u0004\ra\u001e\t\u0003#aL!!\u001f\n\u0003\u000f%sG/Z4fe\")1'\u001da\u0001U!)Q'\u001da\u0001U!)q'\u001da\u0001U!)\u0011(\u001da\u0001u\u0001")
public class VariableReadProcessor
implements ReadProcessor {
    private final String searchPrefix;
    private final int constructBarcodeSearchStartIndex;
    private final Option<Object> constructBarcodeSearchEndIndex;
    private final int sampleBarcodeStartIndex;
    private final int sampleBarcodeLength;
    private final int constructBarcodeLength;
    private final EventTracker eventTracker;
    private int searchPrefixLength;
    private int minDemultiplexingReadLength;
    private int sampleBarcodeEndIndex;
    private volatile byte bitmap$0;

    public static VariableReadProcessor apply(String string2, int n, Integer n2, int n3, int n4, int n5, EventTracker eventTracker) {
        return VariableReadProcessor$.MODULE$.apply(string2, n, n2, n3, n4, n5, eventTracker);
    }

    private int searchPrefixLength$lzycompute() {
        VariableReadProcessor variableReadProcessor = this;
        synchronized (variableReadProcessor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.searchPrefixLength = this.searchPrefix.length();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.searchPrefixLength;
        }
    }

    private int minDemultiplexingReadLength$lzycompute() {
        VariableReadProcessor variableReadProcessor = this;
        synchronized (variableReadProcessor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.minDemultiplexingReadLength = this.sampleBarcodeLength + this.sampleBarcodeStartIndex;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.minDemultiplexingReadLength;
        }
    }

    private int sampleBarcodeEndIndex$lzycompute() {
        VariableReadProcessor variableReadProcessor = this;
        synchronized (variableReadProcessor) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sampleBarcodeEndIndex = this.sampleBarcodeStartIndex + this.sampleBarcodeLength;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.sampleBarcodeEndIndex;
        }
    }

    public int searchPrefixLength() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.searchPrefixLength$lzycompute() : this.searchPrefixLength;
    }

    public int minDemultiplexingReadLength() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.minDemultiplexingReadLength$lzycompute() : this.minDemultiplexingReadLength;
    }

    public int sampleBarcodeEndIndex() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.sampleBarcodeEndIndex$lzycompute() : this.sampleBarcodeEndIndex;
    }

    @Override
    public String truncateConstructBarcode(String constructBarcode) {
        return constructBarcode.length() > this.constructBarcodeLength ? constructBarcode.substring(0, this.constructBarcodeLength) : constructBarcode;
    }

    @Override
    public String getConstructBarcode(ReadInput read) {
        String string2;
        String constructRead = read.getConstructBarcodeRead();
        int searchPrefixIndex = constructRead.indexOf(this.searchPrefix, this.constructBarcodeSearchStartIndex);
        if (searchPrefixIndex < 0) {
            this.eventTracker.barcodeSearchPrefixNotFound();
            string2 = null;
        } else {
            int startIndex = searchPrefixIndex + this.searchPrefixLength();
            int endIndex = startIndex + this.constructBarcodeLength;
            if (constructRead.length() < endIndex || BoxesRunTime.unboxToBoolean(this.constructBarcodeSearchEndIndex.fold(new Serializable(this){

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }, new Serializable(this, searchPrefixIndex){
                private final int searchPrefixIndex$1;

                public final boolean apply(int x$1) {
                    return this.apply$mcZI$sp(x$1);
                }

                public boolean apply$mcZI$sp(int x$1) {
                    return x$1 < this.searchPrefixIndex$1;
                }
                {
                    this.searchPrefixIndex$1 = searchPrefixIndex$1;
                }
            }))) {
                this.eventTracker.barcodeSearchPrefixPastSearchRegion();
                string2 = null;
            } else {
                this.eventTracker.constructBarcodeIndex(startIndex);
                string2 = constructRead.substring(startIndex, endIndex);
            }
        }
        return string2;
    }

    @Override
    public String getSampleBarcode(ReadInput read) {
        String dmuxRead = read.getSampleBarcodeRead();
        if (dmuxRead.length() < this.sampleBarcodeEndIndex()) {
            throw new ReadTooShortException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read '", "' is too short to contain a sample barcode of length "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{dmuxRead}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.sampleBarcodeLength)}))).toString());
        }
        return dmuxRead.substring(this.sampleBarcodeStartIndex, this.sampleBarcodeEndIndex());
    }

    public VariableReadProcessor(String searchPrefix, int constructBarcodeSearchStartIndex, Option<Object> constructBarcodeSearchEndIndex, int sampleBarcodeStartIndex, int sampleBarcodeLength, int constructBarcodeLength, EventTracker eventTracker) {
        this.searchPrefix = searchPrefix;
        this.constructBarcodeSearchStartIndex = constructBarcodeSearchStartIndex;
        this.constructBarcodeSearchEndIndex = constructBarcodeSearchEndIndex;
        this.sampleBarcodeStartIndex = sampleBarcodeStartIndex;
        this.sampleBarcodeLength = sampleBarcodeLength;
        this.constructBarcodeLength = constructBarcodeLength;
        this.eventTracker = eventTracker;
    }
}

