/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import org.broad.tribble.TribbleException;

public enum VCFHeaderVersion {
    VCF3_2("VCRv3.2", "format"),
    VCF3_3("VCFv3.3", "fileformat"),
    VCF4_0("VCFv4.0", "fileformat"),
    VCF4_1("VCFv4.1", "fileformat");

    private final String versionString;
    private final String formatString;

    private VCFHeaderVersion(String string3, String string4) {
        this.versionString = string3;
        this.formatString = string4;
    }

    public static VCFHeaderVersion toHeaderVersion(String string2) {
        string2 = VCFHeaderVersion.clean(string2);
        for (VCFHeaderVersion vCFHeaderVersion : VCFHeaderVersion.values()) {
            if (!vCFHeaderVersion.versionString.equals(string2)) continue;
            return vCFHeaderVersion;
        }
        return null;
    }

    public static boolean isVersionString(String string2) {
        return VCFHeaderVersion.toHeaderVersion(string2) != null;
    }

    public static boolean isFormatString(String string2) {
        string2 = VCFHeaderVersion.clean(string2);
        for (VCFHeaderVersion vCFHeaderVersion : VCFHeaderVersion.values()) {
            if (!vCFHeaderVersion.formatString.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static VCFHeaderVersion getHeaderVersion(String string2) {
        String[] stringArray = string2.split("=");
        if (stringArray.length != 2 || !VCFHeaderVersion.isFormatString(stringArray[0].substring(2))) {
            throw new TribbleException.InvalidHeader(string2 + " is not a valid VCF version line");
        }
        if (!VCFHeaderVersion.isVersionString(stringArray[1])) {
            throw new TribbleException.InvalidHeader(stringArray[1] + " is not a supported version");
        }
        return VCFHeaderVersion.toHeaderVersion(stringArray[1]);
    }

    private static String clean(String string2) {
        return string2.trim();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

