/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineTranslator;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFIDHeaderLine;

public class VCFSimpleHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private Map<String, String> genericFields = new LinkedHashMap<String, String>();

    public VCFSimpleHeaderLine(String string2, String string3, String string4) {
        super(string2, "");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(1);
        linkedHashMap.put("Description", string4);
        this.initialize(string3, linkedHashMap);
    }

    public VCFSimpleHeaderLine(String string2, VCFHeaderVersion vCFHeaderVersion, String string3, List<String> list) {
        this(string3, VCFHeaderLineTranslator.parseLine(vCFHeaderVersion, string2, list));
    }

    public VCFSimpleHeaderLine(String string2, Map<String, String> map2) {
        super(string2, "");
        this.name = map2.get("ID");
        this.initialize(this.name, map2);
    }

    String getGenericFieldValue(String string2) {
        return this.genericFields.get(string2);
    }

    protected void initialize(String string2, Map<String, String> map2) {
        if (string2 == null || map2 == null || map2.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid VCFSimpleHeaderLine: key=%s name=%s", super.getKey(), string2));
        }
        if (string2.contains("<") || string2.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (string2.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        this.name = string2;
        this.genericFields.putAll(map2);
    }

    @Override
    protected String toStringEncoding() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("ID", this.name);
        linkedHashMap.putAll(this.genericFields);
        return this.getKey() + "=" + VCFHeaderLine.toStringEncoding(linkedHashMap);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof VCFSimpleHeaderLine)) {
            return false;
        }
        VCFSimpleHeaderLine vCFSimpleHeaderLine = (VCFSimpleHeaderLine)object;
        if (!this.name.equals(vCFSimpleHeaderLine.name) || this.genericFields.size() != vCFSimpleHeaderLine.genericFields.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.genericFields.entrySet()) {
            if (entry.getValue().equals(vCFSimpleHeaderLine.genericFields.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getID() {
        return this.name;
    }
}

