/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleBinding
extends TupleBinding<Double> {
    private static final int DOUBLE_SIZE = 8;

    @Override
    public Double entryToObject(TupleInput input2) {
        return input2.readDouble();
    }

    @Override
    public void objectToEntry(Double object, TupleOutput output) {
        output.writeDouble(object);
    }

    @Override
    protected TupleOutput getTupleOutput(Double object) {
        return DoubleBinding.sizedOutput();
    }

    public static double entryToDouble(DatabaseEntry entry) {
        return DoubleBinding.entryToInput(entry).readDouble();
    }

    public static void doubleToEntry(double val, DatabaseEntry entry) {
        DoubleBinding.outputToEntry(DoubleBinding.sizedOutput().writeDouble(val), entry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

