/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.SimpleFormat;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectionAccessor
implements Accessor {
    private static final FieldAccess[] EMPTY_KEYS = new FieldAccess[0];
    private Class type;
    private Accessor superAccessor;
    private Constructor constructor;
    private FieldAccess priKey;
    private FieldAccess[] secKeys;
    private FieldAccess[] nonKeys;

    private ReflectionAccessor(Class type, Accessor superAccessor) {
        this.type = type;
        this.superAccessor = superAccessor;
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw DbCompat.unexpectedState(type.getName());
        }
        if (!Modifier.isPublic(type.getModifiers()) || !Modifier.isPublic(this.constructor.getModifiers())) {
            this.setAccessible(this.constructor, type.getName() + "()");
        }
    }

    ReflectionAccessor(Catalog catalog, Class type, Accessor superAccessor, FieldInfo priKeyField, List<FieldInfo> secKeyFields, List<FieldInfo> nonKeyFields) {
        this(type, superAccessor);
        this.priKey = priKeyField != null ? this.getField(catalog, priKeyField, true) : null;
        this.secKeys = secKeyFields.size() > 0 ? this.getFields(catalog, secKeyFields, false) : EMPTY_KEYS;
        this.nonKeys = nonKeyFields.size() > 0 ? this.getFields(catalog, nonKeyFields, false) : EMPTY_KEYS;
    }

    ReflectionAccessor(Catalog catalog, Class type, List<FieldInfo> fieldInfos) {
        this(type, null);
        this.priKey = null;
        this.secKeys = EMPTY_KEYS;
        this.nonKeys = this.getFields(catalog, fieldInfos, true);
    }

    private FieldAccess[] getFields(Catalog catalog, List<FieldInfo> fieldInfos, boolean isRequiredKeyField) {
        int index = 0;
        FieldAccess[] fields = new FieldAccess[fieldInfos.size()];
        for (FieldInfo info : fieldInfos) {
            fields[index] = this.getField(catalog, info, isRequiredKeyField);
            ++index;
        }
        return fields;
    }

    private FieldAccess getField(Catalog catalog, FieldInfo fieldInfo, boolean isRequiredKeyField) {
        Class<?> fieldCls;
        Field field2;
        try {
            field2 = this.type.getDeclaredField(fieldInfo.getName());
        }
        catch (NoSuchFieldException e) {
            throw DbCompat.unexpectedException(e);
        }
        if (!Modifier.isPublic(this.type.getModifiers()) || !Modifier.isPublic(field2.getModifiers())) {
            this.setAccessible(field2, field2.getName());
        }
        if ((fieldCls = field2.getType()).isPrimitive()) {
            assert (SimpleCatalog.isSimpleType(fieldCls));
            return new PrimitiveAccess(field2, (SimpleFormat)catalog.getFormat(fieldCls.getName()));
        }
        if (isRequiredKeyField) {
            Format format2 = catalog.getFormat(fieldInfo.getClassName());
            assert (format2 != null);
            return new KeyObjectAccess(field2, format2);
        }
        if (fieldCls == String.class) {
            return new StringAccess(field2);
        }
        return new ObjectAccess(field2);
    }

    private void setAccessible(AccessibleObject object, String memberName) {
        try {
            object.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to access non-public member: " + this.type.getName() + '.' + memberName + ". Please configure the Java Security Manager setting: " + " ReflectPermission suppressAccessChecks", e);
        }
    }

    @Override
    public Object newInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
        catch (InstantiationException e) {
            throw DbCompat.unexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public Object newArray(int len) {
        return Array.newInstance(this.type, len);
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object o) {
        try {
            if (this.priKey != null) {
                return this.priKey.isNullOrZero(o);
            }
            if (this.superAccessor != null) {
                return this.superAccessor.isPriKeyFieldNullOrZero(o);
            }
            throw DbCompat.unexpectedState("No primary key field");
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void writePriKeyField(Object o, EntityOutput output) throws RefreshException {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.write(o, output);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.writePriKeyField(o, output);
                    break block4;
                }
                throw DbCompat.unexpectedState("No primary key field");
            }
            catch (IllegalAccessException e) {
                throw DbCompat.unexpectedException(e);
            }
        }
    }

    @Override
    public void readPriKeyField(Object o, EntityInput input2) throws RefreshException {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.read(o, input2);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.readPriKeyField(o, input2);
                    break block4;
                }
                throw DbCompat.unexpectedState("No primary key field");
            }
            catch (IllegalAccessException e) {
                throw DbCompat.unexpectedException(e);
            }
        }
    }

    @Override
    public void writeSecKeyFields(Object o, EntityOutput output) throws RefreshException {
        try {
            if (this.priKey != null && !this.priKey.isPrimitive && !this.priKey.isString) {
                output.registerPriKeyObject(this.priKey.field.get(o));
            }
            if (this.superAccessor != null) {
                this.superAccessor.writeSecKeyFields(o, output);
            }
            for (int i = 0; i < this.secKeys.length; ++i) {
                this.secKeys[i].write(o, output);
            }
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void readSecKeyFields(Object o, EntityInput input2, int startField, int endField, int superLevel) throws RefreshException {
        try {
            if (this.priKey != null && !this.priKey.isPrimitive && !this.priKey.isString) {
                input2.registerPriKeyObject(this.priKey.field.get(o));
            } else if (this.priKey != null && this.priKey.isString) {
                input2.registerPriStringKeyObject(this.priKey.field.get(o));
            }
            if (superLevel != 0 && this.superAccessor != null) {
                this.superAccessor.readSecKeyFields(o, input2, startField, endField, superLevel - 1);
            } else if (superLevel > 0) {
                throw DbCompat.unexpectedState("Superclass does not exist");
            }
            if (superLevel <= 0) {
                for (int i = startField; i <= endField && i < this.secKeys.length; ++i) {
                    this.secKeys[i].read(o, input2);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void writeNonKeyFields(Object o, EntityOutput output) throws RefreshException {
        try {
            if (this.superAccessor != null) {
                this.superAccessor.writeNonKeyFields(o, output);
            }
            for (int i = 0; i < this.nonKeys.length; ++i) {
                this.nonKeys[i].write(o, output);
            }
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void readNonKeyFields(Object o, EntityInput input2, int startField, int endField, int superLevel) throws RefreshException {
        try {
            if (superLevel != 0 && this.superAccessor != null) {
                this.superAccessor.readNonKeyFields(o, input2, startField, endField, superLevel - 1);
            } else if (superLevel > 0) {
                throw DbCompat.unexpectedState("Superclass does not exist");
            }
            if (superLevel <= 0) {
                for (int i = startField; i <= endField && i < this.nonKeys.length; ++i) {
                    this.nonKeys[i].read(o, input2);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void writeCompositeKeyFields(Object o, EntityOutput output) throws RefreshException {
        try {
            for (int i = 0; i < this.nonKeys.length; ++i) {
                this.nonKeys[i].write(o, output);
            }
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void readCompositeKeyFields(Object o, EntityInput input2) throws RefreshException {
        try {
            for (int i = 0; i < this.nonKeys.length; ++i) {
                this.nonKeys[i].read(o, input2);
            }
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public Object getField(Object o, int field2, int superLevel, boolean isSecField) {
        if (superLevel > 0) {
            return this.superAccessor.getField(o, field2, superLevel - 1, isSecField);
        }
        try {
            Field fld = isSecField ? this.secKeys[field2].field : this.nonKeys[field2].field;
            return fld.get(o);
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void setField(Object o, int field2, int superLevel, boolean isSecField, Object value) {
        if (superLevel > 0) {
            this.superAccessor.setField(o, field2, superLevel - 1, isSecField, value);
            return;
        }
        try {
            Field fld = isSecField ? this.secKeys[field2].field : this.nonKeys[field2].field;
            fld.set(o, value);
        }
        catch (IllegalAccessException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    @Override
    public void setPriField(Object o, Object value) {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.field.set(o, value);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.setPriField(o, value);
                    break block4;
                }
                throw DbCompat.unexpectedState("No primary key field");
            }
            catch (IllegalAccessException e) {
                throw DbCompat.unexpectedException(e);
            }
        }
    }

    private static class PrimitiveAccess
    extends FieldAccess {
        private SimpleFormat format;

        PrimitiveAccess(Field field2, SimpleFormat format2) {
            super(field2);
            this.format = format2;
        }

        void write(Object o, EntityOutput out) throws IllegalAccessException {
            this.format.writePrimitiveField(o, out, this.field);
        }

        void read(Object o, EntityInput in) throws IllegalAccessException, RefreshException {
            this.format.readPrimitiveField(o, in, this.field);
        }

        boolean isNullOrZero(Object o) throws IllegalAccessException {
            return this.field.getLong(o) == 0L;
        }
    }

    private static class StringAccess
    extends FieldAccess {
        StringAccess(Field field2) {
            super(field2);
        }

        void write(Object o, EntityOutput out) throws IllegalAccessException, RefreshException {
            out.writeString((String)this.field.get(o));
        }

        void read(Object o, EntityInput in) throws IllegalAccessException, RefreshException {
            this.field.set(o, in.readStringObject());
        }
    }

    private static class KeyObjectAccess
    extends FieldAccess {
        private Format format;

        KeyObjectAccess(Field field2, Format format2) {
            super(field2);
            this.format = format2;
        }

        void write(Object o, EntityOutput out) throws IllegalAccessException, RefreshException {
            out.writeKeyObject(this.field.get(o), this.format);
        }

        void read(Object o, EntityInput in) throws IllegalAccessException, RefreshException {
            this.field.set(o, in.readKeyObject(this.format));
        }
    }

    private static class ObjectAccess
    extends FieldAccess {
        ObjectAccess(Field field2) {
            super(field2);
        }

        void write(Object o, EntityOutput out) throws IllegalAccessException, RefreshException {
            out.writeObject(this.field.get(o), null);
        }

        void read(Object o, EntityInput in) throws IllegalAccessException, RefreshException {
            this.field.set(o, in.readObject());
        }
    }

    private static abstract class FieldAccess {
        Field field;
        boolean isPrimitive;
        boolean isString = false;

        FieldAccess(Field field2) {
            this.field = field2;
            this.isPrimitive = field2.getType().isPrimitive();
            this.isString = field2.getType().getName().equals(String.class.getName());
        }

        abstract void write(Object var1, EntityOutput var2) throws IllegalAccessException, RefreshException;

        abstract void read(Object var1, EntityInput var2) throws IllegalAccessException, RefreshException;

        boolean isNullOrZero(Object o) throws IllegalAccessException {
            return this.field.get(o) == null;
        }
    }
}

