/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.picard.sam.HitsForInsert;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.CoordMath;

public class MostDistantPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        Object object;
        Object object2;
        SAMRecord sAMRecord2;
        BestEndAlignmentsAccumulator bestEndAlignmentsAccumulator = new BestEndAlignmentsAccumulator();
        BestEndAlignmentsAccumulator bestEndAlignmentsAccumulator2 = new BestEndAlignmentsAccumulator();
        CollectionUtil.MultiMap<Integer, SAMRecord> multiMap = new CollectionUtil.MultiMap<Integer, SAMRecord>();
        BestPairAlignmentsAccumulator bestPairAlignmentsAccumulator = new BestPairAlignmentsAccumulator();
        for (SAMRecord sAMRecord2 : hitsForInsert.firstOfPairOrFragment) {
            if (sAMRecord2.getReadUnmappedFlag()) {
                throw new IllegalStateException();
            }
            bestEndAlignmentsAccumulator.considerBest(sAMRecord2);
            multiMap.append(sAMRecord2.getReferenceIndex(), sAMRecord2);
        }
        for (SAMRecord sAMRecord2 : hitsForInsert.secondOfPair) {
            if (sAMRecord2.getReadUnmappedFlag()) {
                throw new IllegalStateException();
            }
            bestEndAlignmentsAccumulator2.considerBest(sAMRecord2);
            object2 = (Collection)multiMap.get(sAMRecord2.getReferenceIndex());
            if (object2 == null) continue;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                SAMRecord sAMRecord3 = (SAMRecord)iterator2.next();
                bestPairAlignmentsAccumulator.considerBest(sAMRecord3, sAMRecord2);
            }
        }
        if (bestPairAlignmentsAccumulator.hasBest()) {
            object2 = this.pickRandomlyFromList(bestPairAlignmentsAccumulator.bestAlignmentPairs);
            object = object2.getKey();
            sAMRecord2 = object2.getValue();
        } else {
            object = bestEndAlignmentsAccumulator.hasBest() ? this.pickRandomlyFromList(bestEndAlignmentsAccumulator.bestAlignments) : null;
            sAMRecord2 = bestEndAlignmentsAccumulator2.hasBest() ? this.pickRandomlyFromList(bestEndAlignmentsAccumulator2.bestAlignments) : null;
        }
        if (hitsForInsert.firstOfPairOrFragment.isEmpty() != (object == null)) {
            throw new IllegalStateException("Should not happen");
        }
        if (hitsForInsert.secondOfPair.isEmpty() != (sAMRecord2 == null)) {
            throw new IllegalStateException("Should not happen");
        }
        if (object != null) {
            this.moveToHead(hitsForInsert.firstOfPairOrFragment, (SAMRecord)object);
        }
        if (sAMRecord2 != null) {
            this.moveToHead(hitsForInsert.secondOfPair, sAMRecord2);
        }
        hitsForInsert.setPrimaryAlignment(0);
        if (hitsForInsert.firstOfPairOrFragment.size() <= 1 || hitsForInsert.secondOfPair.size() <= 1) {
            return;
        }
        int n = hitsForInsert.firstOfPairOrFragment.size() - 1;
        for (int i = 0; i < n; ++i) {
            hitsForInsert.secondOfPair.add(1, null);
        }
    }

    private <T> T pickRandomlyFromList(List<T> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private void moveToHead(List<SAMRecord> list, SAMRecord sAMRecord) {
        if (list.get(0) == sAMRecord) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i) != sAMRecord) continue;
            list.remove(i);
            list.add(0, sAMRecord);
            return;
        }
        throw new IllegalStateException("Should not be reached");
    }

    private static class BestPairAlignmentsAccumulator {
        public int bestDistance = -1;
        public int bestPairMapq = -1;
        public List<Map.Entry<SAMRecord, SAMRecord>> bestAlignmentPairs = new ArrayList<Map.Entry<SAMRecord, SAMRecord>>();

        private BestPairAlignmentsAccumulator() {
        }

        public void considerBest(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            int n = SAMUtils.combineMapqs(sAMRecord.getMappingQuality(), sAMRecord2.getMappingQuality());
            int n2 = CoordMath.getLength(Math.min(sAMRecord.getAlignmentStart(), sAMRecord2.getAlignmentStart()), Math.max(sAMRecord.getAlignmentEnd(), sAMRecord2.getAlignmentEnd()));
            if (n2 > this.bestDistance || n2 == this.bestDistance && n > this.bestPairMapq) {
                this.bestDistance = n2;
                this.bestPairMapq = n;
                this.bestAlignmentPairs.clear();
                this.bestAlignmentPairs.add(new AbstractMap.SimpleEntry<SAMRecord, SAMRecord>(sAMRecord, sAMRecord2));
            } else if (n2 == this.bestDistance && n == this.bestPairMapq) {
                this.bestAlignmentPairs.add(new AbstractMap.SimpleEntry<SAMRecord, SAMRecord>(sAMRecord, sAMRecord2));
            }
        }

        public boolean hasBest() {
            return this.bestDistance != -1;
        }
    }

    private static class BestEndAlignmentsAccumulator {
        public int bestMapq = -1;
        public List<SAMRecord> bestAlignments = new ArrayList<SAMRecord>();

        private BestEndAlignmentsAccumulator() {
        }

        public void considerBest(SAMRecord sAMRecord) {
            if (this.bestMapq == -1) {
                this.bestMapq = sAMRecord.getMappingQuality();
                this.bestAlignments.add(sAMRecord);
            } else {
                int n = SAMUtils.compareMapqs(this.bestMapq, sAMRecord.getMappingQuality());
                if (n < 0) {
                    this.bestMapq = sAMRecord.getMappingQuality();
                    this.bestAlignments.clear();
                    this.bestAlignments.add(sAMRecord);
                } else if (n == 0) {
                    this.bestAlignments.add(sAMRecord);
                }
            }
        }

        public boolean hasBest() {
            return this.bestMapq != -1;
        }
    }
}

