/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.fastq.FastqReader;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.util.FastqQualityFormat;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class QualityEncodingDetector {
    private QualityRecordAggregator qualityAggregator = new QualityRecordAggregator();
    public static final long DEFAULT_MAX_RECORDS_TO_ITERATE = 10000L;
    private static final Log log = Log.getInstance(QualityEncodingDetector.class);

    public long add(long l, FastqReader ... fastqReaderArray) {
        Iterator<FastqRecord> iterator2 = QualityEncodingDetector.generateInterleavedFastqIterator(fastqReaderArray);
        long l2 = 0L;
        while (iterator2.hasNext() && l2++ != l) {
            this.add(iterator2.next());
        }
        log.debug(String.format("Read %s records from %s.", l2, Arrays.toString(fastqReaderArray)));
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(long l, SAMFileReader sAMFileReader) {
        SAMRecordIterator sAMRecordIterator = sAMFileReader.iterator();
        long l2 = 0L;
        try {
            while (sAMRecordIterator.hasNext() && l2++ != l) {
                this.add((SAMRecord)sAMRecordIterator.next());
            }
            long l3 = l2;
            return l3;
        }
        finally {
            sAMRecordIterator.close();
        }
    }

    public void add(FastqRecord fastqRecord) {
        this.qualityAggregator.add(fastqRecord);
    }

    public void add(SAMRecord sAMRecord) {
        this.qualityAggregator.add(sAMRecord);
    }

    public boolean isDeterminationAmbiguous() {
        return this.generateCandidateQualities().size() > 1;
    }

    public EnumSet<FastqQualityFormat> generateCandidateQualities() {
        EnumSet<FastqQualityFormat> enumSet = EnumSet.allOf(FastqQualityFormat.class);
        Set<Integer> set = this.qualityAggregator.getObservedAsciiQualities();
        if (set.isEmpty()) {
            throw new PicardException("Cannot determine candidate qualities: no qualities found.");
        }
        for (QualityScheme qualityScheme : QualityScheme.values()) {
            Iterator<Integer> iterator2 = set.iterator();
            ArrayList<Range> arrayList = new ArrayList<Range>(qualityScheme.expectedAsciiRanges);
            while (iterator2.hasNext()) {
                int n = iterator2.next();
                if (!qualityScheme.asciiRange.contains(n)) {
                    enumSet.remove((Object)qualityScheme.qualityFormat);
                }
                Iterator iterator3 = arrayList.iterator();
                while (iterator3.hasNext()) {
                    if (!((Range)iterator3.next()).contains(n)) continue;
                    iterator3.remove();
                }
            }
            if (arrayList.isEmpty()) continue;
            enumSet.remove((Object)qualityScheme.qualityFormat);
        }
        return enumSet;
    }

    public FastqQualityFormat generateBestGuess(FileContext fileContext) {
        EnumSet<FastqQualityFormat> enumSet = this.generateCandidateQualities();
        switch (enumSet.size()) {
            case 1: {
                return (FastqQualityFormat)((Object)enumSet.iterator().next());
            }
            case 2: {
                if (enumSet.equals(EnumSet.of(FastqQualityFormat.Illumina, FastqQualityFormat.Solexa))) {
                    return FastqQualityFormat.Illumina;
                }
                if (enumSet.equals(EnumSet.of(FastqQualityFormat.Illumina, FastqQualityFormat.Standard))) {
                    switch (fileContext) {
                        case FASTQ: {
                            return FastqQualityFormat.Illumina;
                        }
                        case SAM: {
                            return FastqQualityFormat.Standard;
                        }
                    }
                } else {
                    if (enumSet.equals(EnumSet.of(FastqQualityFormat.Standard, FastqQualityFormat.Solexa))) {
                        throw new PicardException("The quality format cannot be determined: both Phred and Solexa formats are possible; this application's logic does not handle this scenario.");
                    }
                    throw new PicardException("Unreachable code.");
                }
            }
            case 3: {
                throw new PicardException("The quality format cannot be determined: no formats were excluded.");
            }
            case 0: {
                throw new PicardException("The quality format cannot be determined: all formats were excluded.");
            }
        }
        throw new PicardException("Unreachable code.");
    }

    private static Iterator<FastqRecord> generateInterleavedFastqIterator(final FastqReader ... fastqReaderArray) {
        return new Iterator<FastqRecord>(){
            private Queue<Iterator<FastqRecord>> queue = new LinkedList<Iterator<FastqRecord>>();
            {
                for (FastqReader fastqReader : fastqReaderArray) {
                    this.queue.add(fastqReader.iterator());
                }
            }

            @Override
            public boolean hasNext() {
                while (!this.queue.isEmpty()) {
                    if (this.queue.peek().hasNext()) {
                        return true;
                    }
                    this.queue.poll();
                }
                return false;
            }

            @Override
            public FastqRecord next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator<FastqRecord> iterator2 = this.queue.poll();
                FastqRecord fastqRecord = iterator2.next();
                this.queue.offer(iterator2);
                return fastqRecord;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static FastqQualityFormat detect(long l, FastqReader ... fastqReaderArray) {
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        long l2 = qualityEncodingDetector.add(l, fastqReaderArray);
        log.debug(String.format("Read %s records from %s.", l2, Arrays.toString(fastqReaderArray)));
        return qualityEncodingDetector.generateBestGuess(FileContext.FASTQ);
    }

    public static FastqQualityFormat detect(FastqReader ... fastqReaderArray) {
        return QualityEncodingDetector.detect(10000L, fastqReaderArray);
    }

    public static FastqQualityFormat detect(long l, SAMFileReader sAMFileReader) {
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        long l2 = qualityEncodingDetector.add(l, sAMFileReader);
        log.debug(String.format("Read %s records from %s.", l2, sAMFileReader));
        return qualityEncodingDetector.generateBestGuess(FileContext.SAM);
    }

    public static FastqQualityFormat detect(SAMFileReader sAMFileReader) {
        return QualityEncodingDetector.detect(10000L, sAMFileReader);
    }

    private static class QualityRecordAggregator {
        private Set<Integer> observedAsciiQualities = new HashSet<Integer>();

        private QualityRecordAggregator() {
        }

        public Set<Integer> getObservedAsciiQualities() {
            return Collections.unmodifiableSet(this.observedAsciiQualities);
        }

        public void add(FastqRecord fastqRecord) {
            this.addAsciiQuality(fastqRecord.getBaseQualityString().getBytes());
        }

        public void add(SAMRecord sAMRecord) {
            this.addAsciiQuality(sAMRecord.getBaseQualityString().getBytes());
        }

        private void addAsciiQuality(byte ... byArray) {
            for (byte by2 : byArray) {
                this.observedAsciiQualities.add(Integer.valueOf(by2));
            }
        }
    }

    static enum QualityScheme {
        Phred(new Range(0, 93), new Range(33, 126), Arrays.asList(new Range(33, 58)), FastqQualityFormat.Standard),
        Solexa(new Range(-5, 62), new Range(59, 126), new ArrayList<Range>(), FastqQualityFormat.Solexa),
        Illumina(new Range(0, 62), new Range(64, 126), new ArrayList<Range>(), FastqQualityFormat.Illumina);

        final Range rawRange;
        final Range asciiRange;
        final List<Range> expectedAsciiRanges;
        final FastqQualityFormat qualityFormat;

        private QualityScheme(Range range2, Range range3, List<Range> list, FastqQualityFormat fastqQualityFormat) {
            this.rawRange = range2;
            this.asciiRange = range3;
            this.expectedAsciiRanges = list;
            this.qualityFormat = fastqQualityFormat;
        }
    }

    static class Range {
        final int low;
        final int high;

        Range(int n, int n2) {
            this.low = n;
            this.high = n2;
        }

        boolean contains(int n) {
            return n <= this.high && n >= this.low;
        }
    }

    public static enum FileContext {
        FASTQ,
        SAM;

    }
}

