/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.AbstractSAMHeaderRecord;

public class SAMProgramRecord
extends AbstractSAMHeaderRecord {
    public static final String PROGRAM_GROUP_ID_TAG = "ID";
    public static final String PROGRAM_NAME_TAG = "PN";
    public static final String PROGRAM_VERSION_TAG = "VN";
    public static final String COMMAND_LINE_TAG = "CL";
    public static final String PREVIOUS_PROGRAM_GROUP_ID_TAG = "PP";
    private String mProgramGroupId;
    public static final Set<String> STANDARD_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ID", "PN", "VN", "CL", "PP")));

    public SAMProgramRecord(String string2) {
        this.mProgramGroupId = string2;
    }

    public SAMProgramRecord(String string2, SAMProgramRecord sAMProgramRecord) {
        this.mProgramGroupId = string2;
        for (Map.Entry<String, String> entry : sAMProgramRecord.getAttributes()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getId() {
        return this.getProgramGroupId();
    }

    public String getProgramGroupId() {
        return this.mProgramGroupId;
    }

    public String getProgramName() {
        return this.getAttribute(PROGRAM_NAME_TAG);
    }

    public void setProgramName(String string2) {
        this.setAttribute(PROGRAM_NAME_TAG, string2);
    }

    public String getProgramVersion() {
        return this.getAttribute(PROGRAM_VERSION_TAG);
    }

    public void setProgramVersion(String string2) {
        this.setAttribute(PROGRAM_VERSION_TAG, string2);
    }

    public String getCommandLine() {
        return this.getAttribute(COMMAND_LINE_TAG);
    }

    public void setCommandLine(String string2) {
        this.setAttribute(COMMAND_LINE_TAG, string2);
    }

    public String getPreviousProgramGroupId() {
        return this.getAttribute(PREVIOUS_PROGRAM_GROUP_ID_TAG);
    }

    public void setPreviousProgramGroupId(String string2) {
        this.setAttribute(PREVIOUS_PROGRAM_GROUP_ID_TAG, string2);
    }

    public boolean equivalent(SAMProgramRecord sAMProgramRecord) {
        return this.attributesEqual(sAMProgramRecord);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAMProgramRecord sAMProgramRecord = (SAMProgramRecord)object;
        if (!this.attributesEqual(sAMProgramRecord)) {
            return false;
        }
        return !(this.mProgramGroupId != null ? !this.mProgramGroupId.equals(sAMProgramRecord.mProgramGroupId) : sAMProgramRecord.mProgramGroupId != null);
    }

    public int hashCode() {
        int n = this.mProgramGroupId != null ? this.mProgramGroupId.hashCode() : 0;
        n = 31 * n + this.attributesHashCode();
        return n;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }
}

