/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> List<T> makeList(T ... TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public static <T> Set<T> makeSet(T ... TArray) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, TArray);
        return hashSet;
    }

    public static <T> Collection<T> makeCollection(Iterator<T> iterator2) {
        LinkedList<T> linkedList = new LinkedList<T>();
        while (iterator2.hasNext()) {
            linkedList.add(iterator2.next());
        }
        return linkedList;
    }

    public static String join(Collection<?> collection, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(obj);
        }
        return stringBuilder.toString();
    }

    public static <T> T getSoleElement(Collection<T> collection) {
        if (collection.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected a single element in %s, but found %s.", collection, collection.size()));
        }
        return collection.iterator().next();
    }

    public static <K, V> Map<K, Collection<V>> partition(Collection<V> collection, Partitioner<V, K> partitioner) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        for (V v : collection) {
            multiMap.append(partitioner.getPartition(v), v);
        }
        return multiMap;
    }

    public static class DefaultingMap<K, V>
    extends HashMap<K, V> {
        final Factory<V, K> defaultGenerator;
        final boolean injectValueOnDefault;

        public DefaultingMap(final V v) {
            this(new Factory<V, K>(){

                @Override
                public V make(K k) {
                    return v;
                }
            }, false);
        }

        public DefaultingMap(Factory<V, K> factory, boolean bl) {
            this.defaultGenerator = factory;
            this.injectValueOnDefault = bl;
        }

        @Override
        public V get(Object object) {
            if (!this.containsKey(object)) {
                V v = this.defaultGenerator.make(object);
                if (this.injectValueOnDefault) {
                    this.put(object, v);
                }
                return v;
            }
            return super.get(object);
        }

        public static interface Factory<V, K> {
            public V make(K var1);
        }
    }

    public static abstract class Partitioner<V, K> {
        public abstract K getPartition(V var1);
    }

    public static class MultiMap<K, V>
    extends HashMap<K, Collection<V>> {
        public void append(K k, V v) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).add(v);
        }

        public void appendAll(K k, Collection<? extends V> collection) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).addAll(collection);
        }

        private void initializeKeyIfUninitialized(K k) {
            if (!this.containsKey(k)) {
                this.put(k, new LinkedList());
            }
        }
    }
}

