/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineIterator;
import org.broadinstitute.variant.vcf.AbstractVCFCodec;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

public class VCF3Codec
extends AbstractVCFCodec {
    public static final String VCF3_MAGIC_HEADER = "##fileformat=VCFv3";

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        VCFHeaderVersion vCFHeaderVersion = null;
        boolean bl = false;
        while (lineIterator.hasNext()) {
            ++this.lineNo;
            String string2 = lineIterator.peek();
            if (string2.startsWith("##")) {
                String[] stringArray = string2.substring(2).split("=");
                if (stringArray.length == 2 && VCFHeaderVersion.isFormatString(stringArray[0])) {
                    if (!VCFHeaderVersion.isVersionString(stringArray[1])) {
                        throw new TribbleException.InvalidHeader(stringArray[1] + " is not a supported version");
                    }
                    bl = true;
                    vCFHeaderVersion = VCFHeaderVersion.toHeaderVersion(stringArray[1]);
                    if (vCFHeaderVersion != VCFHeaderVersion.VCF3_3 && vCFHeaderVersion != VCFHeaderVersion.VCF3_2) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv3 and does not support " + stringArray[1]);
                    }
                }
                arrayList.add((String)lineIterator.next());
                continue;
            }
            if (string2.startsWith("#")) {
                if (!bl) {
                    throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                }
                arrayList.add((String)lineIterator.next());
                return super.parseHeaderFromLines(arrayList, vCFHeaderVersion);
            }
            throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected List<String> parseFilters(String string2) {
        if (string2.equals(".")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.equals("0")) {
            return new ArrayList<String>(arrayList);
        }
        if (string2.length() == 0) {
            this.generateException("The VCF specification requires a valid filter status");
        }
        if (this.filterHash.containsKey(string2)) {
            return new ArrayList<String>((Collection)this.filterHash.get(string2));
        }
        if (string2.indexOf(";") == -1) {
            arrayList.add(string2);
        } else {
            arrayList.addAll(Arrays.asList(string2.split(";")));
        }
        this.filterHash.put(string2, arrayList);
        return arrayList;
    }

    @Override
    public boolean canDecode(String string2) {
        return VCF3Codec.canDecodeFile(string2, VCF3_MAGIC_HEADER);
    }
}

