/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFFilterHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFIDHeaderLine;

public class VCFUtils {
    public static Set<VCFHeaderLine> smartMergeHeaders(Collection<VCFHeader> collection, boolean bl) throws IllegalStateException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HeaderConflictWarner headerConflictWarner = new HeaderConflictWarner(bl);
        for (VCFHeader vCFHeader : collection) {
            for (VCFHeaderLine vCFHeaderLine : vCFHeader.getMetaDataInSortedOrder()) {
                String string2 = vCFHeaderLine.getKey();
                if (vCFHeaderLine instanceof VCFIDHeaderLine) {
                    string2 = string2 + "-" + ((VCFIDHeaderLine)((Object)vCFHeaderLine)).getID();
                }
                if (hashMap.containsKey(string2)) {
                    Object object;
                    Object object2;
                    VCFHeaderLine vCFHeaderLine2 = (VCFHeaderLine)hashMap.get(string2);
                    if (vCFHeaderLine.equals(vCFHeaderLine2)) continue;
                    if (!vCFHeaderLine.getClass().equals(vCFHeaderLine2.getClass())) {
                        throw new IllegalStateException("Incompatible header types: " + vCFHeaderLine + " " + vCFHeaderLine2);
                    }
                    if (vCFHeaderLine instanceof VCFFilterHeaderLine) {
                        object2 = ((VCFFilterHeaderLine)vCFHeaderLine).getID();
                        if (((String)object2).equals(object = ((VCFFilterHeaderLine)vCFHeaderLine2).getID())) continue;
                        throw new IllegalStateException("Incompatible header types: " + vCFHeaderLine + " " + vCFHeaderLine2);
                    }
                    if (vCFHeaderLine instanceof VCFCompoundHeaderLine) {
                        object2 = (VCFCompoundHeaderLine)vCFHeaderLine;
                        object = (VCFCompoundHeaderLine)vCFHeaderLine2;
                        if (!((VCFCompoundHeaderLine)object2).equalsExcludingDescription((VCFCompoundHeaderLine)object)) {
                            if (((VCFCompoundHeaderLine)object2).getType().equals((Object)((VCFCompoundHeaderLine)object).getType())) {
                                headerConflictWarner.warn(vCFHeaderLine, "Promoting header field Number to . due to number differences in header lines: " + vCFHeaderLine + " " + vCFHeaderLine2);
                                ((VCFCompoundHeaderLine)object).setNumberToUnbounded();
                            } else if (((VCFCompoundHeaderLine)object2).getType() == VCFHeaderLineType.Integer && ((VCFCompoundHeaderLine)object).getType() == VCFHeaderLineType.Float) {
                                headerConflictWarner.warn(vCFHeaderLine, "Promoting Integer to Float in header: " + object);
                                hashMap.put(string2, object);
                            } else if (((VCFCompoundHeaderLine)object2).getType() == VCFHeaderLineType.Float && ((VCFCompoundHeaderLine)object).getType() == VCFHeaderLineType.Integer) {
                                headerConflictWarner.warn(vCFHeaderLine, "Promoting Integer to Float in header: " + object);
                            } else {
                                throw new IllegalStateException("Incompatible header types, collision between these two types: " + vCFHeaderLine + " " + vCFHeaderLine2);
                            }
                        }
                        if (((VCFCompoundHeaderLine)object2).getDescription().equals(((VCFCompoundHeaderLine)object).getDescription())) continue;
                        headerConflictWarner.warn(vCFHeaderLine, "Allowing unequal description fields through: keeping " + object + " excluding " + object2);
                        continue;
                    }
                    headerConflictWarner.warn(vCFHeaderLine, "Ignoring header line already in map: this header line = " + vCFHeaderLine + " already present header = " + vCFHeaderLine2);
                    continue;
                }
                hashMap.put(string2, vCFHeaderLine);
            }
        }
        return new HashSet<VCFHeaderLine>(hashMap.values());
    }

    public static VCFHeader withUpdatedContigs(VCFHeader vCFHeader, File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return new VCFHeader(VCFUtils.withUpdatedContigsAsLines(vCFHeader.getMetaDataInInputOrder(), file, sAMSequenceDictionary), vCFHeader.getGenotypeSamples());
    }

    public static Set<VCFHeaderLine> withUpdatedContigsAsLines(Set<VCFHeaderLine> set, File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return VCFUtils.withUpdatedContigsAsLines(set, file, sAMSequenceDictionary, false);
    }

    public static Set<VCFHeaderLine> withUpdatedContigsAsLines(Set<VCFHeaderLine> set, File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        LinkedHashSet<VCFHeaderLine> linkedHashSet = new LinkedHashSet<VCFHeaderLine>(set.size());
        for (VCFHeaderLine vCFHeaderLine : set) {
            if (vCFHeaderLine instanceof VCFContigHeaderLine || vCFHeaderLine.getKey().equals("reference")) continue;
            linkedHashSet.add(vCFHeaderLine);
        }
        for (VCFHeaderLine vCFHeaderLine : VCFUtils.makeContigHeaderLines(sAMSequenceDictionary, file)) {
            linkedHashSet.add(vCFHeaderLine);
        }
        if (file != null) {
            int n;
            String string2 = bl ? ((n = file.getName().lastIndexOf(".")) == -1 ? file.getName() : file.getName().substring(0, n)) : "file://" + file.getAbsolutePath();
            linkedHashSet.add(new VCFHeaderLine("reference", string2));
        }
        return linkedHashSet;
    }

    public static List<VCFContigHeaderLine> makeContigHeaderLines(SAMSequenceDictionary sAMSequenceDictionary, File file) {
        ArrayList<VCFContigHeaderLine> arrayList = new ArrayList<VCFContigHeaderLine>();
        String string2 = file != null ? VCFUtils.getReferenceAssembly(file.getName()) : null;
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            arrayList.add(VCFUtils.makeContigHeaderLine(sAMSequenceRecord, string2));
        }
        return arrayList;
    }

    private static VCFContigHeaderLine makeContigHeaderLine(SAMSequenceRecord sAMSequenceRecord, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(3);
        linkedHashMap.put("ID", sAMSequenceRecord.getSequenceName());
        linkedHashMap.put("length", String.valueOf(sAMSequenceRecord.getSequenceLength()));
        if (string2 != null) {
            linkedHashMap.put("assembly", string2);
        }
        return new VCFContigHeaderLine(linkedHashMap, sAMSequenceRecord.getSequenceIndex());
    }

    private static String getReferenceAssembly(String string2) {
        String string3 = null;
        if (string2.contains("b37") || string2.contains("v37")) {
            string3 = "b37";
        } else if (string2.contains("b36")) {
            string3 = "b36";
        } else if (string2.contains("hg18")) {
            string3 = "hg18";
        } else if (string2.contains("hg19")) {
            string3 = "hg19";
        }
        return string3;
    }

    private static final class HeaderConflictWarner {
        boolean emitWarnings;
        Set<String> alreadyIssued = new HashSet<String>();

        private HeaderConflictWarner(boolean bl) {
            this.emitWarnings = bl;
        }

        public void warn(VCFHeaderLine vCFHeaderLine, String string2) {
        }
    }
}

