/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.LN;

public final class LNInfo {
    private LN ln;
    private DatabaseId dbId;
    private byte[] key;

    public LNInfo(LN ln, DatabaseId dbId, byte[] key) {
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
    }

    LN getLN() {
        return this.ln;
    }

    DatabaseId getDbId() {
        return this.dbId;
    }

    byte[] getKey() {
        return this.key;
    }

    int getMemorySize() {
        int size2 = MemoryBudget.LN_INFO_OVERHEAD;
        if (this.ln != null) {
            size2 = (int)((long)size2 + this.ln.getMemorySizeIncludedByParent());
        }
        if (this.key != null) {
            size2 += MemoryBudget.byteArraySize(this.key.length);
        }
        return size2;
    }
}

