/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.SharedSelector;
import com.sleepycat.je.evictor.TargetSelector;
import java.util.HashMap;
import java.util.Map;

public class SharedEvictor
extends Evictor {
    public SharedEvictor(EnvironmentImpl envImpl) {
        super(envImpl);
    }

    TargetSelector makeSelector() {
        return new SharedSelector(this.envImpl);
    }

    Evictor.DbCache createDbCache() {
        return new Evictor.DbCache(){
            final Map<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>> envMap = new HashMap<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>>();
            int nOperations = 0;

            public DatabaseImpl getDb(EnvironmentImpl envImpl, DatabaseId dbId) {
                Map<DatabaseId, DatabaseImpl> map2 = this.envMap.get(envImpl);
                if (map2 == null) {
                    map2 = new HashMap<DatabaseId, DatabaseImpl>();
                    this.envMap.put(envImpl, map2);
                }
                ++this.nOperations;
                if (this.nOperations % SharedEvictor.this.dbCacheClearCount == 0) {
                    this.releaseDbs();
                }
                return envImpl.getDbTree().getDb(dbId, -1L, map2);
            }

            public void releaseDbs() {
                for (Map.Entry<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>> entry : this.envMap.entrySet()) {
                    EnvironmentImpl envImpl = entry.getKey();
                    Map<DatabaseId, DatabaseImpl> map2 = entry.getValue();
                    envImpl.getDbTree().releaseDbs(map2);
                    map2.clear();
                }
            }
        };
    }
}

