/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.rep.txn.MasterTxn;

public class InsufficientAcksException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final int acksPending;
    private final int acksRequired;
    private final int ackTimeoutMs;
    private final String feederState;

    public InsufficientAcksException(MasterTxn txn, int acksPending, int ackTimeoutMs, String feederState) {
        super(null, false, "Transaction: " + txn.getId() + "  VLSN: " + txn.getCommitVLSN() + ", initiated at: " + String.format("%1tT. ", txn.getStartMs()) + " Insufficient acks for policy:" + (Object)((Object)txn.getCommitDurability().getReplicaAck()) + ". " + "Need replica acks: " + txn.getRequiredAckCount() + ". " + "Missing replica acks: " + acksPending + ". " + "Timeout: " + ackTimeoutMs + "ms. " + "FeederState=" + feederState, null);
        assert (acksPending <= txn.getRequiredAckCount());
        this.acksPending = acksPending;
        this.acksRequired = txn.getRequiredAckCount();
        this.ackTimeoutMs = ackTimeoutMs;
        this.feederState = feederState;
    }

    private InsufficientAcksException(String message, InsufficientAcksException cause) {
        super(message, cause);
        this.acksPending = cause.acksPending;
        this.acksRequired = cause.acksRequired;
        this.ackTimeoutMs = cause.ackTimeoutMs;
        this.feederState = cause.feederState;
    }

    public OperationFailureException wrapSelf(String msg) {
        return new InsufficientAcksException(msg, this);
    }

    public int acksPending() {
        return this.acksPending;
    }

    public int acksRequired() {
        return this.acksRequired;
    }

    public int ackTimeout() {
        return this.ackTimeoutMs;
    }
}

