/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RefreshException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedAccessor
implements Accessor {
    private static final Map<String, Enhanced> classRegistry = Collections.synchronizedMap(new HashMap());
    public static final boolean EXPECT_ENHANCED = "true".equals(System.getProperty("expectEnhanced"));
    private Enhanced prototype;
    private Format priKeyFormat;
    private Format[] compositeKeyFormats;
    private Class type;

    public static void registerClass(String className, Enhanced prototype) {
        classRegistry.put(className, prototype);
    }

    static boolean isEnhanced(Class type) {
        boolean enhanced = classRegistry.containsKey(type.getName());
        if (!enhanced && EXPECT_ENHANCED) {
            throw new IllegalStateException("Test was run with expectEnhanced=true but class " + type.getName() + " is not enhanced");
        }
        return enhanced;
    }

    private EnhancedAccessor(Class type) {
        this.type = type;
        this.prototype = classRegistry.get(type.getName());
        assert (this.prototype != null || Modifier.isAbstract(type.getModifiers()));
    }

    EnhancedAccessor(Catalog catalog, Class type, ComplexFormat format2) {
        this(type);
        for (ComplexFormat declaringFormat = format2; declaringFormat != null; declaringFormat = declaringFormat.getComplexSuper()) {
            FieldInfo priKeyField = declaringFormat.getPriKeyFieldInfo();
            if (priKeyField == null) continue;
            this.priKeyFormat = catalog.getFormat(priKeyField.getClassName());
            break;
        }
    }

    EnhancedAccessor(Catalog catalog, Class type, List<FieldInfo> fieldInfos) {
        this(type);
        int nFields = fieldInfos.size();
        this.compositeKeyFormats = new Format[nFields];
        for (int i = 0; i < nFields; ++i) {
            this.compositeKeyFormats[i] = catalog.getFormat(fieldInfos.get(i).getClassName());
        }
    }

    @Override
    public Object newInstance() {
        if (this.prototype == null) {
            throw DbCompat.unexpectedState();
        }
        return this.prototype.bdbNewInstance();
    }

    @Override
    public Object newArray(int len) {
        if (this.prototype == null) {
            return Array.newInstance(this.type, len);
        }
        return this.prototype.bdbNewArray(len);
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object o) {
        if (this.priKeyFormat == null) {
            throw DbCompat.unexpectedState("No primary key: " + o.getClass().getName());
        }
        return ((Enhanced)o).bdbIsPriKeyFieldNullOrZero();
    }

    @Override
    public void writePriKeyField(Object o, EntityOutput output) throws RefreshException {
        if (this.priKeyFormat == null) {
            throw DbCompat.unexpectedState("No primary key: " + o.getClass().getName());
        }
        ((Enhanced)o).bdbWritePriKeyField(output, this.priKeyFormat);
    }

    @Override
    public void readPriKeyField(Object o, EntityInput input2) throws RefreshException {
        if (this.priKeyFormat == null) {
            throw DbCompat.unexpectedState("No primary key: " + o.getClass().getName());
        }
        ((Enhanced)o).bdbReadPriKeyField(input2, this.priKeyFormat);
    }

    @Override
    public void writeSecKeyFields(Object o, EntityOutput output) throws RefreshException {
        ((Enhanced)o).bdbWriteSecKeyFields(output);
    }

    @Override
    public void readSecKeyFields(Object o, EntityInput input2, int startField, int endField, int superLevel) throws RefreshException {
        ((Enhanced)o).bdbReadSecKeyFields(input2, startField, endField, superLevel);
    }

    @Override
    public void writeNonKeyFields(Object o, EntityOutput output) throws RefreshException {
        ((Enhanced)o).bdbWriteNonKeyFields(output);
    }

    @Override
    public void readNonKeyFields(Object o, EntityInput input2, int startField, int endField, int superLevel) throws RefreshException {
        ((Enhanced)o).bdbReadNonKeyFields(input2, startField, endField, superLevel);
    }

    @Override
    public void writeCompositeKeyFields(Object o, EntityOutput output) throws RefreshException {
        ((Enhanced)o).bdbWriteCompositeKeyFields(output, this.compositeKeyFormats);
    }

    @Override
    public void readCompositeKeyFields(Object o, EntityInput input2) throws RefreshException {
        ((Enhanced)o).bdbReadCompositeKeyFields(input2, this.compositeKeyFormats);
    }

    @Override
    public Object getField(Object o, int field2, int superLevel, boolean isSecField) {
        return ((Enhanced)o).bdbGetField(o, field2, superLevel, isSecField);
    }

    @Override
    public void setField(Object o, int field2, int superLevel, boolean isSecField, Object value) {
        ((Enhanced)o).bdbSetField(o, field2, superLevel, isSecField, value);
    }

    @Override
    public void setPriField(Object o, Object value) {
        ((Enhanced)o).bdbSetPriField(o, value);
    }
}

