/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.util.keyrange.KeyRange;

public class RangeCursor
implements Cloneable {
    private Cursor cursor;
    private SecondaryCursor secCursor;
    private KeyRange range;
    private KeyRange pkRange;
    private boolean sortedDups;
    private DatabaseEntry privKey;
    private DatabaseEntry privPKey;
    private DatabaseEntry privData;
    private boolean initialized;

    public RangeCursor(KeyRange range2, KeyRange pkRange, boolean sortedDups, Cursor cursor) {
        if (pkRange != null && !range2.singleKey) {
            throw new IllegalArgumentException();
        }
        this.range = range2;
        this.pkRange = pkRange;
        this.sortedDups = sortedDups;
        this.cursor = cursor;
        this.init();
        if (pkRange != null && this.secCursor == null) {
            throw new IllegalArgumentException();
        }
    }

    public RangeCursor dup(boolean samePosition) throws DatabaseException {
        try {
            RangeCursor c = (RangeCursor)super.clone();
            c.cursor = this.dupCursor(this.cursor, samePosition);
            c.init();
            return c;
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    private void init() {
        this.secCursor = this.cursor instanceof SecondaryCursor ? (SecondaryCursor)this.cursor : null;
        if (this.range.hasBound()) {
            this.privKey = new DatabaseEntry();
            this.privPKey = new DatabaseEntry();
            this.privData = new DatabaseEntry();
        } else {
            this.privKey = null;
            this.privPKey = null;
            this.privData = null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private void setParams(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        this.privKey = key;
        this.privPKey = pKey;
        this.privData = data;
    }

    private Cursor beginOperation() throws DatabaseException {
        Cursor oldCursor = this.cursor;
        if (this.initialized) {
            this.cursor = this.dupCursor(this.cursor, true);
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        } else {
            return this.cursor;
        }
        return oldCursor;
    }

    private void endOperation(Cursor oldCursor, OperationStatus status, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) throws DatabaseException {
        if (status == OperationStatus.SUCCESS) {
            if (oldCursor != null && oldCursor != this.cursor) {
                this.closeCursor(oldCursor);
            }
            if (key != null) {
                RangeCursor.swapData(key, this.privKey);
            }
            if (pKey != null && this.secCursor != null) {
                RangeCursor.swapData(pKey, this.privPKey);
            }
            if (data != null) {
                RangeCursor.swapData(data, this.privData);
            }
            this.initialized = true;
        } else if (oldCursor != null && oldCursor != this.cursor) {
            this.closeCursor(this.cursor);
            this.cursor = oldCursor;
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        }
    }

    private static void swapData(DatabaseEntry e1, DatabaseEntry e2) {
        byte[] d1 = e1.getData();
        int o1 = e1.getOffset();
        int s1 = e1.getSize();
        e1.setData(e2.getData(), e2.getOffset(), e2.getSize());
        e2.setData(d1, o1, s1);
    }

    private static void shareData(DatabaseEntry from2, DatabaseEntry to2) {
        if (from2 != null) {
            to2.setData(from2.getData(), from2.getOffset(), from2.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetFirst(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (this.pkRange != null) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            if (this.pkRange.singleKey) {
                KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                status = this.doGetSearchBoth(lockMode);
                this.endOperation(null, status, key, pKey, data);
                return status;
            }
            status = OperationStatus.NOTFOUND;
            Cursor oldCursor = this.beginOperation();
            try {
                if (this.pkRange.beginKey == null || !this.sortedDups) {
                    status = this.doGetSearchKey(lockMode);
                } else {
                    KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                    status = this.doGetSearchBothRange(lockMode);
                    if (status == OperationStatus.SUCCESS && !this.pkRange.beginInclusive && this.pkRange.compare(this.privPKey, this.pkRange.beginKey) == 0) {
                        status = this.doGetNextDup(lockMode);
                    }
                }
                if (status == OperationStatus.SUCCESS && !this.pkRange.check(this.privPKey)) {
                    status = OperationStatus.NOTFOUND;
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.endOperation(oldCursor, status, key, pKey, data);
                throw throwable;
            }
            this.endOperation(oldCursor, status, key, pKey, data);
            return status;
        }
        if (this.range.singleKey) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            status = this.doGetSearchKey(lockMode);
            this.endOperation(null, status, key, pKey, data);
            return status;
        }
        status = OperationStatus.NOTFOUND;
        Cursor oldCursor = this.beginOperation();
        try {
            if (this.range.beginKey == null) {
                status = this.doGetFirst(lockMode);
            } else {
                KeyRange.copy(this.range.beginKey, this.privKey);
                status = this.doGetSearchKeyRange(lockMode);
                if (status == OperationStatus.SUCCESS && !this.range.beginInclusive && this.range.compare(this.privKey, this.range.beginKey) == 0) {
                    status = this.doGetNextNoDup(lockMode);
                }
            }
            if (status == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                status = OperationStatus.NOTFOUND;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.endOperation(oldCursor, status, key, pKey, data);
            throw throwable;
        }
        this.endOperation(oldCursor, status, key, pKey, data);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status = OperationStatus.NOTFOUND;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            status = this.doGetLast(lockMode);
            this.endOperation(null, status, null, null, null);
            return status;
        }
        Cursor oldCursor = this.beginOperation();
        try {
            if (this.pkRange != null) {
                KeyRange.copy(this.range.beginKey, this.privKey);
                boolean doLast = false;
                if (!this.sortedDups) {
                    status = this.doGetSearchKey(lockMode);
                } else if (this.pkRange.endKey == null) {
                    doLast = true;
                } else {
                    KeyRange.copy(this.pkRange.endKey, this.privPKey);
                    status = this.doGetSearchBothRange(lockMode);
                    if (status == OperationStatus.SUCCESS) {
                        if (!this.pkRange.endInclusive || this.pkRange.compare(this.pkRange.endKey, this.privPKey) != 0) {
                            status = this.doGetPrevDup(lockMode);
                        }
                    } else {
                        KeyRange.copy(this.range.beginKey, this.privKey);
                        doLast = true;
                    }
                }
                if (doLast && (status = this.doGetSearchKey(lockMode)) == OperationStatus.SUCCESS) {
                    status = this.doGetNextNoDup(lockMode);
                    status = status == OperationStatus.SUCCESS ? this.doGetPrev(lockMode) : this.doGetLast(lockMode);
                }
                if (status == OperationStatus.SUCCESS && !this.pkRange.check(this.privPKey)) {
                    status = OperationStatus.NOTFOUND;
                }
            } else if (this.range.endKey == null) {
                status = this.doGetLast(lockMode);
            } else {
                KeyRange.copy(this.range.endKey, this.privKey);
                status = this.doGetSearchKeyRange(lockMode);
                status = status == OperationStatus.SUCCESS ? (this.range.endInclusive && this.range.compare(this.range.endKey, this.privKey) == 0 ? ((status = this.doGetNextNoDup(lockMode)) == OperationStatus.SUCCESS ? this.doGetPrev(lockMode) : this.doGetLast(lockMode)) : this.doGetPrev(lockMode)) : this.doGetLast(lockMode);
            }
            if (status == OperationStatus.SUCCESS && !this.range.checkBegin(this.privKey, true)) {
                status = OperationStatus.NOTFOUND;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.endOperation(oldCursor, status, key, pKey, data);
            throw throwable;
        }
        this.endOperation(oldCursor, status, key, pKey, data);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.initialized) {
            return this.getFirst(key, pKey, data, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetNext(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.endKey == null) {
                status = this.doGetNextDup(lockMode);
                this.endOperation(null, status, key, pKey, data);
                return status;
            }
            status = OperationStatus.NOTFOUND;
            Cursor oldCursor = this.beginOperation();
            try {
                status = this.doGetNextDup(lockMode);
                if (status == OperationStatus.SUCCESS && !this.pkRange.checkEnd(this.privPKey, true)) {
                    status = OperationStatus.NOTFOUND;
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.endOperation(oldCursor, status, key, pKey, data);
                throw throwable;
            }
            this.endOperation(oldCursor, status, key, pKey, data);
            return status;
        }
        if (this.range.singleKey) {
            status = this.doGetNextDup(lockMode);
            this.endOperation(null, status, key, pKey, data);
            return status;
        }
        status = OperationStatus.NOTFOUND;
        Cursor oldCursor = this.beginOperation();
        try {
            status = this.doGetNext(lockMode);
            if (status == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                status = OperationStatus.NOTFOUND;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.endOperation(oldCursor, status, key, pKey, data);
            throw throwable;
        }
        this.endOperation(oldCursor, status, key, pKey, data);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.initialized) {
            return this.getFirst(key, pKey, data, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetNextNoDup(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (this.range.singleKey) {
            status = OperationStatus.NOTFOUND;
        } else {
            status = OperationStatus.NOTFOUND;
            Cursor oldCursor = this.beginOperation();
            try {
                status = this.doGetNextNoDup(lockMode);
                if (status == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                    status = OperationStatus.NOTFOUND;
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.endOperation(oldCursor, status, key, pKey, data);
                throw throwable;
            }
            this.endOperation(oldCursor, status, key, pKey, data);
            {
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.initialized) {
            return this.getLast(key, pKey, data, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetPrev(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.beginKey == null) {
                status = this.doGetPrevDup(lockMode);
                this.endOperation(null, status, key, pKey, data);
                return status;
            }
            status = OperationStatus.NOTFOUND;
            Cursor oldCursor = this.beginOperation();
            try {
                status = this.doGetPrevDup(lockMode);
                if (status == OperationStatus.SUCCESS && !this.pkRange.checkBegin(this.privPKey, true)) {
                    status = OperationStatus.NOTFOUND;
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.endOperation(oldCursor, status, key, pKey, data);
                throw throwable;
            }
            this.endOperation(oldCursor, status, key, pKey, data);
            return status;
        }
        if (this.range.singleKey) {
            status = this.doGetPrevDup(lockMode);
            this.endOperation(null, status, key, pKey, data);
            return status;
        }
        status = OperationStatus.NOTFOUND;
        Cursor oldCursor = this.beginOperation();
        try {
            status = this.doGetPrev(lockMode);
            if (status == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                status = OperationStatus.NOTFOUND;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.endOperation(oldCursor, status, key, pKey, data);
            throw throwable;
        }
        this.endOperation(oldCursor, status, key, pKey, data);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.initialized) {
            return this.getLast(key, pKey, data, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetPrevNoDup(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (this.range.singleKey) {
            status = OperationStatus.NOTFOUND;
        } else {
            status = OperationStatus.NOTFOUND;
            Cursor oldCursor = this.beginOperation();
            try {
                status = this.doGetPrevNoDup(lockMode);
                if (status == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                    status = OperationStatus.NOTFOUND;
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.endOperation(oldCursor, status, key, pKey, data);
                throw throwable;
            }
            this.endOperation(oldCursor, status, key, pKey, data);
            {
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        block7: {
            if (!this.range.hasBound()) {
                this.setParams(key, pKey, data);
                OperationStatus status2 = this.doGetSearchKey(lockMode);
                this.endOperation(null, status2, null, null, null);
                return status2;
            }
            if (!this.range.check(key)) {
                status = OperationStatus.NOTFOUND;
            } else {
                if (this.pkRange != null) {
                    status = OperationStatus.NOTFOUND;
                    Cursor oldCursor = this.beginOperation();
                    try {
                        RangeCursor.shareData(key, this.privKey);
                        status = this.doGetSearchKey(lockMode);
                        if (status == OperationStatus.SUCCESS && !this.pkRange.check(this.privPKey)) {
                            status = OperationStatus.NOTFOUND;
                        }
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.endOperation(oldCursor, status, key, pKey, data);
                        throw throwable;
                    }
                    this.endOperation(oldCursor, status, key, pKey, data);
                    {
                        break block7;
                    }
                }
                RangeCursor.shareData(key, this.privKey);
                status = this.doGetSearchKey(lockMode);
                this.endOperation(null, status, key, pKey, data);
            }
        }
        return status;
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetSearchBoth(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (!this.range.check(key) || this.pkRange != null && !this.pkRange.check(pKey)) {
            status = OperationStatus.NOTFOUND;
        } else {
            RangeCursor.shareData(key, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(pKey, this.privPKey);
            } else {
                RangeCursor.shareData(data, this.privData);
            }
            status = this.doGetSearchBoth(lockMode);
            this.endOperation(null, status, key, pKey, data);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status = OperationStatus.NOTFOUND;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            status = this.doGetSearchKeyRange(lockMode);
            this.endOperation(null, status, null, null, null);
            return status;
        }
        Cursor oldCursor = this.beginOperation();
        try {
            RangeCursor.shareData(key, this.privKey);
            status = this.doGetSearchKeyRange(lockMode);
            if (status == OperationStatus.SUCCESS && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(pKey))) {
                status = OperationStatus.NOTFOUND;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endOperation(oldCursor, status, key, pKey, data);
            throw throwable;
        }
        this.endOperation(oldCursor, status, key, pKey, data);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status = OperationStatus.NOTFOUND;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            status = this.doGetSearchBothRange(lockMode);
            this.endOperation(null, status, null, null, null);
            return status;
        }
        Cursor oldCursor = this.beginOperation();
        try {
            RangeCursor.shareData(key, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(pKey, this.privPKey);
            } else {
                RangeCursor.shareData(data, this.privData);
            }
            status = this.doGetSearchBothRange(lockMode);
            if (status == OperationStatus.SUCCESS && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(pKey))) {
                status = OperationStatus.NOTFOUND;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.endOperation(oldCursor, status, key, pKey, data);
            throw throwable;
        }
        this.endOperation(oldCursor, status, key, pKey, data);
        return status;
    }

    public OperationStatus getSearchRecordNumber(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            OperationStatus status2 = this.doGetSearchRecordNumber(lockMode);
            this.endOperation(null, status2, null, null, null);
            return status2;
        }
        if (!this.range.check(key)) {
            status = OperationStatus.NOTFOUND;
        } else {
            RangeCursor.shareData(key, this.privKey);
            status = this.doGetSearchRecordNumber(lockMode);
            this.endOperation(null, status, key, pKey, data);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        block7: {
            if (!this.initialized) {
                throw new IllegalStateException("Cursor not initialized");
            }
            if (!this.range.hasBound()) {
                this.setParams(key, pKey, data);
                status = this.doGetNextDup(lockMode);
                this.endOperation(null, status, null, null, null);
            } else {
                if (this.pkRange != null && this.pkRange.endKey != null) {
                    status = OperationStatus.NOTFOUND;
                    Cursor oldCursor = this.beginOperation();
                    try {
                        status = this.doGetNextDup(lockMode);
                        if (status == OperationStatus.SUCCESS && !this.pkRange.checkEnd(this.privPKey, true)) {
                            status = OperationStatus.NOTFOUND;
                        }
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.endOperation(oldCursor, status, key, pKey, data);
                        throw throwable;
                    }
                    this.endOperation(oldCursor, status, key, pKey, data);
                    {
                        break block7;
                    }
                }
                status = this.doGetNextDup(lockMode);
                this.endOperation(null, status, key, pKey, data);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        block7: {
            if (!this.initialized) {
                throw new IllegalStateException("Cursor not initialized");
            }
            if (!this.range.hasBound()) {
                this.setParams(key, pKey, data);
                status = this.doGetPrevDup(lockMode);
                this.endOperation(null, status, null, null, null);
            } else {
                if (this.pkRange != null && this.pkRange.beginKey != null) {
                    status = OperationStatus.NOTFOUND;
                    Cursor oldCursor = this.beginOperation();
                    try {
                        status = this.doGetPrevDup(lockMode);
                        if (status == OperationStatus.SUCCESS && !this.pkRange.checkBegin(this.privPKey, true)) {
                            status = OperationStatus.NOTFOUND;
                        }
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.endOperation(oldCursor, status, key, pKey, data);
                        throw throwable;
                    }
                    this.endOperation(oldCursor, status, key, pKey, data);
                    {
                        break block7;
                    }
                }
                status = this.doGetPrevDup(lockMode);
                this.endOperation(null, status, key, pKey, data);
            }
        }
        return status;
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (this.secCursor != null && pKey != null) {
            return this.secCursor.getCurrent(key, pKey, data, lockMode);
        }
        return this.cursor.getCurrent(key, data, lockMode);
    }

    public void close() throws DatabaseException {
        this.closeCursor(this.cursor);
    }

    public int count() throws DatabaseException {
        return this.cursor.count();
    }

    public OperationStatus delete() throws DatabaseException {
        return this.cursor.delete();
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return this.cursor.put(key, data);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return this.cursor.putNoOverwrite(key, data);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return this.cursor.putNoDupData(key, data);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException {
        return this.cursor.putCurrent(data);
    }

    public OperationStatus putAfter(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return DbCompat.putAfter(this.cursor, key, data);
    }

    public OperationStatus putBefore(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return DbCompat.putBefore(this.cursor, key, data);
    }

    private OperationStatus doGetFirst(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getFirst(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getFirst(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetLast(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getLast(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getLast(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetNext(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getNext(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getNext(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetNextDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getNextDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getNextDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetNextNoDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getNextNoDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getNextNoDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetPrev(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getPrev(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getPrev(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetPrevDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getPrevDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getPrevDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetPrevNoDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getPrevNoDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getPrevNoDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchKey(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchKey(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchKey(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchKeyRange(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchKeyRange(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchKeyRange(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchBoth(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchBoth(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchBoth(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchBothRange(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchBothRange(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchBothRange(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchRecordNumber(LockMode lockMode) throws DatabaseException {
        if (DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.getSearchRecordNumber(this.secCursor, this.privKey, this.privPKey, this.privData, lockMode);
        }
        return DbCompat.getSearchRecordNumber(this.cursor, this.privKey, this.privData, lockMode);
    }

    protected Cursor dupCursor(Cursor cursor, boolean samePosition) throws DatabaseException {
        return cursor.dup(samePosition);
    }

    protected void closeCursor(Cursor cursor) throws DatabaseException {
        cursor.close();
    }

    protected boolean checkRecordNumber() {
        return false;
    }
}

