/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.annotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.picard.annotation.AnnotationException;
import net.sf.picard.annotation.LocusFunction;
import net.sf.picard.util.Interval;
import net.sf.samtools.util.CoordMath;

public class Gene
extends Interval
implements Iterable<Transcript> {
    private final Map<String, Transcript> transcripts = new HashMap<String, Transcript>();

    public Gene(String string2, int n, int n2, boolean bl, String string3) {
        super(string2, n, n2, bl, string3);
    }

    public Transcript addTranscript(String string2, int n, int n2, int n3, int n4, int n5) {
        if (this.transcripts.containsKey(string2)) {
            throw new AnnotationException("Transcript " + string2 + " for gene " + this.getName() + " appears more than once");
        }
        Transcript transcript = new Transcript(string2, n, n2, n3, n4, n5);
        this.transcripts.put(string2, transcript);
        return transcript;
    }

    @Override
    public Iterator<Transcript> iterator() {
        return this.transcripts.values().iterator();
    }

    public class Transcript {
        public final String name;
        public final int transcriptionStart;
        public final int transcriptionEnd;
        public final int codingStart;
        public final int codingEnd;
        public final Exon[] exons;
        private int length;

        public Transcript(String string2, int n, int n2, int n3, int n4, int n5) {
            this.name = string2;
            this.transcriptionStart = n;
            this.transcriptionEnd = n2;
            this.codingStart = n3;
            this.codingEnd = n4;
            this.exons = new Exon[n5];
        }

        public Exon addExon(int n, int n2) {
            for (int i = 0; i < this.exons.length; ++i) {
                if (this.exons[i] != null) continue;
                this.exons[i] = new Exon(n, n2);
                this.length += CoordMath.getLength(n, n2);
                return this.exons[i];
            }
            throw new IllegalStateException("Attempting to add more exons that exist for transcript.");
        }

        public int start() {
            return this.exons[0].start;
        }

        public int end() {
            return this.exons[this.exons.length - 1].end;
        }

        public int length() {
            return this.length;
        }

        public boolean isSoloTranscript() {
            return Gene.this.transcripts.size() == 1;
        }

        public Gene getGene() {
            return Gene.this;
        }

        public void assignLocusFunctionForRange(int n, LocusFunction[] locusFunctionArray) {
            for (int i = Math.max(n, this.transcriptionStart); i <= Math.min(this.transcriptionEnd, CoordMath.getEnd(n, locusFunctionArray.length)); ++i) {
                if (locusFunctionArray[i - n].ordinal() > LocusFunction.CODING.ordinal()) continue;
                LocusFunction locusFunction = this.inExon(i) ? (this.utr(i) ? LocusFunction.UTR : LocusFunction.CODING) : LocusFunction.INTRONIC;
                if (locusFunction.ordinal() <= locusFunctionArray[i - n].ordinal()) continue;
                locusFunctionArray[i - n] = locusFunction;
            }
        }

        public void addCoverageCounts(int n, int n2, int[] nArray) {
            for (int i = n; i < n2; ++i) {
                int n3 = this.getTranscriptCoordinate(i);
                if (n3 <= 0) continue;
                int n4 = n3 - 1;
                nArray[n4] = nArray[n4] + 1;
            }
        }

        public int getTranscriptCoordinate(int n) {
            int n2 = 0;
            for (Exon exon : this.exons) {
                if (n >= exon.start && n <= exon.end) {
                    return n - exon.start + 1 + n2;
                }
                n2 += CoordMath.getLength(exon.start, exon.end);
            }
            return -1;
        }

        private boolean utr(int n) {
            return n < this.codingStart || n > this.codingEnd;
        }

        private boolean inExon(int n) {
            for (int i = 0; i < this.exons.length; ++i) {
                Exon exon = this.exons[i];
                if (exon.start > n) {
                    return false;
                }
                if (!this.inRange(exon.start, exon.end, n)) continue;
                return true;
            }
            return false;
        }

        private boolean inRange(int n, int n2, int n3) {
            return n3 >= n && n3 <= n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Transcript transcript = (Transcript)object;
            if (this.codingEnd != transcript.codingEnd) {
                return false;
            }
            if (this.codingStart != transcript.codingStart) {
                return false;
            }
            if (this.transcriptionEnd != transcript.transcriptionEnd) {
                return false;
            }
            if (this.transcriptionStart != transcript.transcriptionStart) {
                return false;
            }
            return this.name.equals(transcript.name);
        }

        public int hashCode() {
            int n = this.name.hashCode();
            n = 31 * n + this.transcriptionStart;
            n = 31 * n + this.transcriptionEnd;
            n = 31 * n + this.codingStart;
            n = 31 * n + this.codingEnd;
            return n;
        }

        public class Exon {
            public final int start;
            public final int end;

            public Exon(int n, int n2) {
                this.start = n;
                this.end = n2;
            }
        }
    }
}

