/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.BufferedWriter;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.illumina.parser.ReadType;
import net.sf.picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.TabbedTextFileWithHeaderParser;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class ExtractIlluminaBarcodes
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Determine the barcode for each read in an Illumina lane.\n" + "For each tile, a file is written to the basecalls directory of the form s_<lane>_<tile>_barcode.txt. " + "An output file contains a line for each read in the tile, aligned with the regular basecall output. \n" + "The output file contains the following tab-separated columns: \n" + "    * read subsequence at barcode position\n" + "    * Y or N indicating if there was a barcode match\n" + "    * matched barcode sequence\n" + "Note that the order of specification of barcodes can cause arbitrary differences in output for poorly matching barcodes.\n\n";
    @Option(doc="The Illumina basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="Where to write _barcode.txt files.  By default, these are written to BASECALLS_DIR.", optional=true)
    public File OUTPUT_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Barcode sequence.  These must be unique, and all the same length.  This cannot be used with reads that have more than one barcode; use BARCODE_FILE in that case. ", mutex={"BARCODE_FILE"})
    public List<String> BARCODE = new ArrayList<String>();
    @Option(doc="Tab-delimited file of barcode sequences, barcode name and, optionally, library name.  Barcodes must be unique and all the same length.  Column headers must be 'barcode_sequence_1', 'barcode_sequence_2' (optional), 'barcode_name', and 'library_name'.", mutex={"BARCODE"})
    public File BARCODE_FILE;
    @Option(doc="Per-barcode and per-lane metrics written to this file.", shortName="M")
    public File METRICS_FILE;
    @Option(doc="Maximum mismatches for a barcode to be considered a match.")
    public int MAX_MISMATCHES = 1;
    @Option(doc="Minimum difference between number of mismatches in the best and second best barcodes for a barcode to be considered a match.")
    public int MIN_MISMATCH_DELTA = 1;
    @Option(doc="Maximum allowable number of no-calls in a barcode read before it is considered unmatchable.")
    public int MAX_NO_CALLS = 2;
    @Option(shortName="Q", doc="Minimum base quality. Any barcode bases falling below this quality will be considered a mismatch even in the bases match.")
    public int MINIMUM_BASE_QUALITY = 0;
    @Option(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Option(shortName="GZIP", doc="Compress output s_l_t_barcode.txt files using gzip and append a .gz extension to the filenames.")
    public boolean COMPRESS_OUTPUTS = false;
    @Option(doc="Run this many PerTileBarcodeExtractors in parallel.  If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0 then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public int NUM_PROCESSORS = 1;
    private final Log log = Log.getInstance(ExtractIlluminaBarcodes.class);
    private ReadStructure readStructure;
    private ReadStructure outputReadStructure;
    private IlluminaDataProviderFactory factory;
    private final Map<String, BarcodeMetric> barcodeToMetrics = new LinkedHashMap<String, BarcodeMetric>();
    private BarcodeMetric noMatchMetric = null;
    private final NumberFormat tileNumberFormatter = NumberFormat.getNumberInstance();
    private BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    private static final String BARCODE_SEQUENCE_COLUMN = "barcode_sequence";
    private static final String BARCODE_SEQUENCE_1_COLUMN = "barcode_sequence_1";
    private static final String BARCODE_NAME_COLUMN = "barcode_name";
    private static final String LIBRARY_NAME_COLUMN = "library_name";

    public ExtractIlluminaBarcodes() {
        this.tileNumberFormatter.setMinimumIntegerDigits(4);
        this.tileNumberFormatter.setGroupingUsed(false);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsWritable(this.METRICS_FILE);
        if (this.OUTPUT_DIR == null) {
            this.OUTPUT_DIR = this.BASECALLS_DIR;
        }
        IoUtil.assertDirectoryIsWritable(this.OUTPUT_DIR);
        String[] stringArray = new String[this.readStructure.barcodes.length()];
        int n = 0;
        for (ReadDescriptor object2 : this.readStructure.descriptors) {
            if (object2.type != ReadType.Barcode) continue;
            stringArray[n++] = StringUtil.repeatCharNTimes('N', object2.length);
        }
        this.noMatchMetric = new BarcodeMetric(null, null, IlluminaUtil.barcodeSeqsToString(stringArray), stringArray);
        int n2 = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        this.log.info("Processing with " + n2 + " PerTileBarcodeExtractor(s).");
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        ArrayList<PerTileBarcodeExtractor> arrayList = new ArrayList<PerTileBarcodeExtractor>(this.factory.getAvailableTiles().size());
        for (int perTileBarcodeExtractor : this.factory.getAvailableTiles()) {
            PerTileBarcodeExtractor n6 = new PerTileBarcodeExtractor(perTileBarcodeExtractor, this.getBarcodeFile(perTileBarcodeExtractor));
            executorService.submit(n6);
            arrayList.add(n6);
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(6L, TimeUnit.HOURS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.log.error("Pool did not terminate");
                }
                return 1;
            }
        }
        catch (InterruptedException n4) {
            executorService.shutdownNow();
            return 2;
        }
        this.log.info("Processed " + arrayList.size() + " tiles.");
        for (PerTileBarcodeExtractor n5 : arrayList) {
            for (String d : this.barcodeToMetrics.keySet()) {
                this.barcodeToMetrics.get(d).merge(n5.getMetrics().get(d));
            }
            this.noMatchMetric.merge(n5.getNoMatchMetric());
            if (n5.getException() == null) continue;
            this.log.error("Abandoning metrics calculation because one or more PerTileBarcodeExtractors failed.");
            return 4;
        }
        int n3 = this.noMatchMetric.READS;
        int n4 = this.noMatchMetric.PF_READS;
        int n5 = 0;
        for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
            n3 += barcodeMetric.READS;
            n4 += barcodeMetric.PF_READS;
            n5 += barcodeMetric.PF_READS;
        }
        if (n3 > 0) {
            this.noMatchMetric.PCT_MATCHES = (double)this.noMatchMetric.READS / (double)n3;
            double d = 0.0;
            for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
                barcodeMetric.PCT_MATCHES = (double)barcodeMetric.READS / (double)n3;
                if (!(barcodeMetric.PCT_MATCHES > d)) continue;
                d = barcodeMetric.PCT_MATCHES;
            }
            if (d > 0.0) {
                this.noMatchMetric.RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = this.noMatchMetric.PCT_MATCHES / d;
                for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
                    barcodeMetric.RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric.PCT_MATCHES / d;
                }
            }
        }
        if (n4 > 0) {
            this.noMatchMetric.PF_PCT_MATCHES = (double)this.noMatchMetric.PF_READS / (double)n4;
            double d = 0.0;
            for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
                barcodeMetric.PF_PCT_MATCHES = (double)barcodeMetric.PF_READS / (double)n4;
                if (!(barcodeMetric.PF_PCT_MATCHES > d)) continue;
                d = barcodeMetric.PF_PCT_MATCHES;
            }
            if (d > 0.0) {
                this.noMatchMetric.PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = this.noMatchMetric.PF_PCT_MATCHES / d;
                for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
                    barcodeMetric.PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric.PF_PCT_MATCHES / d;
                }
            }
        }
        for (Map.Entry<Byte, Integer> entry : this.bclQualityEvaluationStrategy.getPoorQualityFrequencies().entrySet()) {
            this.log.warn(String.format("Observed low quality of %s %s times.", entry.getKey(), entry.getValue()));
        }
        this.bclQualityEvaluationStrategy.assertMinimumQualities();
        if (n5 > 0) {
            double d = (double)n5 / (double)this.barcodeToMetrics.values().size();
            for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
                barcodeMetric.PF_NORMALIZED_MATCHES = (double)barcodeMetric.PF_READS / d;
            }
        }
        MetricsFile metricsFile = this.getMetricsFile();
        for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
            metricsFile.addMetric(barcodeMetric);
        }
        metricsFile.addMetric(this.noMatchMetric);
        metricsFile.write(this.METRICS_FILE);
        return 0;
    }

    private File getBarcodeFile(int n) {
        return new File(this.OUTPUT_DIR, "s_" + this.LANE + "_" + this.tileNumberFormatter.format(n) + "_barcode.txt" + (this.COMPRESS_OUTPUTS ? ".gz" : ""));
    }

    @Override
    protected String[] customCommandLineValidation() {
        IlluminaDataType[] illuminaDataTypeArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        this.readStructure = new ReadStructure(this.READ_STRUCTURE.replaceAll("T", "S"));
        if (this.MINIMUM_BASE_QUALITY > 0) {
            IlluminaDataType[] illuminaDataTypeArray2 = new IlluminaDataType[3];
            illuminaDataTypeArray2[0] = IlluminaDataType.BaseCalls;
            illuminaDataTypeArray2[1] = IlluminaDataType.PF;
            illuminaDataTypeArray = illuminaDataTypeArray2;
            illuminaDataTypeArray2[2] = IlluminaDataType.QualityScores;
        } else {
            IlluminaDataType[] illuminaDataTypeArray3 = new IlluminaDataType[2];
            illuminaDataTypeArray3[0] = IlluminaDataType.BaseCalls;
            illuminaDataTypeArray = illuminaDataTypeArray3;
            illuminaDataTypeArray3[1] = IlluminaDataType.PF;
        }
        IlluminaDataType[] illuminaDataTypeArray4 = illuminaDataTypeArray;
        this.factory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, this.readStructure, this.bclQualityEvaluationStrategy, illuminaDataTypeArray4);
        this.outputReadStructure = this.factory.getOutputReadStructure();
        if (this.BARCODE_FILE != null) {
            this.parseBarcodeFile(arrayList);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : this.BARCODE) {
                if (hashSet.contains(string2)) {
                    arrayList.add("Barcode " + string2 + " specified more than once.");
                }
                hashSet.add(string2);
                BarcodeMetric barcodeMetric = new BarcodeMetric(null, null, string2, new String[]{string2});
                this.barcodeToMetrics.put(string2, barcodeMetric);
            }
        }
        if (this.barcodeToMetrics.keySet().size() == 0) {
            arrayList.add("No barcodes have been specified.");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        System.exit(new ExtractIlluminaBarcodes().instanceMain(stringArray));
    }

    private void parseBarcodeFile(ArrayList<String> arrayList) {
        String string2;
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(this.BARCODE_FILE);
        String string3 = tabbedTextFileWithHeaderParser.hasColumn(BARCODE_SEQUENCE_COLUMN) ? BARCODE_SEQUENCE_COLUMN : (string2 = tabbedTextFileWithHeaderParser.hasColumn(BARCODE_SEQUENCE_1_COLUMN) ? BARCODE_SEQUENCE_1_COLUMN : null);
        if (string2 == null) {
            arrayList.add(this.BARCODE_FILE + " does not have " + BARCODE_SEQUENCE_COLUMN + " or " + BARCODE_SEQUENCE_1_COLUMN + " column header");
            return;
        }
        boolean bl = tabbedTextFileWithHeaderParser.hasColumn(BARCODE_NAME_COLUMN);
        boolean bl2 = tabbedTextFileWithHeaderParser.hasColumn(LIBRARY_NAME_COLUMN);
        int n = this.readStructure.barcodes.length();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            String string4;
            String[] stringArray = new String[n];
            int n2 = 1;
            for (ReadDescriptor readDescriptor : this.readStructure.descriptors) {
                if (readDescriptor.type != ReadType.Barcode) continue;
                string4 = n2 == 1 ? string2 : "barcode_sequence_" + String.valueOf(n2);
                stringArray[n2 - 1] = row.getField(string4);
                ++n2;
            }
            String string5 = IlluminaUtil.barcodeSeqsToString(stringArray);
            if (hashSet.contains(string5)) {
                arrayList.add("Barcode " + (String)string5 + " specified more than once in " + this.BARCODE_FILE);
            }
            hashSet.add(string5);
            String object2 = bl ? row.getField(BARCODE_NAME_COLUMN) : "";
            string4 = bl2 ? row.getField(LIBRARY_NAME_COLUMN) : "";
            BarcodeMetric barcodeMetric = new BarcodeMetric(object2, string4, string5, stringArray);
            this.barcodeToMetrics.put(StringUtil.join("", stringArray), barcodeMetric);
        }
        tabbedTextFileWithHeaderParser.close();
    }

    private class PerTileBarcodeExtractor
    implements Runnable {
        private final int tile;
        private final File barcodeFile;
        private final Map<String, BarcodeMetric> metrics;
        private final BarcodeMetric noMatch;
        private Exception exception = null;
        private final boolean usingQualityScores;

        public PerTileBarcodeExtractor(int n, File file) {
            this.usingQualityScores = ExtractIlluminaBarcodes.this.MINIMUM_BASE_QUALITY > 0;
            this.tile = n;
            this.barcodeFile = file;
            this.metrics = new LinkedHashMap<String, BarcodeMetric>(ExtractIlluminaBarcodes.this.barcodeToMetrics.size());
            for (String string2 : ExtractIlluminaBarcodes.this.barcodeToMetrics.keySet()) {
                this.metrics.put(string2, BarcodeMetric.copy((BarcodeMetric)ExtractIlluminaBarcodes.this.barcodeToMetrics.get(string2)));
            }
            this.noMatch = BarcodeMetric.copy(ExtractIlluminaBarcodes.this.noMatchMetric);
        }

        public synchronized Map<String, BarcodeMetric> getMetrics() {
            return this.metrics;
        }

        public synchronized BarcodeMetric getNoMatchMetric() {
            return this.noMatch;
        }

        public synchronized Exception getException() {
            return this.exception;
        }

        @Override
        public synchronized void run() {
            try {
                Object object;
                ExtractIlluminaBarcodes.this.log.info("Extracting barcodes for tile " + this.tile);
                IlluminaDataProvider illuminaDataProvider = ExtractIlluminaBarcodes.this.factory.makeDataProvider(Arrays.asList(this.tile));
                int[] nArray = ((ExtractIlluminaBarcodes)ExtractIlluminaBarcodes.this).outputReadStructure.barcodes.getIndices();
                BufferedWriter bufferedWriter = IoUtil.openFileForBufferedWriting(this.barcodeFile);
                byte[][] byArrayArray = new byte[nArray.length][];
                Object object2 = object = this.usingQualityScores ? (Object)new byte[nArray.length][] : (byte[][])null;
                while (illuminaDataProvider.hasNext()) {
                    int n;
                    ClusterData clusterData = illuminaDataProvider.next();
                    for (n = 0; n < nArray.length; ++n) {
                        byArrayArray[n] = clusterData.getRead(nArray[n]).getBases();
                        if (!this.usingQualityScores) continue;
                        object[n] = clusterData.getRead(nArray[n]).getQualities();
                    }
                    n = clusterData.isPf().booleanValue() ? 1 : 0;
                    BarcodeMatch barcodeMatch = this.findBestBarcodeAndUpdateMetrics(byArrayArray, (byte[][])object, n != 0, this.metrics, ExtractIlluminaBarcodes.this.noMatchMetric);
                    String string2 = barcodeMatch.matched ? "Y" : "N";
                    for (byte[] byArray : byArrayArray) {
                        bufferedWriter.write(StringUtil.bytesToString(byArray));
                    }
                    bufferedWriter.write("\t" + string2 + "\t" + barcodeMatch.barcode + "\t" + String.valueOf(barcodeMatch.mismatches) + "\t" + String.valueOf(barcodeMatch.mismatchesToSecondBest));
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (Exception exception) {
                ExtractIlluminaBarcodes.this.log.error(exception, "Error processing tile ", this.tile);
                this.exception = exception;
            }
        }

        private BarcodeMatch findBestBarcodeAndUpdateMetrics(byte[][] byArray, byte[][] byArray2, boolean bl, Map<String, BarcodeMetric> map2, BarcodeMetric barcodeMetric) {
            BarcodeMetric object2 = null;
            int n = 0;
            int n2 = 0;
            for (byte[] object3 : byArray) {
                n += object3.length;
                for (byte by2 : object3) {
                    if (!SequenceUtil.isNoCall(by2)) continue;
                    ++n2;
                }
            }
            int n3 = n + 1;
            int n4 = n + 1;
            for (BarcodeMetric barcodeMetric2 : map2.values()) {
                int n5 = this.countMismatches(barcodeMetric2.barcodeBytes, byArray, byArray2);
                if (n5 < n3) {
                    if (object2 != null) {
                        n4 = n3;
                    }
                    n3 = n5;
                    object2 = barcodeMetric2;
                    continue;
                }
                if (n5 >= n4) continue;
                n4 = n5;
            }
            boolean bl2 = object2 != null && n2 <= ExtractIlluminaBarcodes.this.MAX_NO_CALLS && n3 <= ExtractIlluminaBarcodes.this.MAX_MISMATCHES && n4 - n3 >= ExtractIlluminaBarcodes.this.MIN_MISMATCH_DELTA;
            BarcodeMatch barcodeMatch = new BarcodeMatch();
            if (n2 + n3 < n) {
                barcodeMatch.mismatches = n3;
                barcodeMatch.mismatchesToSecondBest = n4;
                barcodeMatch.barcode = object2.BARCODE.toLowerCase().replaceAll("-", "");
            } else {
                barcodeMatch.mismatches = n;
                barcodeMatch.barcode = "";
            }
            if (bl2) {
                ++object2.READS;
                if (bl) {
                    ++object2.PF_READS;
                }
                if (n3 == 0) {
                    ++object2.PERFECT_MATCHES;
                    if (bl) {
                        ++object2.PF_PERFECT_MATCHES;
                    }
                } else if (n3 == 1) {
                    ++object2.ONE_MISMATCH_MATCHES;
                    if (bl) {
                        ++object2.PF_ONE_MISMATCH_MATCHES;
                    }
                }
                barcodeMatch.matched = true;
                barcodeMatch.barcode = object2.BARCODE.replaceAll("-", "");
            } else {
                ++barcodeMetric.READS;
                if (bl) {
                    ++barcodeMetric.PF_READS;
                }
            }
            return barcodeMatch;
        }

        private int countMismatches(byte[][] byArray, byte[][] byArray2, byte[][] byArray3) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = Math.min(byArray[i].length, byArray2[i].length);
                for (int j = 0; j < n2; ++j) {
                    if (SequenceUtil.isNoCall(byArray2[i][j])) continue;
                    if (!SequenceUtil.basesEqual(byArray[i][j], byArray2[i][j])) {
                        ++n;
                        continue;
                    }
                    if (byArray3 == null || byArray3[i][j] >= ExtractIlluminaBarcodes.this.MINIMUM_BASE_QUALITY) continue;
                    ++n;
                }
            }
            return n;
        }

        class BarcodeMatch {
            boolean matched;
            String barcode;
            int mismatches;
            int mismatchesToSecondBest;

            BarcodeMatch() {
            }
        }
    }

    public static class BarcodeMetric
    extends MetricBase {
        public String BARCODE;
        public String BARCODE_NAME = "";
        public String LIBRARY_NAME = "";
        public int READS = 0;
        public int PF_READS = 0;
        public int PERFECT_MATCHES = 0;
        public int PF_PERFECT_MATCHES = 0;
        public int ONE_MISMATCH_MATCHES = 0;
        public int PF_ONE_MISMATCH_MATCHES = 0;
        public double PCT_MATCHES = 0.0;
        public double RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = 0.0;
        public double PF_PCT_MATCHES = 0.0;
        public double PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = 0.0;
        public double PF_NORMALIZED_MATCHES;
        protected byte[][] barcodeBytes;

        public BarcodeMetric(String string2, String string3, String string4, String[] stringArray) {
            this.BARCODE = string4;
            this.BARCODE_NAME = string2;
            this.LIBRARY_NAME = string3;
            this.barcodeBytes = new byte[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                this.barcodeBytes[i] = StringUtil.stringToBytes(stringArray[i]);
            }
        }

        public BarcodeMetric() {
            this.barcodeBytes = null;
        }

        public static BarcodeMetric copy(BarcodeMetric barcodeMetric) {
            BarcodeMetric barcodeMetric2 = new BarcodeMetric();
            barcodeMetric2.BARCODE = barcodeMetric.BARCODE;
            barcodeMetric2.BARCODE_NAME = barcodeMetric.BARCODE_NAME;
            barcodeMetric2.LIBRARY_NAME = barcodeMetric.LIBRARY_NAME;
            barcodeMetric2.barcodeBytes = barcodeMetric.barcodeBytes;
            return barcodeMetric2;
        }

        public void merge(BarcodeMetric barcodeMetric) {
            this.READS += barcodeMetric.READS;
            this.PF_READS += barcodeMetric.PF_READS;
            this.PERFECT_MATCHES += barcodeMetric.PERFECT_MATCHES;
            this.PF_PERFECT_MATCHES += barcodeMetric.PF_PERFECT_MATCHES;
            this.ONE_MISMATCH_MATCHES += barcodeMetric.ONE_MISMATCH_MATCHES;
            this.PF_ONE_MISMATCH_MATCHES += barcodeMetric.PF_ONE_MISMATCH_MATCHES;
        }
    }
}

