/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadType;
import net.sf.samtools.util.CoordMath;

public class ReadStructure {
    public static final String PARAMETER_DOC = "A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.";
    public final List<ReadDescriptor> descriptors;
    public final int totalCycles;
    public final int[] readLengths;
    public final Substructure barcodes;
    public final Substructure templates;
    public final Substructure skips;
    public final Substructure nonSkips;
    private static final String ValidTypeChars;
    private static final String ValidTypeCharsWSep;
    private static final String ReadStructureMsg;
    private static final Pattern FullPattern;
    private static final Pattern SubPattern;

    public ReadStructure(List<ReadDescriptor> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("ReadStructure does not support 0 length clusters!");
        }
        ArrayList<Range> arrayList = new ArrayList<Range>(list.size());
        this.descriptors = Collections.unmodifiableList(list);
        int n = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        this.readLengths = new int[list.size()];
        int n2 = 0;
        int n3 = 0;
        for (ReadDescriptor readDescriptor : this.descriptors) {
            if (readDescriptor.length == 0 || readDescriptor.length < 0) {
                throw new IllegalArgumentException("ReadStructure only supports ReadDescriptor lengths > 0, found(" + readDescriptor.length + ")");
            }
            int n4 = CoordMath.getEnd(n2, readDescriptor.length);
            arrayList.add(new Range(n2, n4));
            n2 = n4 + 1;
            this.readLengths[n3] = readDescriptor.length;
            n += readDescriptor.length;
            switch (readDescriptor.type) {
                case B: {
                    arrayList2.add(n3);
                    arrayList3.add(n3);
                    break;
                }
                case T: {
                    arrayList2.add(n3);
                    arrayList4.add(n3);
                    break;
                }
                case S: {
                    arrayList5.add(n3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported ReadType (" + (Object)((Object)readDescriptor.type) + ") encountered by IlluminaRunConfiugration!");
                }
            }
            ++n3;
        }
        this.totalCycles = n;
        this.barcodes = new Substructure(arrayList3, arrayList);
        this.templates = new Substructure(arrayList4, arrayList);
        this.skips = new Substructure(arrayList5, arrayList);
        this.nonSkips = new Substructure(arrayList2, arrayList);
    }

    public ReadStructure(String string2) {
        this(ReadStructure.readStructureStringToDescriptors(string2));
    }

    public int getNumDescriptors() {
        return this.descriptors.size();
    }

    public String toString() {
        String string2 = "";
        for (ReadDescriptor readDescriptor : this.descriptors) {
            string2 = string2 + readDescriptor.toString();
        }
        return string2;
    }

    private static final List<ReadDescriptor> readStructureStringToDescriptors(String string2) {
        Matcher matcher = FullPattern.matcher(string2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string2 + " cannot be parsed as a ReadStructure! " + ReadStructureMsg);
        }
        Matcher matcher2 = SubPattern.matcher(string2);
        ArrayList<ReadDescriptor> arrayList = new ArrayList<ReadDescriptor>();
        while (matcher2.find()) {
            ReadDescriptor readDescriptor = new ReadDescriptor(Integer.parseInt(matcher2.group(1)), ReadType.valueOf(matcher2.group(2)));
            arrayList.add(readDescriptor);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadStructure readStructure = (ReadStructure)object;
        if (this.descriptors.size() != readStructure.descriptors.size()) {
            return false;
        }
        for (int i = 0; i < this.descriptors.size(); ++i) {
            if (this.descriptors.get(i).equals(readStructure.descriptors.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.descriptors.get(0).hashCode();
        for (int i = 1; i < this.descriptors.size(); ++i) {
            n *= this.descriptors.get(i).hashCode();
        }
        return n;
    }

    static {
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        for (ReadType readType : ReadType.values()) {
            if (bl) {
                string3 = string3 + ",";
            }
            string2 = string2 + readType.name();
            string3 = string3 + readType.name();
        }
        ValidTypeChars = string2;
        ValidTypeCharsWSep = string3;
        ReadStructureMsg = "Read structure must be formatted as follows: <number of bases><type><number of bases><type>...<number of bases> where number of bases is a positive (NON-ZERO) integer and type is one of the following characters " + ValidTypeCharsWSep + " (e.g. 76T8B68T would denote a paired-end run with a 76 base first end an 8 base barcode followed by a 68 base second end).";
        FullPattern = Pattern.compile("^((\\d+[" + ValidTypeChars + "]{1}))+$");
        SubPattern = Pattern.compile("(\\d+)([" + ValidTypeChars + "]{1})");
    }

    private class IndexedIterator
    implements Iterator<ReadDescriptor> {
        private int index;
        private int[] indices;

        public IndexedIterator(int[] nArray) {
            this.indices = nArray;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.indices.length;
        }

        @Override
        public ReadDescriptor next() {
            return ReadStructure.this.descriptors.get(this.indices[this.index++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Substructure
    implements Iterable<ReadDescriptor> {
        private final int numDescriptors;
        private final int[] descriptorIndices;
        private final int[] descriptorLengths;
        private final Range[] cycleIndexRanges;
        private final int totalCycles;

        public Substructure(List<Integer> list, List<Range> list2) {
            int n;
            this.numDescriptors = list.size();
            this.descriptorIndices = new int[this.numDescriptors];
            this.descriptorLengths = new int[this.numDescriptors];
            for (n = 0; n < list.size(); ++n) {
                this.descriptorIndices[n] = list.get(n);
                this.descriptorLengths[n] = ReadStructure.this.descriptors.get((int)this.descriptorIndices[n]).length;
            }
            this.cycleIndexRanges = new Range[this.numDescriptors];
            for (n = 0; n < this.numDescriptors; ++n) {
                this.cycleIndexRanges[n] = list2.get(this.descriptorIndices[n]);
            }
            n = 0;
            for (int n2 : this.descriptorLengths) {
                n += n2;
            }
            this.totalCycles = n;
        }

        public ReadDescriptor get(int n) {
            return ReadStructure.this.descriptors.get(this.descriptorIndices[n]);
        }

        public boolean isEmpty() {
            return this.numDescriptors == 0;
        }

        public int length() {
            return this.numDescriptors;
        }

        public int getTotalCycles() {
            return this.totalCycles;
        }

        public int[] getIndices() {
            return this.descriptorIndices;
        }

        public int[] getDescriptorLengths() {
            return this.descriptorLengths;
        }

        public Range[] getCycleIndexRanges() {
            return this.cycleIndexRanges;
        }

        @Override
        public Iterator<ReadDescriptor> iterator() {
            return new IndexedIterator(this.descriptorIndices);
        }

        public int[] getCycles() {
            int[] nArray = new int[this.totalCycles];
            int n = 0;
            for (Range range2 : this.cycleIndexRanges) {
                for (int i = range2.start; i <= range2.end; ++i) {
                    nArray[n++] = i + 1;
                }
            }
            return nArray;
        }

        public ReadStructure toReadStructure() {
            ArrayList<ReadDescriptor> arrayList = new ArrayList<ReadDescriptor>(this.numDescriptors);
            for (ReadDescriptor readDescriptor : this) {
                arrayList.add(readDescriptor);
            }
            return new ReadStructure(arrayList);
        }
    }
}

