/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.io;

import java.io.IOException;
import java.io.InputStream;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CloserUtil;

public class FastLineReader {
    private InputStream in;
    private byte[] fileBuffer = new byte[512000];
    private int nextByte = 0;
    private int numBytes = 0;
    private boolean atEof;

    public FastLineReader(InputStream inputStream) {
        this.in = inputStream;
        this.ensureBufferNotEmpty();
    }

    public boolean eof() {
        return this.atEof;
    }

    public boolean atEoln() {
        return this.ensureBufferNotEmpty() && (this.fileBuffer[this.nextByte] == 10 || this.fileBuffer[this.nextByte] == 13);
    }

    public boolean skipNewlines() {
        boolean bl = false;
        while (this.atEoln()) {
            bl = true;
            ++this.nextByte;
        }
        return bl;
    }

    public void close() {
        CloserUtil.close(this.in);
        this.in = null;
        this.fileBuffer = null;
    }

    public byte getByte() {
        byte by2 = this.peekByte();
        ++this.nextByte;
        this.ensureBufferNotEmpty();
        return by2;
    }

    public byte peekByte() {
        if (this.eof()) {
            throw new IllegalStateException("Cannot getByte() if EOF.");
        }
        return this.fileBuffer[this.nextByte];
    }

    public int readToEndOfOutputBufferOrEoln(byte[] byArray, int n) {
        int n2 = 0;
        while (this.ensureBufferNotEmpty()) {
            int n3 = this.nextByte;
            boolean bl = this.advanceToEobOrEoln();
            int n4 = this.nextByte - n3;
            if (n4 > byArray.length - (n + n2)) {
                n4 = byArray.length - (n + n2);
                this.nextByte = n3 + n4;
            }
            System.arraycopy(this.fileBuffer, n3, byArray, n + n2, n4);
            if (!bl && (n2 += n4) < byArray.length - n) continue;
        }
        this.ensureBufferNotEmpty();
        return n2;
    }

    private boolean advanceToEobOrEoln() {
        while (this.nextByte < this.numBytes) {
            if (this.atEoln()) {
                return true;
            }
            ++this.nextByte;
        }
        return false;
    }

    private boolean ensureBufferNotEmpty() {
        try {
            if (this.nextByte < this.numBytes) {
                return true;
            }
            this.nextByte = 0;
            this.numBytes = this.in.read(this.fileBuffer);
            this.atEof = this.numBytes < 1;
            return !this.atEof;
        }
        catch (IOException iOException) {
            throw new PicardException("Exception reading InputStream", iOException);
        }
    }
}

